/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.dump.FuncTestTimer;
import com.atlassian.jira.functest.framework.dump.FuncTestTimerImpl;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.functest.framework.util.testcase.TestCaseKit;
import com.atlassian.jira.functest.framework.util.text.MsgOfD;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class TestInformationKit {
    private static long suiteStartTime = System.currentTimeMillis();
    private static long suiteTotalTestCases = 0L;
    private static long suiteRanSoFar = 0L;
    private static long suiteTestErrorCount = 0L;
    private static String currentTestName = null;
    private static TestCaseInfo suiteTotals = new TestCaseInfo("suiteTotals", true, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    private static Map<String, Map<String, TestCaseCounter>> testCaseCounters = new HashMap<String, Map<String, TestCaseCounter>>();
    private static List<String> failingTestCases = new ArrayList<String>();
    private static List<TestCaseInfo> allTestsRun = new ArrayList<TestCaseInfo>();
    private static final String FTC_PREFIX = "===FTC";
    private static final int MAX = 15;

    public static synchronized void startTestSuite(int totalTestCases) {
        suiteTotalTestCases = totalTestCases;
        suiteStartTime = System.currentTimeMillis();
    }

    public static synchronized String getStartMsg(TestCase testCase, String tenant) {
        ++suiteRanSoFar;
        currentTestName = TestCaseKit.getFullName(testCase);
        StringBuilder message = new StringBuilder().append(FTC_PREFIX);
        if (tenant != null) {
            message.append(" (").append(tenant).append(")");
        }
        message.append(" Started : ").append(currentTestName).append(" #").append(suiteRanSoFar).append(" of ").append(suiteTotalTestCases);
        return message.toString();
    }

    public static String getEndMsg(TestCase testCase, String tenant, long runtimeMS) {
        return TestInformationKit.getEndMsg(testCase, tenant, runtimeMS, null, null);
    }

    public static String getEndMsg(TestCase testCase, String tenant, long runtimeMS, FuncTestWebClientListener webClientListener) {
        return TestInformationKit.getEndMsg(testCase, tenant, runtimeMS, webClientListener, null);
    }

    public static String getEndMsg(TestCase testCase, String tenant, long runtimeMS, Throwable problemT) {
        return TestInformationKit.getEndMsg(testCase, tenant, runtimeMS, null, problemT);
    }

    public static synchronized String getEndMsg(TestCase testCase, String tenant, long runtimeMS, FuncTestWebClientListener webClientListener, Throwable problemT) {
        TestCaseInfo testCaseInfo;
        boolean testPassed;
        float runtimeMSF = (float)runtimeMS / 1000.0f;
        float suiteTimeMSF = (float)(System.currentTimeMillis() - suiteStartTime) / 1000.0f;
        DecimalFormat fmt = new DecimalFormat("#0.00");
        String runtimeMsg = runtimeMSF == 1.0f ? "1 second" : fmt.format(runtimeMSF) + " seconds";
        String suitTimeMsg = suiteTimeMSF == 1.0f ? "1 second" : fmt.format(suiteTimeMSF) + " seconds";
        Runtime rt = Runtime.getRuntime();
        boolean bl = testPassed = problemT == null;
        if (!testPassed) {
            ++suiteTestErrorCount;
        }
        DecimalFormat dfPerCent = new DecimalFormat("#0.0#%");
        double perDone = suiteTotalTestCases == 0L ? 0.0 : (double)suiteRanSoFar / (double)suiteTotalTestCases;
        double perErrors = suiteTotalTestCases == 0L ? 0.0 : (double)suiteTestErrorCount / (double)suiteTotalTestCases;
        String testName = TestCaseKit.getFullName(testCase);
        StringBuilder sb = new StringBuilder(FTC_PREFIX);
        if (tenant != null) {
            sb.append(" (").append(tenant).append(")");
        }
        sb.append(" Finished").append(problemT == null ? "" : " FAIL").append(" : ").append(testName).append(" #").append(suiteRanSoFar).append(" of ").append(suiteTotalTestCases).append(" (").append(dfPerCent.format(perDone)).append(")").append(" : Errors ").append(suiteTestErrorCount).append(" (").append(dfPerCent.format(perErrors)).append(")").append(" : Run time ").append(runtimeMsg).append(" : Suite time ").append(suitTimeMsg);
        if (webClientListener != null) {
            long httpRequestCount = webClientListener.getRequestCount();
            long httpTimeMS = webClientListener.getRequestTime();
            long http100thMS = webClientListener.getPercentileRequestTime(100);
            long http90thMS = webClientListener.getPercentileRequestTime(90);
            long http50thMS = webClientListener.getPercentileRequestTime(50);
            double msPerRequest = httpRequestCount == 0L ? 0.0 : (double)httpTimeMS / (double)httpRequestCount;
            long parseTimeNanos = webClientListener.getParseTimeNanos();
            long parseCount = webClientListener.getParseCount();
            sb.append("").append(" : HTTP Count ").append(httpRequestCount).append(" : HTTP Time ").append(httpTimeMS).append("ms").append(" : HTTP Ave ").append(fmt.format(msPerRequest / 1000.0)).append(" ms/request").append(" : HTTP 100th ").append(http100thMS).append("ms").append(" : HTTP 90th ").append(http90thMS).append("ms").append(" : HTTP 50th ").append(http50thMS).append("ms").append(" : Parse Time ").append(parseTimeNanos).append("nanos").append(" : Parse Count ").append(parseCount);
            testCaseInfo = new TestCaseInfo(testName, testPassed, runtimeMS, httpRequestCount, httpTimeMS, http100thMS, http90thMS, http50thMS, parseTimeNanos, parseCount);
            suiteTotals = suiteTotals.add(testCaseInfo);
        } else {
            testCaseInfo = new TestCaseInfo(testName, testPassed, runtimeMS, -1L, -1L, -1L, -1L, -1L, -1L, -1L);
        }
        allTestsRun.add(testCaseInfo);
        sb.append("").append(" : Max Mem ").append(rt.maxMemory()).append(" : Total Mem ").append(rt.totalMemory()).append("  : Free Mem ").append(rt.freeMemory());
        if (problemT != null) {
            sb.append("\n [").append(problemT).append("]");
            TestInformationKit.addFailingTest(testCase);
        }
        if (failingTestCases.size() > 0) {
            sb.append("\n______________________________\n");
            sb.append("Test Failures So Far :\n");
            for (String failingTestCase : failingTestCases) {
                sb.append(FTC_PREFIX).append(" FAIL : ").append(failingTestCase).append("\n");
            }
        }
        sb.append("\n______________________________\n");
        return sb.toString();
    }

    private static void addFailingTest(TestCase testCase) {
        String testName = testCase.getClass().getName() + "." + testCase.getName();
        int size = failingTestCases.size();
        if (size <= 15) {
            if (size == 15) {
                failingTestCases.add("More than 15 failures...");
            } else {
                failingTestCases.add(testName);
            }
        }
    }

    public static synchronized List<TestCaseInfo> getAllTestsRun() {
        return allTestsRun;
    }

    public static synchronized TestCaseInfo getTotals() {
        return suiteTotals;
    }

    public static synchronized void endTestSuite() {
        DecimalFormat fmt = new DecimalFormat("#0.00");
        DecimalFormat dfPerCent = new DecimalFormat("#0.0#%");
        double perErrors = suiteTotalTestCases == 0L ? 0.0 : (double)suiteTestErrorCount / (double)suiteTotalTestCases;
        float suiteTimeSec = (float)(System.currentTimeMillis() - suiteStartTime) / 1000.0f;
        String suitTimeSecMsg = suiteTimeSec == 1.0f ? "1 second" : fmt.format(suiteTimeSec) + " seconds";
        float suiteTimeMins = suiteTimeSec / 60.0f;
        String suitTimeMinsMsg = suiteTimeSec == 1.0f ? "1 minute" : fmt.format(suiteTimeMins) + " minutes";
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("__________________________________________________________________________________________\n").append("\n");
        Collections.sort(allTestsRun);
        for (TestCaseInfo tci : allTestsRun) {
            float runtimeSecF = (float)tci.runtimeMS / 1000.0f;
            String runtimeMsg = runtimeSecF == 1.0f ? "1 second" : fmt.format(runtimeSecF) + " seconds (" + tci.runtimeMS + "ms)";
            double msPerRequest = tci.httpRequestCount == 0L ? 0.0 : (double)tci.httpTimeMS / (double)tci.httpRequestCount;
            sb.append("\t").append(tci.testName).append(" ").append(tci.testPassed ? "PASSED" : "FAILED").append("\n");
            sb.append("\t\t").append((CharSequence)TestInformationKit.padR40("Run Time")).append(" : ").append(runtimeMsg).append("\n");
            sb.append("\t\t").append((CharSequence)TestInformationKit.padR40("HTTP Count")).append(" : ").append(tci.httpRequestCount).append("\n");
            sb.append("\t\t").append((CharSequence)TestInformationKit.padR40("HTTP Time")).append(" : ").append(tci.httpTimeMS).append("ms\n");
            sb.append("\t\t").append((CharSequence)TestInformationKit.padR40("HTTP Ave")).append(" : ").append(fmt.format(msPerRequest / 1000.0)).append(" ms/request ");
            sb.append("\t\t").append("HTTP 100th").append(" : ").append(tci.http100thMS).append("ms ");
            sb.append("\t\t").append("HTTP 90th").append(" : ").append(tci.http90thMS).append("ms ");
            sb.append("\t\t").append("HTTP 50th").append(" : ").append(tci.http50thMS).append("ms ");
            sb.append("\n");
            List<TestCaseCounter> counters = TestInformationKit.getCountersForTest(tci.testName);
            for (TestCaseCounter counter : counters) {
                sb.append("\t\t").append((CharSequence)TestInformationKit.padR40(counter.getName())).append(" : ").append(counter.getValue()).append("\n");
            }
            sb.append("\n");
        }
        StringBuilder sbSummary = new StringBuilder();
        sbSummary.append("\n").append("__________________________________________________________________________________________\n").append("Func Test Suite Summary").append("\n").append("\t").append((CharSequence)TestInformationKit.padR40("Run Time")).append(" : ").append(suitTimeMinsMsg).append(" (").append(suitTimeSecMsg).append(")\n").append("\t").append((CharSequence)TestInformationKit.padR40("Tests Run")).append(" : ").append(suiteTotalTestCases).append("\n").append("\t").append((CharSequence)TestInformationKit.padR40("Errors")).append(" : ").append(suiteTestErrorCount).append(" (").append(dfPerCent.format(perErrors)).append(")\n").append("\n");
        sb.append((CharSequence)sbSummary);
        sb.append(new MsgOfD());
        FuncTestLoggerImpl log = new FuncTestLoggerImpl(0);
        log.log(sb);
    }

    public static List<TestCaseCounter> getCountersForTest(String testName) {
        ArrayList<TestCaseCounter> counters = new ArrayList<TestCaseCounter>();
        Map<String, TestCaseCounter> mapOfCounters = testCaseCounters.get(testName);
        if (mapOfCounters != null) {
            for (String counterName : mapOfCounters.keySet()) {
                counters.add(mapOfCounters.get(counterName));
            }
        }
        return counters;
    }

    private static StringBuilder padR40(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < 40) {
            sb.append(' ');
        }
        return sb;
    }

    public static FuncTestTimer pullTimer(String name) {
        return new FuncTestTimerImpl(name);
    }

    public static void recordCounter(String counterName, long value) {
        if (currentTestName != null) {
            TestCaseCounter testCaseCounter;
            Map<String, TestCaseCounter> counterMap = testCaseCounters.get(currentTestName);
            if (counterMap == null) {
                counterMap = new HashMap<String, TestCaseCounter>();
                testCaseCounters.put(currentTestName, counterMap);
            }
            if ((testCaseCounter = counterMap.get(counterName)) == null) {
                testCaseCounter = new TestCaseCounter(counterName);
                counterMap.put(counterName, testCaseCounter);
            }
            testCaseCounter.update(value);
        }
    }

    public static class TestCaseCounter {
        private final String name;
        private double value;

        private TestCaseCounter(String name) {
            this.name = name;
            this.value = 0.0;
        }

        public double update(double value) {
            this.value += value;
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }
    }

    public static class TestCaseInfo
    implements Comparable {
        private final String testName;
        private final boolean testPassed;
        private final long runtimeMS;
        final long httpRequestCount;
        final long httpTimeMS;
        final long http100thMS;
        final long http90thMS;
        final long http50thMS;
        final long parseTimeNanos;
        final long parseCount;
        final double msPerRequest;

        public TestCaseInfo(String testName, boolean testPassed, long runtimeMS, long httpRequestCount, long httpTimeMS, long http100thMS, long http90thMS, long http50thMS, long parseTimeNanos, long parseCount) {
            this.testName = testName;
            this.testPassed = testPassed;
            this.runtimeMS = runtimeMS;
            this.httpRequestCount = httpRequestCount;
            this.httpTimeMS = httpTimeMS;
            this.http100thMS = http100thMS;
            this.http90thMS = http90thMS;
            this.http50thMS = http50thMS;
            this.msPerRequest = httpRequestCount == 0L ? 0.0 : (double)httpTimeMS / (double)httpRequestCount;
            this.parseTimeNanos = parseTimeNanos;
            this.parseCount = parseCount;
        }

        public int compareTo(Object o) {
            TestCaseInfo that = (TestCaseInfo)o;
            return (int)(this.runtimeMS - that.runtimeMS);
        }

        public String getTestName() {
            return this.testName;
        }

        public boolean isTestPassed() {
            return this.testPassed;
        }

        public long getRuntimeMS() {
            return this.runtimeMS;
        }

        public long getHttpRequestCount() {
            return this.httpRequestCount;
        }

        public long getHttpTimeMS() {
            return this.httpTimeMS;
        }

        public long getHttp100thMS() {
            return this.http100thMS;
        }

        public long getHttp90thMS() {
            return this.http90thMS;
        }

        public long getHttp50thMS() {
            return this.http50thMS;
        }

        public double getMsPerRequest() {
            return this.msPerRequest;
        }

        public long getParseTimeNanos() {
            return this.parseTimeNanos;
        }

        public long getParseTimeMS() {
            float v = (float)this.parseTimeNanos / 1000000.0f;
            return (long)v;
        }

        public long getParseCount() {
            return this.parseCount;
        }

        public TestCaseInfo add(TestCaseInfo right) {
            return new TestCaseInfo(this.getTestName(), true, this.getRuntimeMS() + right.getRuntimeMS(), this.getHttpRequestCount() + right.getHttpRequestCount(), this.getHttpTimeMS() + right.getHttpTimeMS(), 0L, 0L, 0L, this.getParseTimeNanos() + right.getParseTimeNanos(), this.getParseCount() + right.getParseCount());
        }
    }
}

