/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.dump.ArtifactDumper;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.meterware.httpunit.CurrentHttpInformation;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

public class TestCaseDumpKit {
    public static void dumpTestInformation(TestCase testCase, Date when, Throwable thrownException) {
        FuncTestLoggerImpl log = new FuncTestLoggerImpl();
        log.log("\n______ TEST FAILURE ______ \n");
        String responseText = null;
        WebTester tester = ArtifactDumper.getTester(testCase);
        if (tester != null && tester.getDialog() == null) {
            log.log("The WebTester does not have a dialog associated with it?");
        } else {
            responseText = tester.getDialog().getResponseText();
        }
        log.log(thrownException);
        log.log("______________________________ Starting HTML dump");
        CurrentHttpInformation.Info httpInfo = CurrentHttpInformation.getInfo();
        if (httpInfo != null) {
            log.log("URL              : " + httpInfo.getUrl());
            log.log("HTTP METHOD      : " + httpInfo.getRequestMethod());
            log.log("HTTP SC          : " + httpInfo.getStatusCode());
            log.log("HTTP MSG         : " + httpInfo.getStatusMessage());
            TestCaseDumpKit.dumpHeaders(log, "Request", httpInfo.getRequestHeaders());
            TestCaseDumpKit.dumpHeaders(log, "Response", httpInfo.getResponseHeaders());
        }
        TestCaseDumpKit.dumpBody(log, responseText);
        log.log("______________________________ Ending HTML dump \n");
        new ArtifactDumper(testCase, thrownException, when, log);
    }

    private static void dumpHeaders(FuncTestLoggerImpl log, String typeOfHeaders, Map<String, String[]> headers) {
        log.log("" + typeOfHeaders + " Headers : ");
        log.log("________________");
        for (String headerName : headers.keySet()) {
            String[] values;
            StringBuilder sb = new StringBuilder();
            for (String value : values = headers.get(headerName)) {
                sb.append("   ").append(headerName).append(" :").append(" ").append(value);
            }
            log.log(sb);
        }
    }

    private static void dumpBody(FuncTestLoggerImpl log, String responseText) {
        log.log("Last Successful Response Body : ");
        log.log("________________");
        log.log(responseText.trim());
    }
}

