/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.CurrentHttpInformation;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

public class ArtifactDumper {
    private final Throwable failureCause;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLogger logger;
    private static AtomicInteger dumpCount = new AtomicInteger(0);
    private static final int DEFAULT_MAX_DUMPCOUNT = 5;

    public ArtifactDumper(TestCase testCase, Throwable failureCause, Date date, FuncTestLogger logger) {
        this.failureCause = failureCause;
        this.environmentData = ArtifactDumper.getEnviromentData(testCase);
        this.logger = logger == null ? new FuncTestLoggerImpl() : logger;
        this.dumpToFileAndLaunchBrowserMaybe(testCase, date);
    }

    public static WebTester getTester(TestCase testCase) {
        if (testCase instanceof JIRAWebTest) {
            return ((JIRAWebTest)testCase).getTester();
        }
        if (testCase instanceof FuncTestCase) {
            return ((FuncTestCase)testCase).getTester();
        }
        throw new UnsupportedOperationException("We dont supported this class of TestCase " + testCase.getClass().getName() + " : " + testCase.getName());
    }

    public static JIRAEnvironmentData getEnviromentData(TestCase testCase) {
        if (testCase instanceof JIRAWebTest) {
            return ((JIRAWebTest)testCase).getEnvironmentData();
        }
        if (testCase instanceof FuncTestCase) {
            return ((FuncTestCase)testCase).getEnvironmentData();
        }
        throw new UnsupportedOperationException("We dont supported this class of TestCase " + testCase.getClass().getName() + " : " + testCase.getName());
    }

    public static FuncTestWebClientListener getFuncTestWebClientListener(TestCase testCase) {
        if (testCase instanceof JIRAWebTest) {
            return ((JIRAWebTest)testCase).getWebClientListener();
        }
        if (testCase instanceof FuncTestCase) {
            return ((FuncTestCase)testCase).getWebClientListener();
        }
        throw new UnsupportedOperationException("We dont supported this class of TestCase " + testCase.getClass().getName() + " : " + testCase.getName());
    }

    private void dumpToFileAndLaunchBrowserMaybe(TestCase testCase, Date currentDate) {
        String captureDirectory;
        File captureDir;
        String printedStackTrace = "";
        if (this.failureCause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.failureCause.printStackTrace(pw);
            printedStackTrace = sw.toString();
        }
        if (!(captureDir = new File(captureDirectory = EnvironmentUtils.getMavenAwareOutputDir())).exists() && !captureDir.mkdirs()) {
            this.logger.log("Couldnt capture test artifacts to : " + captureDir.getAbsolutePath());
            return;
        }
        List<String> lastResponses = ArtifactDumper.getFuncTestWebClientListener(testCase).getLastResponses();
        File captureFile = null;
        int i = 0;
        String captureFileNamePrefix = this.getFailureFileName(currentDate, testCase);
        for (String lastResponse : lastResponses) {
            File prevFileName = null;
            File nextFileName = null;
            String captureFileName = captureFileNamePrefix + "_" + i + ".html";
            if (i > 0) {
                prevFileName = new File(captureDir, captureFileNamePrefix + "_" + (i - 1) + ".html");
            }
            if (i < lastResponses.size() - 1) {
                nextFileName = new File(captureDir, captureFileNamePrefix + "_" + (i + 1) + ".html");
            }
            File captureFileN = new File(captureDir, captureFileName);
            StringBuffer sb = new StringBuffer();
            int bodyCloseIndex = lastResponse.toLowerCase().indexOf("</body");
            if (bodyCloseIndex == -1) {
                lastResponse = "<!--Original Response Text Follows:\n________________\n" + lastResponse + "________________\n" + "-->\n" + "<html><body>The response does not seem to HTML.  This is a generated message to tell you that</body></html>";
            }
            if ((bodyCloseIndex = lastResponse.toLowerCase().indexOf("</body")) != -1) {
                sb.append(lastResponse.substring(0, bodyCloseIndex));
                sb.append(this.buildPageNavigation(printedStackTrace, i, prevFileName, nextFileName));
                sb.append(lastResponse.substring(bodyCloseIndex));
                lastResponse = sb.toString();
            }
            this.writeToCaptureFile(lastResponse, captureFileN);
            if (i == 0) {
                captureFile = captureFileN;
            }
            ++i;
        }
        if (captureFile != null) {
            this.openInBrowser(captureFile);
        }
    }

    private void writeToCaptureFile(String htmlResponse, File captureFile) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(captureFile));
            pw.print(htmlResponse);
            pw.close();
        }
        catch (IOException e) {
            this.logger.log("Couldnt capture test artifact to : " + captureFile.getAbsolutePath());
        }
    }

    private void openInBrowser(File captureFile) {
        int maxCount;
        int currentCount = dumpCount.incrementAndGet();
        try {
            maxCount = Integer.parseInt(this.environmentData.getProperty("browser.maxopen"));
        }
        catch (NumberFormatException e) {
            maxCount = 5;
        }
        if (maxCount < 0 || currentCount <= maxCount) {
            ArtifactDumper.openBrowser(this.environmentData.getProperty("browser.path"), captureFile, this.logger);
        }
    }

    public static void openBrowser(String command, File captureFile, FuncTestLogger logger) {
        String[] commandWithArgs;
        if (command == null || command.trim().length() == 0) {
            logger.log("A test artifact file has been created here : " + captureFile.getAbsolutePath());
            return;
        }
        if (command.indexOf(" ") != -1) {
            String[] bcmd = command.split(" ");
            commandWithArgs = new String[bcmd.length + 1];
            System.arraycopy(bcmd, 0, commandWithArgs, 0, bcmd.length);
        } else {
            commandWithArgs = new String[2];
            commandWithArgs[0] = command;
        }
        commandWithArgs[commandWithArgs.length - 1] = captureFile.getAbsolutePath();
        try {
            logger.log("Executing command for failing web response - command : " + command + " - captured test artifact : file://" + captureFile.getAbsolutePath());
            Runtime.getRuntime().exec(commandWithArgs);
        }
        catch (IOException e) {
            logger.log(String.format("Failed to execute command : %s with captured test artifact 'file://%s': %s", command, captureFile.getAbsolutePath(), e.getMessage()));
        }
    }

    private String buildPageNavigation(String printedStackTrace, int fileIndex, File prevFile, File nextFile) {
        StringBuffer sb = new StringBuffer();
        sb.append("<script>\n");
        sb.append("function setText(el, text) { while (el.firstChild) { el.removeChild(el.firstChild) } el.appendChild(document.createTextNode(text));  }\n");
        sb.append("function stackTraceShrink() { eShrinkButton = document.getElementById('shrinkButton'); el = document.getElementById('stackTraceDiv'); if (el.className == 'stackTraceDiv') { el.className = 'stackTraceDivShrink'; setText(eShrinkButton,'Expand');  } else { el.className = 'stackTraceDiv'; setText(eShrinkButton,'Shrink'); } }\n");
        sb.append("function stackTraceHide() { el = document.getElementById('stackTraceDiv'); el.style.display = 'none'; }\n");
        sb.append("</script>");
        sb.append("<style>");
        sb.append(".stackTraceDiv {");
        sb.append("width:90%;height:95%;position:absolute;right:5px;top:30px;overflow:scroll;border-style:solid;border-width:1px;border-color:black;background-color:#FFFFE5;");
        sb.append("} \n");
        sb.append(".stackTraceDivShrink {");
        sb.append("width:40%;height:80px;position:absolute;right:5px;top:30px;overflow:scroll;border-style:solid;border-width:1px;border-color:black;background-color:#FFFFE5;");
        sb.append("} \n");
        sb.append(".stackTraceButtonDiv {");
        sb.append("position:absolute; right : 5px; top : 5px;");
        sb.append("} \n");
        sb.append(".stackTraceButton {");
        sb.append("border : 1px orange solid; margin : 1px; padding : 1px; cursor : pointer; background-color : blue; color : white; ");
        sb.append("} \n");
        sb.append(".stackTraceButton a {");
        sb.append("background-color : blue; color : white; ");
        sb.append("} \n");
        sb.append("</style>");
        String shrinkText = "Shrink";
        if (fileIndex == 0) {
            sb.append("<div id=\"stackTraceDiv\" class=\"stackTraceDiv\"> \n");
        } else {
            sb.append("<div id=\"stackTraceDiv\" class=\"stackTraceDivShrink\"> \n");
            shrinkText = "Expand";
        }
        if (fileIndex == 0) {
            sb.append("<h1 style=\"color:red\">Tester Response : " + fileIndex + "</h1> \n");
        } else {
            sb.append("<h3>Tester Response : " + -fileIndex + "</h3> \n");
        }
        CurrentHttpInformation.Info httpInfo = CurrentHttpInformation.getInfo();
        if (httpInfo != null) {
            sb.append("<table><tr><td><a target=\"_newWindow\"href=\"").append(httpInfo.getUrl()).append("\">").append(httpInfo.getUrl()).append("</a></td></tr></table>\n");
        }
        sb.append("<div class=\"stackTraceButtonDiv\"> \n");
        sb.append("<table>\n");
        sb.append("<tr> \n");
        sb.append("<td><div id=\"shrinkButton\" class=\"stackTraceButton\" onclick=\"stackTraceShrink(this)\">" + shrinkText + "</div></td> \n");
        sb.append("<td><div class=\"stackTraceButton\" onclick=\"stackTraceHide(this)\">Hide</div></td> \n");
        sb.append("</tr>\n");
        sb.append("<tr> \n");
        sb.append("<td>");
        if (nextFile != null) {
            sb.append("<div class=\"stackTraceButton\"><a href=\"file://" + nextFile.getAbsolutePath() + "\" >Prev</a></div>");
        }
        sb.append("</td>\n");
        sb.append("<td>");
        if (prevFile != null) {
            sb.append("<div class=\"stackTraceButton\"><a href=\"file://" + prevFile.getAbsolutePath() + "\" >Next</a></div>");
        }
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("</table> \n");
        sb.append("</div> \n");
        sb.append("<pre>");
        sb.append(this.higlightStackTrace(printedStackTrace));
        if (httpInfo != null) {
            sb.append("\n");
            sb.append("HTTP URL    : ").append(httpInfo.getUrl()).append("\n");
            sb.append("HTTP METHOD : ").append(httpInfo.getRequestMethod()).append("\n");
            sb.append("HTTP SC     : ").append(httpInfo.getStatusCode()).append("\n");
            sb.append("HTTP MSG    : ").append(httpInfo.getStatusMessage()).append("\n");
            sb.append(this.printHeaders("Request", httpInfo.getRequestHeaders()));
            sb.append(this.printHeaders("Response", httpInfo.getResponseHeaders()));
        }
        sb.append("</pre>");
        sb.append("</div>");
        return sb.toString();
    }

    private Object printHeaders(String headerTypes, Map<String, String[]> responseHeaders) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(headerTypes).append(" Headers\n");
        for (String headerName : responseHeaders.keySet()) {
            String[] values;
            for (String value : values = responseHeaders.get(headerName)) {
                sb.append("   ").append(headerName).append(":").append(value).append("\n");
            }
        }
        return sb;
    }

    private String getFailureFileName(Date currentDate, TestCase testCase) {
        String testName = testCase == null ? "UnknownTestName.cantFindInStackTrace" : testCase.getClass().getName() + "." + testCase.getName();
        return testName + "_" + new SimpleDateFormat("yyyy-MM-dd--hh-mm-ss-SSSS").format(currentDate);
    }

    private String higlightStackTrace(String printedStackTrace) {
        StringBuffer sb = new StringBuffer();
        StringReader sr = new StringReader(printedStackTrace);
        BufferedReader br = new BufferedReader(sr);
        String testName = null;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                line = TextUtils.htmlEncode((String)line);
                boolean append = true;
                if (testName == null && (testName = this.getTestAndClassName(line)) != null) {
                    sb.append("<strong>");
                    sb.append(line);
                    sb.append("</strong>");
                    append = false;
                }
                if (append) {
                    sb.append(line);
                }
                sb.append("\n");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    private String getTestAndClassName(String line) {
        String methodName;
        int dotIndex;
        int openingBracket;
        String testName = null;
        if ((line = line.trim()).startsWith("at") && (openingBracket = line.indexOf(40)) != -1 && (dotIndex = line.lastIndexOf(46, openingBracket)) != -1 && (methodName = line.substring(dotIndex + 1, openingBracket)).indexOf("test") == 0) {
            testName = methodName;
            int classDotIndex = line.lastIndexOf(46, dotIndex - 1);
            if (classDotIndex != -1) {
                String className = line.substring(classDotIndex + 1, dotIndex);
                testName = className + "." + testName;
            }
        }
        return testName;
    }
}

