/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.URLAssertions;
import com.atlassian.jira.functest.framework.util.url.ParsedURL;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.net.URL;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class URLAssertionsImpl
extends AbstractFuncTestUtil
implements URLAssertions {
    public URLAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public void assertCurrentURLPathEndsWith(String expectedEnd) {
        String actualPath = this.getCurrentURL().getPath();
        Assert.assertTrue((String)("Expected path to end with '" + expectedEnd + "' but was '" + actualPath + "'."), (boolean)actualPath.endsWith(expectedEnd));
    }

    @Override
    public void assertCurrentURLEndsWith(String expectedEnd) {
        String actualPath = this.getCurrentURL().toExternalForm();
        Assert.assertTrue((String)("Expected url to end with '" + expectedEnd + "' but was '" + actualPath + "'."), (boolean)actualPath.endsWith(expectedEnd));
    }

    @Override
    public void assertCurrentURLMatchesRegex(String regex) {
        String actualPath = this.getCurrentURL().toExternalForm();
        Assert.assertTrue((String)("Current URL '" + actualPath + "' did not match regular expression '" + regex + "'."), (boolean)actualPath.matches(regex));
    }

    @Override
    public void assertURLAreSimilair(String msg, String expectedURL, String actualURL) {
        ParsedURL parsedURL1 = new ParsedURL(expectedURL);
        ParsedURL parsedURL2 = new ParsedURL(actualURL);
        Assert.assertEquals((String)(msg + " - not the same path! URL1:'" + parsedURL1 + "' URL2:'" + parsedURL2 + "'"), (String)parsedURL1.getPath(), (String)parsedURL2.getPath());
        Assert.assertEquals((String)(msg + " - not the same query params! URL1:'" + parsedURL1 + "' URL2:'" + parsedURL2 + "'"), parsedURL1.getMultiQueryParameters(), parsedURL2.getMultiQueryParameters());
    }

    private URL getCurrentURL() {
        return this.tester.getDialog().getResponse().getURL();
    }
}

