/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin.user.shared;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.shared.SharedDashboardsAdministration;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardItem;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardTableParser;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;

public class DefaultSharedDashboardsAdministration
implements SharedDashboardsAdministration {
    private static final String SHARED_FILTERS_ADMINISTRATION_LINK_ID = "shared_dashboards";
    private static final String DELETE_PORTAL_PAGE = "delete-portal-page";
    private final WebTester tester;
    private final Navigation navigation;
    private final LocatorFactory locators;

    public DefaultSharedDashboardsAdministration(WebTester tester, Navigation navigation, LocatorFactory locators) {
        this.tester = tester;
        this.navigation = navigation;
        this.locators = locators;
    }

    @Override
    public SharedDashboardsAdministration goTo() {
        this.navigation.gotoAdminSection(SHARED_FILTERS_ADMINISTRATION_LINK_ID);
        return this;
    }

    @Override
    public SharedDashboardsAdministration search(String searchText, String owner) {
        this.tester.setWorkingForm("search-dashboards-form");
        this.tester.setFormElement("searchName", searchText);
        this.tester.setFormElement("searchOwnerUserName", owner);
        this.tester.submit();
        return this;
    }

    @Override
    public SharedDashboardsAdministration searchAll() {
        return this.search("", "");
    }

    @Override
    public SharedDashboardsAdministration.Dashboards dashboards() {
        return new DefaultDashboards(this.locators);
    }

    @Override
    public SharedDashboardsAdministration deleteDashboard(long dashboardId) {
        this.tester.clickLink(this.getDeleteLinkIdForDashboard(dashboardId));
        this.tester.setWorkingForm(DELETE_PORTAL_PAGE);
        this.tester.submit();
        return this;
    }

    @Override
    public SharedDashboardsAdministration changeDashboardOwner(long dashboardId, String newOwner) {
        this.tester.clickLink(this.getChangeOwnerLinkIdForDashboard(dashboardId));
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, this.getChangeOwnerFormForDashboardId(dashboardId), "ChangeOwner");
        formParameterUtil.addOptionToHtmlSelect("owner", new String[]{newOwner});
        formParameterUtil.setFormElement("owner", newOwner);
        formParameterUtil.submitForm();
        this.tester.reset();
        return this.goTo().searchAll();
    }

    private String getDeleteLinkIdForDashboard(long dashboardId) {
        return "delete_" + dashboardId;
    }

    private String getChangeOwnerLinkIdForDashboard(long dashboardId) {
        return "change_owner_" + dashboardId;
    }

    private String getDeleteConfirmationFormForDashboardId(long dashboardId) {
        return "delete-portal-page-" + dashboardId;
    }

    private String getChangeOwnerFormForDashboardId(long dashboardId) {
        return "change-owner-form-" + dashboardId;
    }

    public static class DefaultDashboards
    implements SharedDashboardsAdministration.Dashboards {
        private final LocatorFactory locators;

        public DefaultDashboards(LocatorFactory locators) {
            this.locators = locators;
        }

        @Override
        public List<DashboardItem> list() {
            return new DashboardTableParser(this.locators).parse("pp_browse");
        }
    }
}

