/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin.plugins;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.admin.plugins.ReferencePluginModule;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.io.IOException;
import net.sourceforge.jwebunit.WebTester;

public class RestResources
extends ReferencePluginModule {
    private static final String MODULE_KEY = "reference-plugin-resources";
    private static final String MODULE_NAME = "Reference REST endpointless resource";
    private final WebTester tester;
    private final EndPoint endPoint;

    public RestResources(WebTester tester, Administration administration) {
        super(administration);
        this.tester = tester;
        this.endPoint = new EndPoint(tester);
    }

    @Override
    public String moduleKey() {
        return MODULE_KEY;
    }

    @Override
    public String moduleName() {
        return MODULE_NAME;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    private class UnReachableResource {
        public static final int RESPONSE_CODE = 404;

        private UnReachableResource() {
        }
    }

    public class EndPoint {
        private static final String URL = "/rest/reference-plugin/1.0/endpoint";
        private final WebTester tester;

        public EndPoint(WebTester tester) {
            this.tester = tester;
        }

        public String url() {
            return URL;
        }

        public JSONObject get() throws JSONException {
            try {
                this.tester.gotoPage(this.url());
                return new JSONObject(this.tester.getDialog().getResponse().getText());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isReachable() {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this.tester.gotoPage(this.url());
            return this.tester.getDialog().getResponse().getResponseCode() != 404;
        }
    }
}

