/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.admin.WorkflowTransition;
import com.atlassian.jira.functest.framework.admin.WorkflowTransitionImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import net.sourceforge.jwebunit.WebTester;

public class WorkflowStepsImpl
extends AbstractFuncTestUtil
implements WorkflowSteps {
    private static final String TRANSITION_LINK_ID_TEMPLATE = "edit_action_%d_%d";
    private static final String ADD_TRANSITION_LINK_PREFIX = "add_trans_";
    private final WorkflowTransition transition;

    public WorkflowStepsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
        this.transition = new WorkflowTransitionImpl(tester, environmentData, this.childLogIndentLevel());
    }

    @Override
    public WorkflowTransition editTransition(int stepId, int transitionId) {
        this.tester.clickLink(this.transitionLinkLocatorFor(stepId, transitionId));
        return this.transition;
    }

    @Override
    public WorkflowSteps add(String stepName, String linkedStatus) {
        this.tester.setFormElement("stepName", stepName);
        if (linkedStatus != null) {
            this.tester.selectOption("stepStatus", linkedStatus);
        }
        this.tester.submit("Add");
        return this;
    }

    @Override
    public WorkflowSteps addTransition(String stepName, String transitionName, String transitionDescription, String destinationStep, String transitionFieldScreen) {
        this.tester.clickLink(ADD_TRANSITION_LINK_PREFIX + this.getStepId(stepName));
        this.tester.setFormElement("transitionName", transitionName);
        this.tester.setFormElement("description", transitionDescription);
        this.tester.selectOption("destinationStep", destinationStep);
        if (transitionFieldScreen != null) {
            this.tester.selectOption("view", transitionFieldScreen);
        }
        this.tester.submit("Add");
        return this;
    }

    private String getStepId(String stepName) {
        WebLink[] links = new HtmlPage(this.tester).getLinksWithExactText(stepName);
        if (links != null) {
            String workflowStepLinkId = links[0].getID();
            return workflowStepLinkId.substring(10);
        }
        return "not found";
    }

    private String transitionLinkLocatorFor(int stepId, int transitionId) {
        return String.format(TRANSITION_LINK_ID_TEMPLATE, stepId, transitionId);
    }
}

