/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.DefaultRoleDetails;
import com.atlassian.jira.functest.framework.admin.RoleDetails;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRoleClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class RolesImpl
extends AbstractFuncTestUtil
implements Roles {
    private static final String DELETE_ROLE = "/secure/project/DeleteProjectRole!default.jspa?id=";
    private static final String ADD_ROLE = "/secure/project/UserRoleActorAction!addUsers.jspa?projectRoleId=";
    private RoleDetails roleDetails;

    public RolesImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
        this.roleDetails = new DefaultRoleDetails(tester);
    }

    @Override
    public void delete(long roleId) {
        this.log("Deleting project role " + roleId);
        this.tester.gotoPage(DELETE_ROLE + roleId);
        this.tester.submit("Delete");
    }

    @Override
    public void delete(String name) {
        this.log("Deleting project role:" + name);
        this.gotoProjectRolesScreen();
        this.tester.clickLink("delete_" + name);
        this.tester.submit("Delete");
    }

    private void gotoProjectRolesScreen() {
        if (new IdLocator(this.tester, "adminMenu").getNodes().length == 0) {
            this.getFuncTestHelperFactory().getNavigation().gotoAdmin();
        }
        this.tester.clickLink("project_role_browser");
    }

    @Override
    public void create(String name, String description) {
        this.gotoProjectRolesScreen();
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent(name);
        this.tester.assertTextPresent(description);
    }

    @Override
    public RoleDetails edit(String name) {
        this.gotoProjectRolesScreen();
        this.tester.clickLink("edit_" + name);
        return this.roleDetails;
    }

    private Project getProjectByName(String projectName) {
        ProjectClient projectClient = new ProjectClient(this.environmentData);
        List<Project> projects = projectClient.getProjects();
        for (Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return project;
        }
        return null;
    }

    private void addUserToProjectRole(String userName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        if (projectByName == null) {
            Assert.fail((String)("A project with the name '" + projectName + "' does not exist."));
        }
        ProjectRoleClient projectRoleClient = new ProjectRoleClient(this.environmentData);
        Response response = projectRoleClient.addActors(projectByName.key, roleName, null, new String[]{userName});
    }

    @Override
    public void addProjectRoleForUser(String projectName, String roleName, String userName) {
        this.addUserToProjectRole(userName, projectName, roleName);
    }
}

