/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Component;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ComponentClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.VersionClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class ProjectImpl
extends AbstractFuncTestUtil
implements Project {
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("projectId=(\\d+)");
    private final Navigation navigation;
    private final Assertions assertions;
    private final AsynchronousTasks asynchronousTasks;
    private final HtmlPage htmlPage;

    public ProjectImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Assertions assertions, AsynchronousTasks asynchronousTasks) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
        this.assertions = assertions;
        this.asynchronousTasks = asynchronousTasks;
        this.htmlPage = new HtmlPage(tester);
    }

    @Override
    public long addProject(String name, String key, String lead) {
        if (this.projectExists(name)) {
            this.log("Project " + name + " exists ");
            this.navigation.gotoPage("/plugins/servlet/project-config/" + key.toUpperCase() + "/summary");
        } else {
            this.log("Adding project " + name);
            StringBuilder builder = new StringBuilder("/secure/admin/AddProject.jspa");
            this.addUrlParameter(builder, "name", name);
            this.addUrlParameter(builder, "key", key);
            this.addUrlParameter(builder, "lead", lead);
            this.addUrlParameter(builder, "permissionScheme", 0);
            this.addUrlParameter(builder, "assigneeType", 2);
            this.tester.gotoPage(this.htmlPage.addXsrfToken(builder.toString()));
            this.assertions.getURLAssertions().assertCurrentURLPathEndsWith(this.getEnvironmentData().getContext() + "/plugins/servlet/project-config/" + key.toUpperCase() + "/summary");
        }
        try {
            String text = this.tester.getDialog().getResponse().getText();
            Matcher matcher = PROJECT_ID_PATTERN.matcher(text);
            if (!matcher.find()) {
                Assert.fail((String)"Could not find projectId on result page.");
            }
            return Long.parseLong(matcher.group(1));
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return -1L;
        }
    }

    @Override
    public void viewProject(String project) {
        this.navigation.gotoAdmin();
        this.tester.clickLink("view_projects");
        if (this.htmlPage.isLinkPresentWithExactText(project)) {
            this.navigation.clickLinkWithExactText(project);
        } else {
            Assert.fail((String)("Cannot find link to project with name '" + project + "'"));
        }
    }

    @Override
    public void editProject(long projectId, String name, String description, String url) {
        this.tester.gotoPage("/secure/project/EditProject!default.jspa?pid=" + projectId);
        this.tester.assertTextPresent("action=\"EditProject.jspa\"");
        if (name != null) {
            this.tester.setFormElement("name", name);
        }
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        if (url != null) {
            this.tester.setFormElement("url", url);
        }
        this.tester.submit();
        if (name != null) {
            this.assertions.getTextAssertions().assertTextPresent(this.locators.id("project-config-header-name"), name);
        }
        if (description != null) {
            this.assertions.getTextAssertions().assertTextPresent(this.locators.id("project-config-description"), description);
        }
        if (url != null) {
            this.assertions.getTextAssertions().assertTextPresent(this.locators.id("project-config-details-project-url"), url);
        }
    }

    @Override
    public void deleteProject(long projectId) {
        this.tester.gotoPage("/secure/admin/DeleteProject!default.jspa?pid=" + projectId);
        this.tester.submit("Delete");
    }

    @Override
    public void deleteProject(String project) {
        String key = this.getProjectKeyFromName(project);
        this.tester.gotoPage("/plugins/servlet/project-config/" + key + "/summary");
        this.tester.clickLink("delete_project");
        this.tester.assertTextPresent("Delete Project: " + project);
        this.tester.submit("Delete");
    }

    @Override
    public String addComponent(String projectKey, String componentName, String description, String leadUserName) {
        ComponentClient componentClient = new ComponentClient(this.environmentData);
        Component component = componentClient.create(new Component().project(projectKey).name(componentName).description(description).leadUserName(leadUserName));
        return "" + component.id;
    }

    @Override
    public String addVersion(String projectKey, String versionName, String description, String releaseDate) {
        VersionClient versionClient = new VersionClient(this.environmentData);
        Version version = new Version();
        version.project(projectKey).name(versionName).description(description).userReleaseDate(releaseDate);
        Version newVersion = versionClient.create(version);
        return "" + newVersion.id;
    }

    private String getProjectKeyFromName(String projectName) {
        ProjectClient projectClient = new ProjectClient(this.environmentData);
        List<com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project> projects = projectClient.getProjects();
        for (com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return project.key;
        }
        return null;
    }

    private Version getVersionByName(String projectKey, String versionName) {
        ProjectClient projectClient = new ProjectClient(this.environmentData);
        List<com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project> projects = projectClient.getProjects();
        List<Version> versions = projectClient.getVersions(projectKey);
        for (Version version : versions) {
            if (!version.name.equals(versionName)) continue;
            return version;
        }
        return null;
    }

    private Component getComponentByname(String projectKey, String componentName) {
        ProjectClient projectClient = new ProjectClient(this.environmentData);
        List<Component> components = projectClient.getComponents(projectKey);
        for (Component component : components) {
            if (!component.name.equals(componentName)) continue;
            return component;
        }
        return null;
    }

    @Override
    public void archiveVersion(String projectKey, String versionName) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient(this.environmentData);
        versionClient.putResponse(versionByName.archived(true));
    }

    @Override
    public void releaseVersion(String projectKey, String versionName, String releaseDate) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient(this.environmentData);
        versionClient.putResponse(versionByName.released(true).userReleaseDate(releaseDate));
    }

    @Override
    public void unreleaseVersion(String projectKey, String versionName, String releaseDate) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient(this.environmentData);
        versionClient.putResponse(versionByName.released(false).userReleaseDate(releaseDate));
    }

    @Override
    public void deleteVersion(String projectKey, String versionName) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        VersionClient versionClient = new VersionClient(this.environmentData);
        versionClient.delete("" + versionByName.id);
    }

    @Override
    public void editVersionDetails(String projectKey, String versionName, String name, String description, String releaseDate) {
        Version versionByName = this.getVersionByName(projectKey, versionName);
        if (name != null) {
            versionByName.name(name);
        }
        if (description != null) {
            versionByName.description(description);
        }
        if (releaseDate != null) {
            versionByName.userReleaseDate(releaseDate);
        }
        VersionClient versionClient = new VersionClient(this.environmentData);
        versionClient.putResponse(versionByName);
    }

    @Override
    public void editComponent(String projectKey, String componentName, String name, String description, String leadUserName) {
        ComponentClient componentClient = new ComponentClient(this.environmentData);
        Component component = this.getComponentByname(projectKey, componentName);
        if (name != null) {
            component.name(name);
        }
        if (description != null) {
            component.description(description);
        }
        if (leadUserName != null) {
            component.leadUserName(leadUserName);
        }
        componentClient.putResponse(component);
    }

    @Override
    public void associateFieldConfigurationScheme(String projectName, String newFieldConfigurationSchemeName) {
        String projectKey = this.getProjectKeyFromName(projectName);
        this.tester.gotoPage("/plugins/servlet/project-config/" + projectKey + "/fields");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.tester.setWorkingForm("jiraform");
        if (newFieldConfigurationSchemeName == null) {
            newFieldConfigurationSchemeName = "System Default Field Configuration";
        }
        this.tester.selectOption("schemeId", newFieldConfigurationSchemeName);
        this.tester.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", newFieldConfigurationSchemeName);
    }

    @Override
    public void associateWorkflowScheme(String projectName, String workflowSchemeName, Map<String, String> statusMapping, boolean wait) {
        boolean thereAreIssuesToMigrate;
        String projectKey = this.getProjectKeyFromName(projectName);
        this.tester.gotoPage("/plugins/servlet/project-config/" + projectKey + "/workflows");
        this.tester.clickLink("project-config-workflows-scheme-change");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("schemeId", workflowSchemeName);
        this.tester.submit("Associate");
        boolean bl = thereAreIssuesToMigrate = !this.locators.css(".jiraform").getText().contains("There are no issues to migrate.");
        if (statusMapping != null && !statusMapping.isEmpty()) {
            for (Map.Entry<String, String> entry : statusMapping.entrySet()) {
                this.tester.selectOption(entry.getKey(), entry.getValue());
            }
        }
        this.tester.submit("Associate");
        if (thereAreIssuesToMigrate && wait) {
            this.waitForWorkflowMigration(1000L, 100);
        }
    }

    @Override
    public void associateWorkflowScheme(String projectName, String workflowSchemeName) {
        this.associateWorkflowScheme(projectName, workflowSchemeName, null, true);
    }

    @Override
    public void associateNotificationScheme(String projectName, String notificationSchemeName) {
        this.tester.gotoPage("/plugins/servlet/project-config/" + projectName + "/notifications");
        this.tester.clickLink("project-config-notification-scheme-change");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("schemeIds", notificationSchemeName);
        this.tester.submit("Associate");
    }

    private void waitForWorkflowMigration(long sleepTime, int retryCount) {
        this.asynchronousTasks.waitForSuccessfulCompletion(sleepTime, retryCount, "Workflow Migration");
    }

    @Override
    public void setProjectLead(String projectName, String userName) {
        String keyFromName = this.getProjectKeyFromName(projectName);
        this.tester.gotoPage("/plugins/servlet/project-config/" + keyFromName + "/people");
        this.tester.clickLink("edit_project_lead");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "project-edit-lead-and-default-assignee", "Update");
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{userName});
        formParameterUtil.setFormElement("lead", userName);
        formParameterUtil.submitForm();
    }

    @Override
    public boolean projectExists(String project) {
        this.log("Checking if project '" + project + "' exists");
        this.navigation.gotoAdmin();
        this.tester.clickLink("view_projects");
        return this.htmlPage.isLinkPresentWithExactText(project);
    }

    private String encode(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private StringBuilder addUrlParameter(StringBuilder builder, String name, Object value) {
        if (builder.indexOf("?") >= 0) {
            builder.append("&");
        } else {
            builder.append("?");
        }
        return builder.append(this.encode(name)).append("=").append(this.encode(String.valueOf(value)));
    }
}

