/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.Validate;

public interface IssueSecurityLevel {
    public IssueSecuritySchemes.IssueSecurityScheme scheme();

    public IssueSecurityLevel addIssueSecurity(IssueSecurity var1);

    public IssueSecurityLevel addIssueSecurity(IssueSecurity var1, String var2);

    public static enum IssueSecurity {
        REPORTER("reporter", false),
        CURRENT_ASIGNEE("assignee", false),
        PROJECT_LEAD("lead", false),
        GROUP("group", true){

            @Override
            void addParameter(WebTester tester, String paramValue) {
                Validate.notNull((Object)"paramValue", (String)paramValue);
                tester.selectOption(this.typeId(), paramValue);
            }
        }
        ,
        USER("user", true){

            @Override
            void addParameter(WebTester tester, String paramValue) {
                Validate.notNull((Object)"paramValue", (String)paramValue);
                tester.setFormElement(this.typeId(), paramValue);
            }
        };

        private static final String ISSUE_SECURITY_TYPE_RADIO_NAME = "type";
        private final String typeId;
        private final boolean hasParameter;

        private IssueSecurity(String typeId, boolean hasParameter) {
            this.typeId = typeId;
            this.hasParameter = hasParameter;
        }

        public String typeId() {
            return this.typeId;
        }

        public boolean hasParameter() {
            return this.hasParameter;
        }

        final void chooseOnForm(WebTester tester) {
            if (this.hasParameter) {
                throw new IllegalStateException("this may be called ONLY for parameterless types");
            }
            this.chooseOnForm(tester, null);
        }

        final void chooseOnForm(WebTester tester, String paramValue) {
            if (!this.hasParameter && paramValue != null) {
                throw new IllegalArgumentException("param provided for parameterless issue security type");
            }
            tester.getDialog().setFormParameter(ISSUE_SECURITY_TYPE_RADIO_NAME, this.typeId);
            if (this.hasParameter) {
                this.addParameter(tester, paramValue);
            }
        }

        void addParameter(WebTester tester, String paramValue) {
            throw new AbstractMethodError("should be implemented in relevant enum values");
        }
    }
}

