/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.IssueLinking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import net.sourceforge.jwebunit.WebTester;

public class IssueLinkingImpl
implements IssueLinking {
    private final WebTester tester;
    private final Navigation navigation;
    private final FuncTestLogger logger;

    public IssueLinkingImpl(WebTester tester, Navigation navigation, FuncTestLogger logger) {
        this.tester = tester;
        this.navigation = navigation;
        this.logger = logger;
    }

    @Override
    public void enable() {
        this.navigation.gotoAdminSection("linking");
        XPathLocator locator = new XPathLocator(this.tester, "//input[@name='Activate']");
        if (locator.getNodes().length > 0) {
            this.logger.log("Activating issue linking");
            this.tester.submit("Activate");
        } else {
            this.logger.log("Issue linking already activated");
        }
    }

    @Override
    public void disable() {
        this.navigation.gotoAdminSection("linking");
        XPathLocator locator = new XPathLocator(this.tester, "//input[@name='Deactivate']");
        if (locator.getNodes().length > 0) {
            this.logger.log("Deactivating issue linking");
            this.tester.submit("Deactivate");
        } else {
            this.logger.log("Issue linking already deactivated");
        }
    }

    @Override
    public void addIssueLink(String name, String outward, String inward) {
        this.navigation.gotoAdminSection("linking");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("outward", outward);
        this.tester.setFormElement("inward", inward);
        this.tester.submit("Add");
    }

    @Override
    public void delete(String name) {
        this.navigation.gotoAdminSection("linking");
        this.tester.clickLink("del_" + name);
        this.tester.submit("Delete");
    }

    @Override
    public boolean exists(String name) {
        this.navigation.gotoAdminSection("linking");
        return this.tester.getDialog().isLinkPresent("del_" + name);
    }
}

