/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.DefaultEditPopServerConfiguration;
import com.atlassian.jira.functest.framework.admin.EditPopServerConfiguration;
import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Node;

public class DefaultMailServerAdministration
implements MailServerAdministration {
    private static final String MAIL_SERVERS_ADMINISTRATION_LINK_ID = "mail_servers";
    private final Navigation navigation;
    private final MailServerAdministration.SmtpMailServerAdministration smtpMailServerAdministration;
    private final MailServerAdministration.PopMailServerAdministration popMailServerAdministration;

    public DefaultMailServerAdministration(WebTester tester, Navigation navigation, LocatorFactory locator) {
        this.navigation = navigation;
        this.smtpMailServerAdministration = new DefaultSmtpMailServerAdministration(this, tester, locator);
        this.popMailServerAdministration = new DefaultPopMailServerAdministration(this, locator, tester);
    }

    @Override
    public MailServerAdministration goTo() {
        this.navigation.gotoAdminSection(MAIL_SERVERS_ADMINISTRATION_LINK_ID);
        return this;
    }

    @Override
    public MailServerAdministration.SmtpMailServerAdministration Smtp() {
        return this.smtpMailServerAdministration;
    }

    @Override
    public MailServerAdministration.PopMailServerAdministration Pop() {
        return this.popMailServerAdministration;
    }

    public static class DefaultPopMailServerAdministration
    implements MailServerAdministration.PopMailServerAdministration {
        private MailServerAdministration mailServerAdministration;
        private final LocatorFactory locator;
        private WebTester tester;

        public DefaultPopMailServerAdministration(MailServerAdministration mailServerAdministration, LocatorFactory locator, WebTester tester) {
            this.mailServerAdministration = mailServerAdministration;
            this.locator = locator;
            this.tester = tester;
        }

        @Override
        public MailServerAdministration add(String name, String hostName, String userName, String password) {
            this.tester.clickLink("add-pop-mail-server");
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("name", name);
            this.tester.setFormElement("serverName", hostName);
            this.tester.setFormElement("username", userName);
            this.tester.setFormElement("password", password);
            this.tester.submit("Add");
            return this.mailServerAdministration;
        }

        @Override
        public boolean isPresent() {
            return this.locator.css("#pop-mail-servers-panel").exists();
        }

        @Override
        public List<MailServerAdministration.MailServerConfiguration> list() {
            CssLocator popMailServersItemsLocator = this.locator.css("#pop-mail-servers-table tr");
            ArrayList<MailServerAdministration.MailServerConfiguration> results = new ArrayList<MailServerAdministration.MailServerConfiguration>();
            if (this.isEmpty()) {
                return Collections.emptyList();
            }
            for (Node mailServerRow : popMailServersItemsLocator.getNodes()) {
                if (this.isMailServerTableHeader(mailServerRow)) continue;
                MailServerAdministration.MailServerConfiguration mailServerConfigurationForRow = new MailServerAdministration.MailServerConfiguration(this.extractServerName(mailServerRow), this.extractHost(mailServerRow), this.extractUserName(mailServerRow));
                results.add(mailServerConfigurationForRow);
            }
            return results;
        }

        @Override
        public EditPopServerConfiguration edit(String mailServerName) {
            Node mailServerRow = this.discoverRowInServersTableFor(mailServerName);
            XPathLocator editServerLinkLocator = new XPathLocator(mailServerRow, "//*[contains(@id,'edit-pop')]");
            String editServerLinkId = editServerLinkLocator.getNode().getAttributes().getNamedItem("id").getNodeValue();
            this.tester.clickLink(editServerLinkId);
            return new DefaultEditPopServerConfiguration(this.mailServerAdministration, this.tester);
        }

        @Override
        public MailServerAdministration delete(String mailServerName) {
            Node mailServerRow = this.discoverRowInServersTableFor(mailServerName);
            XPathLocator deleteServerLinkLocator = new XPathLocator(mailServerRow, "//*[contains(@id,'delete-pop')]");
            String deleteServerLinkId = deleteServerLinkLocator.getNode().getAttributes().getNamedItem("id").getNodeValue();
            this.tester.clickLink(deleteServerLinkId);
            this.tester.submit("Delete");
            return this.mailServerAdministration;
        }

        private Node discoverRowInServersTableFor(String mailServerName) {
            XPathLocator serverRowsLocator = this.locator.xpath("//*[@id='pop-mail-servers-table']//*[@class='mail-server-name']");
            Node serverRowNodeToFind = null;
            for (Node serverRow : serverRowsLocator.getNodes()) {
                if (!serverRowsLocator.getText(serverRow).equals(mailServerName)) continue;
                serverRowNodeToFind = serverRow.getParentNode().getParentNode();
                break;
            }
            if (serverRowNodeToFind == null) {
                throw new CouldNotFindPopMailServerException(String.format("The specified POP/IMAP Server could not be found on the page. Server Name: %s", mailServerName));
            }
            return serverRowNodeToFind;
        }

        private boolean isEmpty() {
            return this.locator.css("#pop-mail-servers-table tr td").getText().equals("You do not currently have any POP / IMAP servers configured.");
        }

        private boolean isMailServerTableHeader(Node mailServerRow) {
            return new CssLocator(mailServerRow, "th").exists();
        }

        private String extractServerName(Node mailServerRow) {
            return new CssLocator(mailServerRow, "td .mail-server-name").getText();
        }

        private String extractHost(Node mailServerRow) {
            return new CssLocator(mailServerRow, "td .mail-server-host").getText();
        }

        private String extractUserName(Node mailServerRow) {
            return new CssLocator(mailServerRow, "td .mail-server-username").getText();
        }

        private class CouldNotFindPopMailServerException
        extends RuntimeException {
            public CouldNotFindPopMailServerException(String message) {
                super(message);
            }
        }
    }

    public static class DefaultSmtpMailServerAdministration
    implements MailServerAdministration.SmtpMailServerAdministration {
        private final MailServerAdministration mailServerAdministration;
        private final WebTester tester;
        private final LocatorFactory locator;

        public DefaultSmtpMailServerAdministration(MailServerAdministration mailServerAdministration, WebTester tester, LocatorFactory locator) {
            this.mailServerAdministration = mailServerAdministration;
            this.tester = tester;
            this.locator = locator;
        }

        @Override
        public boolean isPresent() {
            return this.locator.css("#smtp-mail-servers-panel").exists();
        }

        @Override
        public boolean isConfigured() {
            if (this.isPresent()) {
                return this.locator.css("#smtp-mail-servers-panel tr td").getText().equals("You do not currently have an SMTP server configured. No outgoing mail will be sent.");
            }
            return false;
        }

        @Override
        public MailServerAdministration add(String name, String fromAddress, String emailPrefix, String hostName) {
            this.tester.clickLink("add-new-smtp-server");
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("name", name);
            this.tester.setFormElement("from", fromAddress);
            this.tester.setFormElement("prefix", emailPrefix);
            this.tester.setFormElement("serverName", hostName);
            this.tester.submit("Add");
            return this.mailServerAdministration;
        }

        @Override
        public MailServerAdministration.MailServerConfiguration get() {
            throw new NotImplementedException("Not implemented yet");
        }
    }
}

