/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.net.URL;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomFieldsImpl
extends AbstractFuncTestUtil
implements CustomFields {
    private final Navigation navigation;
    private final Form form;

    public CustomFieldsImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Form form) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
        this.form = form;
    }

    @Override
    public String addCustomField(String fieldType, String fieldName) {
        return this.addCustomField(fieldType, fieldName, new String[0], new String[0]);
    }

    @Override
    public String addCustomField(String fieldType, String fieldName, String[] issueTypes, String[] projects) {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink("add_custom_fields");
        this.tester.setFormElement("fieldType", fieldType);
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", fieldName);
        if (issueTypes.length == 0) {
            this.form.selectOption("issuetypes", "Any issue type");
        } else {
            this.form.selectOptionsByValue("issuetypes", issueTypes);
        }
        if (projects.length == 0) {
            this.tester.checkCheckbox("global", "true");
        } else {
            this.tester.checkCheckbox("global", "false");
        }
        this.form.selectOptionsByValue("projects", projects);
        this.tester.submit("nextBtn");
        String customFieldId = this.getQueryParamValueFromResponse("fieldId");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        return customFieldId;
    }

    @Override
    public String setCustomFieldSearcher(String customFieldId, String searcherKey) {
        if (searcherKey == null) {
            searcherKey = "-1";
        }
        this.tester.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + customFieldId);
        this.tester.setWorkingForm("jiraform");
        String oldSearcher = this.tester.getDialog().getForm().getParameterValue("searcher");
        this.tester.setFormElement("searcher", searcherKey);
        this.tester.submit("Update");
        return oldSearcher;
    }

    @Override
    public String renameCustomField(String numericCustomFieldId, String newCustomFieldName) {
        this.tester.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + numericCustomFieldId);
        this.tester.setWorkingForm("jiraform");
        String oldName = this.tester.getDialog().getForm().getParameterValue("name");
        this.tester.setFormElement("name", newCustomFieldName);
        this.tester.submit("Update");
        return oldName;
    }

    @Override
    public String addConfigurationSchemeContext(String customFieldId, String label, String[] issueTypeIds, String[] projectIds) {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink("config_customfield_" + customFieldId);
        this.tester.clickLinkWithText("Add new context");
        this.updateConfigurationSchemeContext(label, issueTypeIds, projectIds, true);
        return this.getSchemeIdForLabel(customFieldId, label);
    }

    private String getSchemeIdForLabel(String numericCustomFieldId, String label) {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink("config_customfield_" + numericCustomFieldId);
        XPathLocator locator = new XPathLocator(this.tester, "//td[@class='jiraformheader']/h3[text() = '" + label + "']");
        if (!locator.exists()) {
            Assert.fail((String)("Could not find label '" + label + "' for custom field '" + numericCustomFieldId + "'"));
            return null;
        }
        Element table = DomKit.getFirstParentByTag((Element)locator.getNodes()[0], "table");
        String schemeTableId = table.getAttribute("id");
        return schemeTableId.substring(12);
    }

    @Override
    public void editConfigurationSchemeContextById(String customFieldId, String fieldConfigSchemeId, String label, String[] issueTypeIds, String[] projectIds) {
        this.tester.gotoPage("/secure/admin/ManageConfigurationScheme!default.jspa?fieldConfigSchemeId=" + fieldConfigSchemeId + "&customFieldId=" + customFieldId);
        this.updateConfigurationSchemeContext(label, issueTypeIds, projectIds, false);
    }

    @Override
    public void editConfigurationSchemeContextByLabel(String numericCustomFieldId, String label, String newLabel, String[] issueTypeIds, String[] projectIds) {
        this.editConfigurationSchemeContextById(numericCustomFieldId, this.getSchemeIdForLabel(numericCustomFieldId, label), newLabel, issueTypeIds, projectIds);
    }

    private void updateConfigurationSchemeContext(String label, String[] issueTypeIds, String[] projectIds, boolean isAdd) {
        this.tester.setWorkingForm("jiraform");
        if (label != null) {
            this.tester.setFormElement("name", label);
        }
        if (issueTypeIds != null) {
            if (issueTypeIds.length == 0) {
                this.form.selectOption("issuetypes", "Any issue type");
            } else {
                this.form.selectOptionsByValue("issuetypes", issueTypeIds);
            }
        }
        if (projectIds != null) {
            XPathLocator locator = new XPathLocator(this.tester, "//input[@id='global_true']");
            if (locator.exists()) {
                if (projectIds.length == 0) {
                    this.tester.checkCheckbox("global", "true");
                } else {
                    this.tester.checkCheckbox("global", "false");
                }
            }
            this.form.selectOptionsByValue("projects", projectIds);
        }
        if (isAdd) {
            this.tester.submit("Add");
        } else {
            this.tester.submit("Modify");
        }
    }

    @Override
    public void removeGlobalContext(String customFieldId) {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink("config_customfield_" + customFieldId);
        XPathLocator locator = new XPathLocator(this.tester, "//a[@title = 'Delete Scheme']");
        if (locator.getNodes().length == 0) {
            throw new IllegalArgumentException("Could not find any links with the title 'Delete Scheme'.");
        }
        String deleteHref = null;
        for (Node node : locator.getNodes()) {
            XPathLocator globLoc;
            Element table = DomKit.getFirstParentByTag((Element)node, "table");
            if (table == null || (globLoc = new XPathLocator(table, ".//td[text() = 'Global (all issues)']")).getNodes().length <= 0) continue;
            deleteHref = node.getAttributes().getNamedItem("href").getNodeValue();
            break;
        }
        if (deleteHref != null) {
            this.tester.gotoPage("/secure/admin/" + deleteHref);
        }
    }

    @Override
    public void removeConfigurationSchemeContextById(String numericCustomFieldId, String fieldConfigSchemeId) {
        this.tester.gotoPage("/secure/admin/ManageConfigurationScheme!remove.jspa?customFieldId=" + numericCustomFieldId + "&fieldConfigSchemeId=" + fieldConfigSchemeId);
    }

    @Override
    public void removeConfigurationSchemeContextByLabel(String numericCustomFieldId, String fieldConfigSchemeLabel) {
        this.removeConfigurationSchemeContextById(numericCustomFieldId, this.getSchemeIdForLabel(numericCustomFieldId, fieldConfigSchemeLabel));
    }

    @Override
    public void removeCustomField(String customFieldId) {
        String deleteLink = "del_" + customFieldId;
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink(deleteLink);
        this.tester.submit("Delete");
        this.tester.assertLinkNotPresent(deleteLink);
    }

    @Override
    public void addOptions(String numericCustomFieldId, String ... options) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("addValue", option);
            this.tester.submit();
        }
    }

    @Override
    public void setDefaultValue(String numericCustomFieldId, String defValue) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.navigation.clickLinkWithExactText("Edit Default Value");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("customfield_" + numericCustomFieldId, defValue);
        this.tester.submit();
    }

    @Override
    public void removeOptions(String numericCustomFieldId, String ... options) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.clickLink("del_" + option);
            this.tester.submit("Delete");
        }
    }

    @Override
    public void disableOptions(String numericCustomFieldId, String ... options) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.clickLink("disable_" + option);
        }
    }

    @Override
    public void enableOptions(String numericCustomFieldId, String ... options) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        for (String option : options) {
            this.tester.clickLink("enable_" + option);
        }
    }

    @Override
    public void editOptionValue(String numericCustomFieldId, String option, String newValue) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLink("edit_" + option);
        this.tester.setFormElement("value", newValue);
        this.tester.submit("Update");
    }

    private String getQueryParamValueFromResponse(String paramName) {
        URL url = this.tester.getDialog().getResponse().getURL();
        return URLUtil.getQueryParamValueFromUrl(url, paramName);
    }
}

