/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.Attachments;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;

public class AttachmentsImpl
extends AbstractFuncTestUtil
implements Attachments {
    private final Navigation navigation;

    public AttachmentsImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
    }

    @Override
    public void enable() {
        this.log("Enabling attachments with default path.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "DEFAULT");
        this.tester.submit("Update");
    }

    @Override
    public void enable(String maxAttachmentSize) {
        this.log("Enabling attachments with max size of : " + maxAttachmentSize);
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "DEFAULT");
        this.tester.setFormElement("attachmentSize", maxAttachmentSize);
        this.tester.submit("Update");
    }

    @Override
    public void disable() {
        this.log("Disabling attachments.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "DISABLED");
        this.tester.checkCheckbox("thumbnailsEnabled", "false");
        this.tester.checkCheckbox("zipSupport", "false");
        this.tester.submit("Update");
    }

    @Override
    public void enableZipSupport() {
        this.log("Enabling ZIP support for downloading attachments.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("zipSupport", "true");
        this.tester.submit("Update");
    }

    @Override
    public void disableZipSupport() {
        this.log("Disabling ZIP support for downloading attachments.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("zipSupport", "false");
        this.tester.submit("Update");
    }

    @Override
    public String getCurrentAttachmentPath() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        WebTable attachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("attachmentSettings");
        if ("Attachment Path".equals(attachmentSettings.getCellAsText(2, 0).trim())) {
            String attachmentPath = attachmentSettings.getCellAsText(2, 1).trim();
            if (attachmentPath.startsWith("Default Directory [")) {
                attachmentPath = attachmentPath.substring("Default Directory [".length(), attachmentPath.length() - 1);
            }
            return attachmentPath;
        }
        throw new RuntimeException("Error occured when trying to screen-scrape the attachment path. 'Attachment Path' not found where expected in the table.");
    }
}

