/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.AdminTabs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class AdminTabsImpl
extends AbstractFuncTestUtil
implements AdminTabs {
    public AdminTabsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public String getPageHeading() {
        return new CssLocator(this.tester, "#admin-page-heading").getText();
    }

    @Override
    public List<AdminTabs.TabGroup> getCurrentTabs() {
        ArrayList<AdminTabs.TabGroup> ret = new ArrayList<AdminTabs.TabGroup>();
        CssLocator locator = new CssLocator(this.tester, "#admin-config-content .tabs-menu li.aui-tabs-group");
        if (locator.hasNodes()) {
            for (Node tabGroupNode : locator.getNodes()) {
                ArrayList<AdminTabs.Tab> tabs = new ArrayList<AdminTabs.Tab>();
                CssLocator tabLocator = new CssLocator(tabGroupNode, "ul li");
                Iterator<LocatorEntry> tabIterator = tabLocator.iterator();
                while (tabIterator.hasNext()) {
                    LocatorEntry locatorEntry = tabIterator.next();
                    String classValue = locatorEntry.getNode().getAttributes().getNamedItem("class").getNodeValue();
                    tabs.add(new AdminTabs.Tab(locatorEntry.getText(), classValue.contains("active-tab")));
                }
                ret.add(new AdminTabs.TabGroup(tabs));
            }
        }
        return ret;
    }

    @Override
    public int getNumberOfTabs() {
        List<AdminTabs.TabGroup> currentTabs = this.getCurrentTabs();
        int count = 0;
        for (AdminTabs.TabGroup currentTab : currentTabs) {
            for (AdminTabs.Tab tab : currentTab.getTabs()) {
                ++count;
            }
        }
        return count;
    }
}

