/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import java.util.List;

public interface AdminTabs {
    public String getPageHeading();

    public List<TabGroup> getCurrentTabs();

    public int getNumberOfTabs();

    public static final class Tab {
        private final String name;
        private final boolean selected;

        public Tab(String name, boolean selected) {
            this.name = name;
            this.selected = selected;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tab tab = (Tab)o;
            if (this.selected != tab.selected) {
                return false;
            }
            return this.name.equals(tab.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.selected ? 1 : 0);
            return result;
        }

        public String toString() {
            String tab = "Tab ('" + this.name + "'";
            tab = this.selected ? tab + ", selected)" : tab + ")";
            return tab;
        }
    }

    public static final class TabGroup {
        private final List<Tab> tabs;

        public TabGroup(List<Tab> tabs) {
            this.tabs = tabs;
        }

        public List<Tab> getTabs() {
            return this.tabs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TabGroup tabGroup = (TabGroup)o;
            return ((Object)this.tabs).equals(tabGroup.tabs);
        }

        public int hashCode() {
            return ((Object)this.tabs).hashCode();
        }

        public String toString() {
            return "TabGroup " + this.tabs;
        }
    }
}

