/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.cargotestrunner.SingleThreadedCargoRunner;
import com.atlassian.cargotestrunner.SingleThreadedCargoWebTest;
import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.WebTestListener;
import com.atlassian.jira.webtests.util.NativeCommands;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class TomcatShutdownListener
implements WebTestListener {
    private static final Logger log = Logger.getLogger(TomcatShutdownListener.class);
    private volatile boolean startedTest = false;

    @Override
    public void suiteStarted(WebTestDescription suiteDescription) {
    }

    @Override
    public void suiteFinished(WebTestDescription suiteDescription) {
        if (!this.startedTest) {
            log.warn((Object)"Unable to monitor Tomcat shutdown. I was not able to work out how it started.");
        }
    }

    @Override
    public void testError(WebTestDescription description, Throwable t) {
        this.fail(description, t);
    }

    @Override
    public void testFailure(WebTestDescription description, Throwable t) {
        this.fail(description, t);
    }

    @Override
    public void testFinished(WebTestDescription test) {
    }

    @Override
    public void testStarted(WebTestDescription test) {
        if (this.isTomcat(test)) {
            this.startedTest = true;
        }
    }

    private void fail(WebTestDescription testDescription, Throwable throwable) {
        if (this.isTomcat(testDescription)) {
            log.error((Object)throwable.getMessage(), throwable);
            NativeCommands.outputJavaProcesses(true);
            try {
                for (int i = 0; i < 3; ++i) {
                    NativeCommands.dumpTomcatThreads();
                    Thread.sleep(TimeUnit.SECONDS.toMillis(20L));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean isTomcat(WebTestDescription test) {
        return test instanceof SingleThreadedCargoWebTest || test instanceof SingleThreadedCargoRunner;
    }
}

