/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.JUnit3WebTestDescription;
import com.atlassian.jira.functest.framework.JUnit3WebTestListener;
import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.WebTestListener;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Preconditions;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class SuiteListenerWrapper
implements Test,
EnvironmentAware {
    private final Test delegate;
    private final WebTestDescription suiteDescription;
    private final WebTestListener listener;
    private final TestListener junit3Delegate;

    public SuiteListenerWrapper(Test delegate, WebTestListener listener) {
        this.delegate = (Test)Preconditions.checkNotNull((Object)delegate);
        this.suiteDescription = new JUnit3WebTestDescription(delegate);
        this.listener = (WebTestListener)Preconditions.checkNotNull((Object)listener);
        this.junit3Delegate = new JUnit3WebTestListener(listener);
    }

    public Test delegate() {
        return this.delegate;
    }

    public int countTestCases() {
        return this.delegate.countTestCases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        this.listener.suiteStarted(this.suiteDescription);
        try {
            testResult.addListener(this.junit3Delegate);
            this.delegate.run(testResult);
        }
        finally {
            testResult.removeListener(this.junit3Delegate);
            this.listener.suiteFinished(this.suiteDescription);
        }
    }

    @Override
    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        if (this.delegate instanceof EnvironmentAware) {
            ((EnvironmentAware)this.delegate).setEnvironmentData(environmentData);
        }
    }
}

