/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.DefaultSendBulkMail;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.AdminTabs;
import com.atlassian.jira.functest.framework.admin.AdminTabsImpl;
import com.atlassian.jira.functest.framework.admin.Attachments;
import com.atlassian.jira.functest.framework.admin.AttachmentsImpl;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.admin.CustomFieldsImpl;
import com.atlassian.jira.functest.framework.admin.CvsModules;
import com.atlassian.jira.functest.framework.admin.CvsModulesImpl;
import com.atlassian.jira.functest.framework.admin.DefaultMailServerAdministration;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemes;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemesImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurations;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationsImpl;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.admin.GeneralConfigurationImpl;
import com.atlassian.jira.functest.framework.admin.IssueLinking;
import com.atlassian.jira.functest.framework.admin.IssueLinkingImpl;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemesImpl;
import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import com.atlassian.jira.functest.framework.admin.NotificationSchemes;
import com.atlassian.jira.functest.framework.admin.NotificationSchemesImpl;
import com.atlassian.jira.functest.framework.admin.PermissionSchemes;
import com.atlassian.jira.functest.framework.admin.PermissionSchemesImpl;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.admin.ProjectImpl;
import com.atlassian.jira.functest.framework.admin.ProjectImport;
import com.atlassian.jira.functest.framework.admin.ProjectImportImpl;
import com.atlassian.jira.functest.framework.admin.Resolutions;
import com.atlassian.jira.functest.framework.admin.ResolutionsImpl;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.functest.framework.admin.RolesImpl;
import com.atlassian.jira.functest.framework.admin.SendBulkMail;
import com.atlassian.jira.functest.framework.admin.Subtasks;
import com.atlassian.jira.functest.framework.admin.SubtasksImpl;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.admin.TimeTrackingImpl;
import com.atlassian.jira.functest.framework.admin.UsersAndGroups;
import com.atlassian.jira.functest.framework.admin.UsersAndGroupsImpl;
import com.atlassian.jira.functest.framework.admin.ViewFieldScreens;
import com.atlassian.jira.functest.framework.admin.ViewFieldScreensImpl;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.admin.ViewWorkflowsImpl;
import com.atlassian.jira.functest.framework.admin.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.WorkflowSchemesImpl;
import com.atlassian.jira.functest.framework.admin.plugins.Plugins;
import com.atlassian.jira.functest.framework.admin.plugins.PluginsImpl;
import com.atlassian.jira.functest.framework.admin.user.shared.DefaultSharedDashboardsAdministration;
import com.atlassian.jira.functest.framework.admin.user.shared.DefaultSharedFiltersAdministration;
import com.atlassian.jira.functest.framework.admin.user.shared.SharedDashboardsAdministration;
import com.atlassian.jira.functest.framework.admin.user.shared.SharedFiltersAdministration;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.dump.FuncTestTimer;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.functest.framework.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Preconditions;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class AdministrationImpl
extends AbstractFuncTestUtil
implements Administration,
FuncTestLogger {
    private static final String IMPORT_DIR = "import";
    private static final String PAGE_TRACKBACKS = "/secure/admin/jira/TrackbackAdmin!default.jspa";
    private static final Pattern PATTERN_BUILD_NUMBER = Pattern.compile("#(\\d+)");
    private final XmlBackupCopier xmlBackupCopier;
    private final Navigation navigation;
    private AsynchronousTasks asynchronousTasks;
    private final TextAssertions text;
    private final GeneralConfiguration generalConfiguration;
    private final Project project;
    private final UsersAndGroups usersAndGroups;
    private final Roles roles;
    private final CustomFields customFields;
    private final PermissionSchemes permissionSchemes;
    private final IssueSecuritySchemes issueSecuritySchemes;
    private final FieldConfigurations fieldConfigurations;
    private final FieldConfigurationSchemes fieldConfigurationSchemes;
    private final ResolutionsImpl resolutions;
    private final ViewServices viewServices;
    private final CvsModules cvsModules;
    private final ProjectImport projectImport;
    private final Attachments attachments;
    private final Plugins plugins;
    private final ViewFieldScreensImpl viewFieldScreens;
    private final ViewWorkflows workflows;
    private final WorkflowSchemes workflowSchemes;
    private final MailServerAdministration mailServerAdministration;
    private final SharedFiltersAdministration sharedFiltersAdministration;
    private final SharedDashboardsAdministration sharedDashboardsAdministration;
    private final NotificationSchemes notificationSchemes;
    private final SendBulkMail sendBulkMail;
    private final AdminTabs adminTabs;
    private static Set<String> copiedFiles = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<String> JIRA_HOME_DIR = new ThreadLocal();

    public AdministrationImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Assertions assertions) {
        super(tester, environmentData, 2);
        this.xmlBackupCopier = new XmlBackupCopier(environmentData.getBaseUrl());
        this.navigation = navigation;
        this.asynchronousTasks = new AsynchronousTasks(tester, environmentData, this.childLogIndentLevel());
        this.text = assertions.getTextAssertions();
        this.generalConfiguration = new GeneralConfigurationImpl(tester, environmentData);
        this.project = new ProjectImpl(tester, environmentData, navigation, assertions, this.asynchronousTasks);
        this.usersAndGroups = new UsersAndGroupsImpl(tester, navigation, assertions.getTextAssertions(), this.locators);
        this.roles = new RolesImpl(tester, environmentData, 3);
        this.customFields = new CustomFieldsImpl(tester, environmentData, navigation, this.getFuncTestHelperFactory().getForm());
        this.permissionSchemes = new PermissionSchemesImpl(tester, environmentData);
        this.issueSecuritySchemes = new IssueSecuritySchemesImpl(tester, environmentData);
        this.fieldConfigurations = new FieldConfigurationsImpl(tester, environmentData);
        this.fieldConfigurationSchemes = new FieldConfigurationSchemesImpl(tester, environmentData);
        this.resolutions = new ResolutionsImpl(tester, environmentData);
        this.viewServices = new ViewServices(tester, navigation);
        this.cvsModules = new CvsModulesImpl(tester, environmentData, navigation, assertions);
        this.projectImport = new ProjectImportImpl(tester, environmentData, navigation, this);
        this.attachments = new AttachmentsImpl(tester, environmentData, navigation);
        this.viewFieldScreens = new ViewFieldScreensImpl(tester, environmentData, navigation);
        this.workflows = new ViewWorkflowsImpl(tester, environmentData, this.childLogIndentLevel(), navigation);
        this.workflowSchemes = new WorkflowSchemesImpl(tester, environmentData, this.childLogIndentLevel());
        this.plugins = new PluginsImpl(tester, environmentData, this.logIndentLevel, navigation, this, this.locators);
        this.mailServerAdministration = new DefaultMailServerAdministration(tester, navigation, this.locators);
        this.sharedFiltersAdministration = new DefaultSharedFiltersAdministration(tester, navigation, this.locators);
        this.sharedDashboardsAdministration = new DefaultSharedDashboardsAdministration(tester, navigation, this.locators);
        this.sendBulkMail = new DefaultSendBulkMail(navigation);
        this.notificationSchemes = new NotificationSchemesImpl(tester, environmentData, this.childLogIndentLevel());
        this.adminTabs = new AdminTabsImpl(tester, environmentData);
    }

    @Override
    public void reIndex() {
        this.tester.gotoPage("secure/admin/jira/IndexAdmin.jspa");
        this.tester.submit("Re-Index");
        this.waitForIndexCompletion(1000L, 100);
    }

    @Override
    public void setProfiling(boolean on) {
    }

    @Override
    public void restoreBlankInstance() {
        this.restoreData("blankprojects.xml");
    }

    @Override
    public void restoreNotSetupInstance() {
        File file = new File(this.environmentData.getXMLDataLocation(), "TestEmpty.xml");
        this.copyFileToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("filename", file.getName());
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        this.waitForRestore();
        this.tester.assertTextPresent("JIRA Setup");
    }

    private void copyFileToJiraImportDirectory(File file) {
        String filename = file.getName();
        if (!copiedFiles.contains(filename)) {
            File jiraImportDirectory = new File(this.getJiraHomeDirectory(), IMPORT_DIR);
            try {
                FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
                copiedFiles.add(filename);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
            }
        }
    }

    @Override
    public File replaceTokensInFile(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = IOUtils.toString((Reader)new FileReader(resource));
        xml = this.replaceTokens(xml, replacements);
        File newData = File.createTempFile(originalXmlFileName, ".xml");
        FileWriter of = new FileWriter(newData);
        of.write(xml);
        of.close();
        return newData;
    }

    @Override
    public void restoreDataWithReplacedTokens(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        this.restoreDataWithReplacedTokens(originalXmlFileName, replacements, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreDataWithReplacedTokens(String originalXmlFileName, Map<String, String> replacements, boolean useDefaultPaths) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = IOUtils.toString((Reader)new FileReader(resource));
        xml = this.replaceTokens(xml, replacements);
        File newData = null;
        try {
            newData = this.replaceTokensInFile(originalXmlFileName, replacements);
            this.restoreData(newData.getParent(), newData.getName(), useDefaultPaths);
        }
        finally {
            if (newData.exists()) assert (newData.delete());
        }
    }

    @Override
    public void restoreData(String fileName) {
        this.restoreData(fileName, false);
    }

    @Override
    public void restoreData(String fileName, boolean useDefaultPaths) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, useDefaultPaths);
    }

    @Override
    public void restoreDataAndLogin(String fileName, String username) {
        this.restoreDataAndLogin(fileName, username, false);
    }

    @Override
    public void restoreDataAndLogin(String fileName, String username, boolean useDefaultPaths) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, true, username, username, useDefaultPaths);
    }

    @Override
    public void restoreDataSlowOldWayAndLogin(String fileName, String username) {
        this.restoreDataSlowOldWayAndLogin(fileName, username, false);
    }

    @Override
    public void restoreDataSlowOldWayAndLogin(String fileName, String username, boolean useDefaultPath) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, false, "admin", "admin", useDefaultPath);
    }

    @Override
    public void restoreDataSlowOldWay(String fileName) {
        this.restoreDataSlowOldWay(fileName, false);
    }

    @Override
    public void restoreDataSlowOldWay(String fileName, boolean useDefaultPaths) {
        this.restoreDataSlowOldWay(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, useDefaultPaths);
    }

    @Override
    public void restoreDataWithPluginsReload(String fileName) {
        this.restoreDataWithPluginsReload(fileName, false);
    }

    @Override
    public void restoreDataWithPluginsReload(String fileName, boolean useDefaultPaths) {
        this.restoreDataSlowOldWay(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, useDefaultPaths);
    }

    public void restoreData(String path, String fileName) {
        this.restoreData(path, fileName, false);
    }

    public void restoreData(String path, String fileName, boolean useDefaultPath) {
        this.restoreData(path, fileName, true, "admin", "admin", useDefaultPath);
    }

    @Override
    public void restoreDataSlowOldWay(String path, String fileName) {
        this.restoreDataSlowOldWay(path, fileName, false);
    }

    @Override
    public void restoreDataSlowOldWay(String path, String fileName, boolean useDefaultPath) {
        this.restoreData(path, fileName, false, "admin", "admin", useDefaultPath);
    }

    private void restoreData(String path, String fileName, boolean clearCache, String username, String password, boolean useDefaultPaths) {
        this.restoreData(path, fileName, clearCache, username, password, useDefaultPaths, LicenseKeys.V2_COMMERCIAL.getLicenseString());
    }

    @Override
    public void restoreDataWithLicense(String fileName, String licenseKey, boolean useDefaultPaths) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, true, "admin", "admin", useDefaultPaths, licenseKey);
    }

    @Override
    public void restoreDataWithLicense(String fileName, String licenseKey) {
        this.restoreDataWithLicense(fileName, licenseKey, false);
    }

    private void restoreData(String path, String fileName, boolean clearCache, String username, String password, boolean useDefaultPaths, String licenseString) {
        this.navigation.gotoAdminSection("system_info");
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String sourcePath = path + FS + fileName;
        String jiraImportDir = this.getJiraHomeDirectory() + FS + IMPORT_DIR + FS + new File(fileName).getName();
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupTo(sourcePath, jiraImportDir);
        this.log("Restoring data '" + jiraImportDir + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", fileName);
        this.tester.setFormElement("license", licenseString);
        if (useDefaultPaths) {
            this.reflectivelySetDefaultPaths(this.tester.getDialog().getForm());
        }
        if (clearCache) {
            this.tester.checkCheckbox("quickImport", "true");
        }
        this.tester.submit();
        this.waitForRestore();
        if (!this.isRestoreSuccessful()) {
            this.assertCauseOfError("The xml data you are trying to import seems to be from a newer version of JIRA. This will not work.", jiraImportDir);
            this.assertCauseOfError("You must enter the location of an XML file.", jiraImportDir);
            this.assertCauseOfError("Could not find file at this location.", jiraImportDir);
            this.assertCauseOfError("Invalid license key specified.", jiraImportDir);
            this.assertCauseOfError("The current license is too old to install this version of JIRA", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Standard.", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Professional.", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Enterprise.", jiraImportDir);
            this.assertCauseOfError("You must specify an index for the restore process.", jiraImportDir);
            this.assertCauseOfError("Error parsing export file. Your export file is invalid.", jiraImportDir);
            this.assertCauseOfError("specified in the backup file is not valid", jiraImportDir);
            throw new AssertionError((Object)("Failed to restore JIRA data from [" + jiraImportDir + "]. See logs for details."));
        }
        this.navigation.disableWebSudo();
        this.navigation.login(username, password);
        long howLong = timer.end();
        this.log("Restored '" + fileName + "' in " + howLong + "ms");
        if (!baseUrlReplaced) {
            this.generalConfiguration.setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        }
        this.tester.beginAt("/");
    }

    @Override
    public void restoreI18nData(String fileName) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String filePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + fileName;
        File file = new File(filePath);
        this.copyFileToJiraImportDirectory(file);
        this.log("Restoring data '" + filePath + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        this.waitForRestore();
        if (!this.isRestoreSuccessful()) {
            Assert.fail((String)"Your project failed to import successfully. See logs for details");
        }
        long howLong = timer.end();
        this.navigation.disableWebSudo();
        this.navigation.login("admin", "admin");
        this.log("Restored '" + fileName + "' in " + howLong + "ms");
    }

    private void reflectivelySetDefaultPaths(WebForm jiraForm) {
        Class<WebForm> webFormClass = WebForm.class;
        Class<WebRequestSource> webRequestSourceClass = WebRequestSource.class;
        this.reflectivlySetField(jiraForm, webFormClass, "_formParameters", null);
        this.reflectivlySetField(jiraForm, webFormClass, "_presetParameters", null);
        String postUrl = (String)this.reflectivelyGetField(jiraForm, webRequestSourceClass, "_destination");
        this.reflectivlySetField(jiraForm, webRequestSourceClass, "_destination", postUrl + "?useDefaultPaths=true");
        Class[] paramType = new Class[]{String.class, String.class};
        Object[] params = new String[]{"useDefaultPaths", "true"};
        this.reflectivelyInvoke(jiraForm, webFormClass, "addPresetParameter", paramType, params);
        this.tester.setFormElement("useDefaultPaths", "true");
    }

    private void reflectivelyInvoke(Object self, Class<?> clazz, String methodName, Class[] paramType, Object[] params) {
        Preconditions.checkNotNull((Object)self, (String)"cannot invoke %s on null object", (Object[])new Object[]{methodName});
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            method.invoke(self, params);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Error getting method '%s(%s)' for %s : possibly a library update has changed this method", methodName, Arrays.toString(paramType), clazz.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Error invoking method '%s(%s)' for %s : exception raised during method invocation : %s", e.getCause().getMessage(), methodName, Arrays.toString(paramType), clazz.getName()), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error invoking method '%s(%s)' for %s : possibly a security manager has prevented access to this method", methodName, Arrays.toString(paramType), clazz.getName()), e);
        }
        finally {
            if (method != null) {
                method.setAccessible(false);
            }
        }
    }

    private void reflectivlySetField(Object self, Class<?> clazz, String fieldName, Object fieldValue) {
        Preconditions.checkNotNull((Object)self, (String)"cannot set field %s to %s on null object", (Object[])new Object[]{fieldName, fieldValue});
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(self, fieldValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error setting field '%s' to '%s' for %s : possibly a security manager has prevented access to this field", fieldName, fieldValue, clazz.getName()), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Error setting field '%s' to '%s' for %s : possibly a library update has changed this field", fieldName, fieldValue, clazz.getName()), e);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    private Object reflectivelyGetField(Object self, Class<?> clazz, String fieldName) {
        Preconditions.checkNotNull((Object)self, (String)"cannot get field %s on null object", (Object[])new Object[]{fieldName});
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object object = field.get(self);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error getting field '%s' for %s : possibly a security manager has prevented access to this field", fieldName, clazz.getName()), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Error getting field '%s' for %s : possibly a library update has changed this field", fieldName, clazz.getName()), e);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public File exportDataToFile(String fileName) {
        String text;
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Export");
        String realFileName = FilenameUtils.getName((String)fileName);
        this.log("Backing up data to '" + realFileName + "'");
        this.tester.gotoPage("secure/admin/XmlBackup!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", realFileName);
        this.tester.submit();
        if (new IdLocator(this.tester, "replace_submit").exists()) {
            this.tester.setWorkingForm("jiraform");
            this.tester.submit();
        }
        if ((text = StringUtils.stripToNull((String)new IdLocator(this.tester, "backup-file").getText())) == null) {
            Assert.fail((String)"The restore did not redirect to the result page.");
        }
        timer.end();
        File file = new File(text);
        Assert.assertTrue((String)("Backup returned '" + text + "' which is not an absolute file."), (boolean)file.isAbsolute());
        return file;
    }

    @Override
    public String getCurrentAttachmentPath() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        WebTable attachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("table-AttachmentSettings");
        if ("Attachment Path".equals(attachmentSettings.getCellAsText(1, 0).trim())) {
            String attachmentPath = attachmentSettings.getCellAsText(1, 1).trim();
            if (attachmentPath.startsWith("Default Directory [")) {
                attachmentPath = attachmentPath.substring("Default Directory [".length(), attachmentPath.length() - 1);
            }
            return attachmentPath;
        }
        throw new RuntimeException("Error occured when trying to screen-scrape the attachment path. 'Attachment Path' not found where expected in the table.");
    }

    @Override
    public void activateSubTasks() {
        this.log("activating sub tasks");
        this.tester.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        if (this.tester.getDialog().isLinkPresentWithText("Enable")) {
            this.tester.clickLinkWithText("Enable");
        } else {
            this.log("Subtasks already enabled");
        }
    }

    @Override
    public void addSubTaskType(String name) {
        this.activateSubTasks();
        this.tester.setFormElement("name", name);
        this.tester.submit("Add");
    }

    @Override
    public void enableTrackBacks() {
        this.tester.gotoPage(PAGE_TRACKBACKS);
        this.tester.checkCheckbox("acceptPings", "true");
        this.tester.checkCheckbox("sendPings", "allIssues");
        this.tester.submit("Update");
    }

    @Override
    public GeneralConfiguration generalConfiguration() {
        return this.generalConfiguration;
    }

    @Override
    public CvsModules cvsModules() {
        return this.cvsModules;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public UsersAndGroups usersAndGroups() {
        return this.usersAndGroups;
    }

    @Override
    public Roles roles() {
        return this.roles;
    }

    @Override
    public CustomFields customFields() {
        return this.customFields;
    }

    @Override
    public PermissionSchemes permissionSchemes() {
        return this.permissionSchemes;
    }

    @Override
    public IssueSecuritySchemes issueSecuritySchemes() {
        return this.issueSecuritySchemes;
    }

    @Override
    public FieldConfigurations fieldConfigurations() {
        return this.fieldConfigurations;
    }

    @Override
    public FieldConfigurationSchemes fieldConfigurationSchemes() {
        return this.fieldConfigurationSchemes;
    }

    @Override
    public ProjectImport projectImport() {
        return this.projectImport;
    }

    @Override
    public Plugins plugins() {
        return this.plugins;
    }

    @Override
    public void removeGlobalPermission(int permission, String group) {
        String deleteLink = "del_" + permission + "_" + group;
        this.navigation.gotoAdminSection("global_permissions");
        if (this.tester.getDialog().isLinkPresent(deleteLink)) {
            this.tester.clickLink(deleteLink);
            this.tester.submit("Delete");
        }
    }

    @Override
    public void addGlobalPermission(int permission, String group) {
        HtmlPage page = new HtmlPage(this.tester);
        String addUrl = page.addXsrfToken("secure/admin/jira/GlobalPermissions.jspa?groupName=" + group + "&permType=" + permission + "&action=add");
        this.tester.gotoPage(addUrl);
    }

    @Override
    public void switchToLicense(LicenseKeys.License license) {
        this.switchToLicense(license.getLicenseString(), license.getDescription());
    }

    @Override
    public void switchToLicense(String license, String description) {
        this.navigation.gotoAdminSection("license_details");
        this.tester.setFormElement("license", license);
        this.tester.submit("Add");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='license_table']"), description);
    }

    @Override
    public void switchToPersonalLicense() {
        this.switchToLicense(LicenseKeys.V2_PERSONAL.getLicenseString(), "JIRA " + this.getEdition() + ": Personal");
    }

    @Override
    public void switchToStarterLicense() {
        this.switchToLicense(LicenseKeys.V2_STARTER.getLicenseString(), "JIRA " + this.getEdition() + ": Starter");
    }

    @Override
    public String getJiraHomeDirectory() {
        String jiraHome = JIRA_HOME_DIR.get();
        if (jiraHome == null) {
            try {
                this.navigation.gotoAdminSection("system_info");
                WebTable filePathTable = this.tester.getDialog().getResponse().getTableWithID("file_paths");
                if (filePathTable != null && filePathTable.getTableCellWithID("file_paths_jirahome") != null) {
                    String jiraHomePath = filePathTable.getTableCellWithID("file_paths_jirahome").asText().trim();
                    jiraHome = new File(jiraHomePath).getCanonicalPath();
                    JIRA_HOME_DIR.set(jiraHome);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return jiraHome;
    }

    @Override
    public String getSystemTenantHomeDirectory() {
        WebTable filePathTable;
        this.navigation.gotoAdminSection("system_info");
        try {
            filePathTable = this.tester.getDialog().getResponse().getTableWithID("file_paths");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (filePathTable != null && filePathTable.getTableCellWithID("file_paths_jirahome") != null) {
            return filePathTable.getTableCellWithID("file_paths_jirahome").asText().trim();
        }
        return null;
    }

    @Override
    public MailServerAdministration mailServers() {
        return this.mailServerAdministration;
    }

    @Override
    public SharedFiltersAdministration sharedFilters() {
        return this.sharedFiltersAdministration;
    }

    @Override
    public SharedDashboardsAdministration sharedDashboards() {
        return this.sharedDashboardsAdministration;
    }

    @Override
    public SendBulkMail sendBulkMail() {
        return this.sendBulkMail;
    }

    @Override
    public AdminTabs tabs() {
        return this.adminTabs;
    }

    private void assertCauseOfError(String errorMessage, String filePath) {
        if (this.tester.getDialog().isTextInResponse(errorMessage)) {
            throw new AssertionError((Object)("Failed to restore JIRA data. Cause: " + errorMessage + " File path: [" + filePath + "]"));
        }
    }

    @Override
    public Subtasks subtasks() {
        return new SubtasksImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public IssueLinking issueLinking() {
        return new IssueLinkingImpl(this.tester, this.navigation, this.logger);
    }

    @Override
    public TimeTracking timeTracking() {
        return new TimeTrackingImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public Resolutions resolutions() {
        return this.resolutions;
    }

    @Override
    public ViewServices services() {
        return this.viewServices;
    }

    @Override
    public String getEdition() {
        return "Enterprise";
    }

    @Override
    public long getBuildNumber() {
        IdLocator idLocator = new IdLocator(this.tester, "footer-build-information");
        String buildInfo = idLocator.getText();
        if (StringUtils.isBlank((String)buildInfo)) {
            throw new RuntimeException("Unable to find build information in the footer.");
        }
        Matcher matcher = PATTERN_BUILD_NUMBER.matcher(buildInfo);
        if (!matcher.find()) {
            throw new RuntimeException("Unable to find build number from the footer.");
        }
        try {
            return Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to find builder number from the footer.", e);
        }
    }

    private String replaceTokens(String source, Map<String, String> replacements) {
        for (String token : replacements.keySet()) {
            int index = source.indexOf(token);
            if (index < 0) {
                Assert.fail((String)("Replacement token '" + token + "' not found"));
            }
            source = source.replaceAll(token, Matcher.quoteReplacement(replacements.get(token)));
        }
        return source;
    }

    @Override
    public void runJellyScript(String script) {
        this.log("Running jelly script '" + script + "'.");
        this.navigation.gotoAdminSection("jelly_runner");
        this.tester.setFormElement("script", script);
        this.tester.submit("Run now");
    }

    @Override
    public void enableAccessLogging() {
        this.log("enabling access logging");
        this.navigation.gotoAdminSection("logging_profiling");
        this.tester.clickLink("enable_http_access");
    }

    @Override
    public Attachments attachments() {
        return this.attachments;
    }

    @Override
    public ViewFieldScreens viewFieldScreens() {
        return this.viewFieldScreens;
    }

    @Override
    public Administration.Utilities utilities() {
        return new Util();
    }

    @Override
    public ViewWorkflows workflows() {
        return this.workflows;
    }

    @Override
    public WorkflowSchemes workflowSchemes() {
        return this.workflowSchemes;
    }

    @Override
    public NotificationSchemes notificationSchemes() {
        return this.notificationSchemes;
    }

    private void waitForIndexCompletion(long sleepTime, int retryCount) {
        this.asynchronousTasks.waitForSuccessfulCompletion(sleepTime, retryCount, "Indexing");
    }

    private boolean isRestoreSuccessful() {
        return this.isOnRestore() && new XPathLocator(this.tester, "//a[@id=\"login\"]").exists();
    }

    private boolean isOnRestore() {
        return this.tester.getDialog().getResponse().getURL().toExternalForm().contains("ImportResult.jspa");
    }

    @Override
    public void waitForRestore() {
        String url = this.tester.getDialog().getResponse().getURL().toExternalForm();
        while (url.contains("importprogress")) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String subUrl = url.substring(this.getEnvironmentData().getBaseUrl().toString().length());
            this.tester.gotoPage(subUrl);
            url = this.tester.getDialog().getResponse().getURL().toExternalForm();
        }
    }

    private class Util
    implements Administration.Utilities {
        private Util() {
        }

        @Override
        public void runServiceNow(long serviceId) {
            AdministrationImpl.this.navigation.gotoPage("ServiceExecutor.jspa");
            AdministrationImpl.this.tester.setFormElement("serviceId", String.valueOf(serviceId));
            AdministrationImpl.this.tester.submit();
            AdministrationImpl.this.tester.assertTextNotPresent("No service with this id exists");
        }
    }
}

