/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class AbstractFuncTestUtil
implements FuncTestLogger {
    protected static final String FS = System.getProperty("file.separator");
    protected JIRAEnvironmentData environmentData;
    protected final WebTester tester;
    protected final FuncTestLogger logger;
    protected final LocatorFactory locators;
    protected final int logIndentLevel;
    private final FuncTestHelperFactory funcTestHelperFactory;

    public AbstractFuncTestUtil(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        this.environmentData = environmentData;
        this.tester = tester;
        this.logger = new FuncTestLoggerImpl(logIndentLevel);
        this.logIndentLevel = logIndentLevel;
        this.funcTestHelperFactory = new FuncTestHelperFactory(tester, environmentData);
        this.locators = this.funcTestHelperFactory.getLocator();
    }

    protected final int childLogIndentLevel() {
        return this.logIndentLevel + 1;
    }

    protected final Navigation navigation() {
        return this.funcTestHelperFactory.getNavigation();
    }

    protected final Assertions getAssertions() {
        return this.funcTestHelperFactory.getAssertions();
    }

    public JIRAEnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    public FuncTestHelperFactory getFuncTestHelperFactory() {
        return this.funcTestHelperFactory;
    }

    public FuncTestLogger getLogger() {
        return this.logger;
    }

    @Override
    public void log(Object logData) {
        this.logger.log(logData);
    }

    @Override
    public void log(Throwable t) {
        this.logger.log(t);
    }

    protected void submitAtPage(String url, String button, String logOnFail) {
        this.tester.gotoPage(url);
        if (this.tester.getDialog().hasSubmitButton(button)) {
            this.tester.submit(button);
        } else if (logOnFail != null) {
            this.log(logOnFail);
        }
    }
}

