/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.mail;

import com.atlassian.jira.functest.config.ConfigObjectWithId;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ConfigMailServer
implements ConfigObjectWithId {
    private Long id;
    private String name;
    private String description;
    private String from;
    private String port;
    private Type type;
    private String serverName;
    private String jndiLocation;
    private String userName;
    private String password;
    private String prefix;

    @Override
    public Long getId() {
        return this.id;
    }

    public ConfigMailServer setId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ConfigMailServer setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigMailServer setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public ConfigMailServer setFrom(String from) {
        this.from = from;
        return this;
    }

    public String getPort() {
        return this.port;
    }

    public Integer getPortNumber() {
        if (this.port != null) {
            try {
                return Integer.parseInt(this.port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public ConfigMailServer setPort(String port) {
        this.port = port;
        return this;
    }

    public ConfigMailServer setPort(Integer port) {
        return this.setPort(port == null ? null : port.toString());
    }

    public Type getType() {
        return this.type;
    }

    public ConfigMailServer setType(Type type) {
        this.type = type;
        return this;
    }

    public ConfigMailServer setType(String type) {
        return this.setType(Type.parseString(type));
    }

    public String getServerName() {
        return this.serverName;
    }

    public ConfigMailServer setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public ConfigMailServer setJndiLocation(String jndiLocation) {
        this.jndiLocation = jndiLocation;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public ConfigMailServer setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ConfigMailServer setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ConfigMailServer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigMailServer that = (ConfigMailServer)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.jndiLocation != null ? !this.jndiLocation.equals(that.jndiLocation) : that.jndiLocation != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
        result = 31 * result + (this.jndiLocation != null ? this.jndiLocation.hashCode() : 0);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum Type {
        SMTP,
        POP;


        public static Type parseString(String str) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(str)) continue;
                return type;
            }
            return null;
        }
    }
}

