/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.dashboard;

import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.dashboard.ConfigExternalGadget;
import com.atlassian.jira.functest.config.dashboard.ConfigGadget;
import com.atlassian.jira.functest.config.dashboard.ConfigGadgetManager;
import com.atlassian.jira.functest.config.dashboard.ConfigGadgetSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigGadgetManager
implements ConfigGadgetManager {
    private final ConfigGadgetSupport<ConfigGadget> gadgetSupport;
    private final ConfigGadgetSupport<ConfigExternalGadget> externalSupport;

    public DefaultConfigGadgetManager(Document document) {
        this(new GadgetHelper(document), new ExternalHelper(document));
    }

    public DefaultConfigGadgetManager(ConfigGadgetSupport<ConfigGadget> gadgetSupport, ConfigGadgetSupport<ConfigExternalGadget> externalSupport) {
        this.gadgetSupport = gadgetSupport;
        this.externalSupport = externalSupport;
    }

    @Override
    public List<ConfigGadget> loadGadgets() {
        return this.gadgetSupport.loadAll();
    }

    @Override
    public boolean saveGadgets(Collection<? extends ConfigGadget> gadgets) {
        return this.gadgetSupport.sync(gadgets);
    }

    @Override
    public List<ConfigExternalGadget> loadExternalGadgets() {
        return this.externalSupport.loadAll();
    }

    @Override
    public boolean saveExternalGadgets(Collection<? extends ConfigExternalGadget> gadgets) {
        return this.externalSupport.sync(gadgets);
    }

    public static class ExternalHelper
    extends ConfigGadgetSupport<ConfigExternalGadget> {
        private static final String ELEMENT_EXTERNAL_GADGET = "ExternalGadget";

        public ExternalHelper(Document document) {
            super(document);
        }

        @Override
        public List<ConfigExternalGadget> loadAll() {
            List<Element> elements = this.getElements();
            ArrayList<ConfigExternalGadget> gadgets = new ArrayList<ConfigExternalGadget>(elements.size());
            for (Element element : elements) {
                ConfigExternalGadget gadget = new ConfigExternalGadget(element);
                if (gadget.getId() == null) {
                    throw new ConfigException("Trying to load a external gadget without any ID.");
                }
                gadgets.add(gadget);
            }
            return gadgets;
        }

        @Override
        public boolean create(ConfigExternalGadget object) {
            throw new ConfigException("Trying create a new external gadget. I was too lazy to implement this.");
        }

        @Override
        public boolean update(ConfigExternalGadget oldObj, ConfigExternalGadget newObj) {
            if (!oldObj.equals(newObj)) {
                newObj.save(this.findElementForGadget(oldObj));
                return true;
            }
            return false;
        }

        @Override
        public boolean delete(ConfigExternalGadget obj) {
            ConfigXmlUtils.removeElement(this.findElementForGadget(obj));
            return true;
        }

        @Override
        public Long getId(ConfigExternalGadget obj) {
            return obj.getId();
        }

        private List<Element> getElements() {
            return ConfigXmlUtils.getTopElementsByName(this.getDocument(), ELEMENT_EXTERNAL_GADGET);
        }

        private Element findElementForGadget(ConfigExternalGadget gadget) {
            Element element = ConfigXmlUtils.getElementByXpath(this.getDocument(), String.format("/entity-engine-xml/ExternalGadget[@id='%d']", gadget.getId()));
            if (element == null) {
                throw new ConfigException("Could not find external gadget with id '" + gadget.getId() + "'.");
            }
            return element;
        }
    }

    public static class GadgetHelper
    extends ConfigGadgetSupport<ConfigGadget> {
        private static final String ELEMENT_GADGETS = "PortletConfiguration";

        public GadgetHelper(Document document) {
            super(document);
        }

        @Override
        public List<ConfigGadget> loadAll() {
            List<Element> configNodes = this.getGadetElements();
            ArrayList<ConfigGadget> returnList = new ArrayList<ConfigGadget>(configNodes.size());
            for (Element configNode : configNodes) {
                ConfigGadget configGadget = new ConfigGadget(configNode);
                if (configGadget.getId() == null) {
                    throw new ConfigException("Trying to load a gadget without any ID.");
                }
                returnList.add(configGadget);
            }
            return returnList;
        }

        @Override
        public boolean create(ConfigGadget object) {
            throw new ConfigException("Trying create a new gadget. I was too lazy to implement this.");
        }

        @Override
        public boolean update(ConfigGadget oldGadget, ConfigGadget newGadget) {
            if (!oldGadget.equals(newGadget)) {
                newGadget.save(this.findElementForGadget(oldGadget));
                return true;
            }
            return false;
        }

        @Override
        public boolean delete(ConfigGadget obj) {
            ConfigXmlUtils.removeElement(this.findElementForGadget(obj));
            for (Element configElement : this.getConfigElements(obj)) {
                ConfigXmlUtils.removeElement(configElement);
            }
            return true;
        }

        @Override
        public Long getId(ConfigGadget obj) {
            return obj.getId();
        }

        private List<Element> getGadetElements() {
            return ConfigXmlUtils.getTopElementsByName(this.getDocument(), ELEMENT_GADGETS);
        }

        private Element findElementForGadget(ConfigGadget gadget) {
            Element element = ConfigXmlUtils.getElementByXpath(this.getDocument(), String.format("/entity-engine-xml/PortletConfiguration[@id='%d']", gadget.getId()));
            if (element == null) {
                throw new ConfigException("Could not find gadget with id '" + gadget.getId() + "'.");
            }
            return element;
        }

        private List<Element> getConfigElements(ConfigGadget gadget) {
            return ConfigXmlUtils.getElementsByXpath(this.getDocument(), String.format("/entity-engine-xml/GadgetUserPreference[@portletconfiguration='%d']", gadget.getId()));
        }
    }
}

