/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.dashboard;

import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.dashboard.ConfigDashboard;
import com.atlassian.jira.functest.config.dashboard.ConfigDashboardManager;
import com.atlassian.jira.functest.config.dashboard.ConfigGadget;
import com.atlassian.jira.functest.config.dashboard.ConfigGadgetManager;
import com.atlassian.jira.functest.config.sharing.ConfigSharedEntityCleaner;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigDashboardManager
implements ConfigDashboardManager {
    private static final String ELEMENT_DASHBOARD = "PortalPage";
    private final ConfigSharedEntityCleaner cleaner;
    private final ConfigGadgetManager gadgetManager;
    private final Document document;

    public DefaultConfigDashboardManager(Document document, ConfigGadgetManager gadgetManager, ConfigSharedEntityCleaner cleaner) {
        this.document = document;
        this.gadgetManager = gadgetManager;
        this.cleaner = cleaner;
    }

    @Override
    public List<ConfigDashboard> loadDashboards() {
        List<Element> elements = this.getDashboardElements();
        ArrayList<ConfigDashboard> dashboards = new ArrayList<ConfigDashboard>(elements.size());
        for (Element element : elements) {
            ConfigDashboard dashboard = new ConfigDashboard(element);
            if (dashboard.getId() == null) {
                throw new ConfigException("Trying to read in dashboard with no ID.");
            }
            dashboards.add(dashboard);
        }
        List<ConfigGadget> configGadgetList = this.gadgetManager.loadGadgets();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (ConfigGadget configGadget : configGadgetList) {
            map.put((Object)configGadget.getDashboardId(), (Object)configGadget);
        }
        for (ConfigDashboard dashboard : dashboards) {
            dashboard.setGadgets(map.get((Object)dashboard.getId()));
        }
        return dashboards;
    }

    @Override
    public boolean saveDashboards(Collection<? extends ConfigDashboard> dashboards) {
        List<Element> oldDashboards = this.getDashboardElements();
        HashMap<Long, Element> dashboardMap = new HashMap<Long, Element>();
        for (Element oldDashboard : oldDashboards) {
            Long id = ConfigDashboard.parseId(oldDashboard);
            if (id == null) {
                throw new ConfigException("Trying to read in dashboard with no ID.");
            }
            dashboardMap.put(id, oldDashboard);
        }
        ArrayList<ConfigGadget> gadgets = new ArrayList<ConfigGadget>();
        boolean returnValue = false;
        for (ConfigDashboard configDashboard : dashboards) {
            Element oldDashboard = (Element)dashboardMap.get(configDashboard.getId());
            if (oldDashboard == null) {
                throw new ConfigException("Trying to add new dashboard. I was too lazy to implement this.");
            }
            returnValue = configDashboard.save(oldDashboard) | returnValue;
            dashboardMap.remove(configDashboard.getId());
            for (ConfigGadget gadget : configDashboard.getGadgets()) {
                gadget.setDashboard(configDashboard.getId());
                gadgets.add(gadget);
            }
        }
        returnValue = this.gadgetManager.saveGadgets(gadgets) | returnValue;
        for (Element element : dashboardMap.values()) {
            this.deleteDashboard(new ConfigDashboard(element));
            returnValue = true;
        }
        return returnValue;
    }

    private List<Element> getDashboardElements() {
        return ConfigXmlUtils.getTopElementsByName(this.document, ELEMENT_DASHBOARD);
    }

    private void deleteDashboard(ConfigDashboard dashboard) {
        this.cleaner.clean(dashboard);
        ConfigXmlUtils.removeElement(this.findElementForDashboard(dashboard.getId()));
    }

    private Element findElementForDashboard(long id) {
        Element element = ConfigXmlUtils.getElementByXpath(this.document, String.format("/entity-engine-xml/PortalPage[@id='%d']", id));
        if (element == null) {
            throw new ConfigException("Could not find dashboard with id '" + id + "'.");
        }
        return element;
    }
}

