/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.crowd;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class PlaintextEncoderChecker
implements ConfigurationCheck {
    private static final Logger log = Logger.getLogger(PlaintextEncoderChecker.class);

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        List<Element> encryptionMethods = ConfigXmlUtils.getElementsByXpath(config.getDocument(), "/entity-engine-xml/DirectoryAttribute[@name='user_encryption_method']");
        Iterator<Element> i$ = encryptionMethods.iterator();
        while (i$.hasNext()) {
            String fastEncryptionMethodValue = "plaintext";
            Element encryptionMethod = i$.next();
            String currentEncryptionMethodValue = ConfigXmlUtils.getTextValue(encryptionMethod, "value");
            if (fastEncryptionMethodValue.equals(currentEncryptionMethodValue)) continue;
            builder.error(String.format("DirectoryAttribute 'user_encryption_method' is not set to '%s'. You can run the ConfigFixerUpperer to fix this and also to reset users passwords to be their username in plaintext", fastEncryptionMethodValue));
        }
        return builder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        List<Element> encryptionMethods = ConfigXmlUtils.getElementsByXpath(config.getDocument(), "/entity-engine-xml/DirectoryAttribute[@name='user_encryption_method']");
        Iterator<Element> i$ = encryptionMethods.iterator();
        while (i$.hasNext()) {
            String fastEncryptionMethodValue = "plaintext";
            Element encryptionMethod = i$.next();
            String currentEncryptionMethodValue = ConfigXmlUtils.getTextValue(encryptionMethod, "value");
            if (fastEncryptionMethodValue.equals(currentEncryptionMethodValue)) continue;
            log.info((Object)String.format("Changing 'user_encryption_method' from '%s' to '%s'", currentEncryptionMethodValue, fastEncryptionMethodValue));
            ConfigXmlUtils.setAttribute(encryptionMethod, "value", (Object)fastEncryptionMethodValue);
            List<Element> users = ConfigXmlUtils.getElementsByXpath(config.getDocument(), "/entity-engine-xml/User");
            for (Element user : users) {
                String username = ConfigXmlUtils.getTextValue(user, "userName");
                log.info((Object)String.format("Setting credential (password) of user '%s' to '%s'", username, username));
                ConfigXmlUtils.setAttribute(user, "credential", (Object)username);
            }
            config.markDirty();
        }
    }
}

