/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.mail.MailChecker;
import com.atlassian.jira.functest.config.service.ConfigService;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.Iterator;
import java.util.List;

public class ServiceChecker
implements ConfigurationCheck {
    private static final String CHECK_SERVICE = "service";
    private static final List<String> IGNORED_SERVICES;

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        List<ConfigService> services = config.getServices();
        for (ConfigService service : services) {
            String name;
            if (this.isIgnored(service)) continue;
            String string = name = service.getName() != null ? service.getName() : "<unknown>";
            if (!options.checkEnabled(CHECK_SERVICE)) continue;
            builder.error("Service '" + name + "' exits.", CHECK_SERVICE);
        }
        return builder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        List<ConfigService> services = config.getServices();
        Iterator<ConfigService> iterator = services.iterator();
        while (iterator.hasNext()) {
            ConfigService service = iterator.next();
            if (this.isIgnored(service) || !options.checkEnabled(CHECK_SERVICE)) continue;
            iterator.remove();
        }
    }

    private boolean isIgnored(ConfigService service) {
        for (String ignoredService : IGNORED_SERVICES) {
            if (!service.getClazz().contains(ignoredService)) continue;
            return true;
        }
        return false;
    }

    static {
        CollectionBuilder<String> builder = CollectionBuilder.newBuilder(MailChecker.SERVICES);
        builder.add("ExportService").add("MailQueueService").add("JiraPluginSchedulerService");
        IGNORED_SERVICES = builder.asList();
    }
}

