/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckMessage;
import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckOptionsUtils;
import com.atlassian.jira.functest.config.Checksummer;
import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.functest.config.ConfigFileWalker;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.ConfigurationDefaults;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ConfigurationChecker {
    private static final Logger log = Logger.getLogger(ConfigurationChecker.class);
    private File root = null;
    private boolean cache = true;
    private int version = 0;
    private List<ConfigurationCheck> configurationChecks = new ArrayList<ConfigurationCheck>();
    private List<IOFileFilter> excludes = new ArrayList<IOFileFilter>();

    public ConfigurationChecker(File root, Collection<? extends ConfigurationCheck> checks) {
        this.setRoot(root);
        this.setConfigurationChecks(checks);
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public List<ConfigurationCheck> getConfigurationChecks() {
        return this.configurationChecks;
    }

    public void setConfigurationChecks(Collection<? extends ConfigurationCheck> configurationChecks) {
        this.configurationChecks = configurationChecks == null ? new ArrayList<ConfigurationCheck>() : new ArrayList<ConfigurationCheck>(configurationChecks);
    }

    public List<IOFileFilter> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<IOFileFilter> excludes) {
        this.excludes = excludes == null ? new ArrayList<IOFileFilter>() : new ArrayList<IOFileFilter>(excludes);
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static ConfigurationChecker createDefaultChecker() {
        return ConfigurationChecker.createDefaultChecker(ConfigurationDefaults.getDefaultXmlDataLocation());
    }

    public static ConfigurationChecker createDefaultChecker(File root) {
        ConfigurationChecker checker = new ConfigurationChecker(root, ConfigurationDefaults.createDefaultConfigurationChecks());
        checker.setExcludes(ConfigurationDefaults.getDefaultExcludedFilters());
        checker.setVersion(1);
        return checker;
    }

    public CheckResult check() {
        Checksummer<File> checksummer = this.readCacheSummer();
        Visitor visitor = new Visitor(checksummer);
        ConfigFileWalker walker = new ConfigFileWalker(this.getRoot(), visitor);
        walker.setExcludes(this.getExcludes());
        walker.walk();
        if (checksummer != null && checksummer.isModified()) {
            this.writeCache(checksummer);
        }
        return visitor.getResult();
    }

    private Checksummer<File> readCacheSummer() {
        if (!this.cache) {
            return null;
        }
        Cache cache = this.readCache();
        if (cache == null || cache.getSummer() == null) {
            return ConfigurationChecker.createChecksum();
        }
        if (cache.getVersion() < this.getVersion()) {
            return ConfigurationChecker.createChecksum();
        }
        List<Class<? extends ConfigurationCheck>> currentChecks = this.getCheckClasses();
        List cachedChecks = cache.getCheckers();
        if (currentChecks.size() != cachedChecks.size() || !currentChecks.containsAll(cachedChecks)) {
            return ConfigurationChecker.createChecksum();
        }
        return cache.getSummer();
    }

    private static Checksummer<File> createChecksum() {
        return Checksummer.fileChecksummer("md5");
    }

    private Cache readCache() {
        File cacheFile = this.getCacheFile();
        if (cacheFile != null) {
            Cache cache = new Cache();
            cache.read(cacheFile);
            return cache;
        }
        return null;
    }

    private void writeCache(Checksummer<File> summer) {
        if (!this.cache) {
            return;
        }
        File cacheFile = this.getCacheFile();
        if (cacheFile == null) {
            return;
        }
        Cache cache = new Cache();
        cache.setVersion(this.getVersion());
        cache.setCheckers(this.getCheckClasses());
        cache.setSummer(summer);
        cache.save(cacheFile);
    }

    private List<Class<? extends ConfigurationCheck>> getCheckClasses() {
        ArrayList<Class<? extends ConfigurationCheck>> checker = new ArrayList<Class<? extends ConfigurationCheck>>();
        for (ConfigurationCheck check : this.configurationChecks) {
            checker.add(check.getClass());
        }
        return checker;
    }

    private File getCacheFile() {
        File parent = this.getRoot();
        if (!parent.isDirectory()) {
            return null;
        }
        return new File(parent, "check-cache.xml");
    }

    private static class Cache {
        private static final String ELEMENT_CACHE = "checker-cache";
        private static final String ATTRIB_VERSION = "version";
        private static final String ELEMENT_CHECKS = "checks";
        private static final String ELEMENT_CHECK = "check";
        private static final String ELEMENT_CHECKSUMS = "checksums";
        private int version;
        private List<Class<? extends ConfigurationCheck>> checkers;
        private Checksummer<File> summer;

        private Cache() {
        }

        private int getVersion() {
            return this.version;
        }

        private Cache setVersion(int version) {
            this.version = version;
            return this;
        }

        private List<Class<? extends ConfigurationCheck>> getCheckers() {
            return Collections.unmodifiableList(this.checkers);
        }

        private void setCheckers(Collection<Class<? extends ConfigurationCheck>> checkers) {
            this.checkers = new ArrayList(checkers == null ? Collections.emptyList() : checkers);
        }

        private Checksummer<File> getSummer() {
            return this.summer;
        }

        private void setSummer(Checksummer<File> summer) {
            this.summer = summer;
        }

        private void save(File file) {
            DocumentFactory factory = DocumentFactory.getInstance();
            Document document = factory.createDocument();
            Element rootElement = document.addElement(ELEMENT_CACHE);
            if (this.version >= 0) {
                rootElement.addAttribute(ATTRIB_VERSION, String.valueOf(this.version));
            }
            Element checks = rootElement.addElement(ELEMENT_CHECKS);
            for (Class<? extends ConfigurationCheck> checker : this.checkers) {
                Element check = checks.addElement(ELEMENT_CHECK);
                check.setText(checker.getName());
            }
            if (this.summer != null) {
                Element element = rootElement.addElement(ELEMENT_CHECKSUMS);
                this.summer.write(element);
            }
            this.writeDocument(file, document);
        }

        private void read(File file) {
            this.version = -1;
            Document document = this.readDocument(file);
            if (document != null) {
                ArrayList tmpCheckers = new ArrayList();
                Number number = document.numberValueOf("/checker-cache/@version");
                if (number != null && !Float.isNaN(number.floatValue())) {
                    this.version = number.intValue();
                }
                List elements = document.selectNodes("/checker-cache/checks/check/text()");
                for (Text element : elements) {
                    String klazzName = element.getText();
                    if (!StringUtils.isNotBlank((String)klazzName)) continue;
                    try {
                        Class<?> klazz = Class.forName(klazzName);
                        if (!ConfigurationCheck.class.isAssignableFrom(klazz)) continue;
                        tmpCheckers.add(klazz);
                    }
                    catch (ClassNotFoundException ignored) {}
                }
                this.checkers = Collections.unmodifiableList(tmpCheckers);
                Element checksums = document.getRootElement().element(ELEMENT_CHECKSUMS);
                if (checksums != null) {
                    this.summer = ConfigurationChecker.createChecksum();
                    this.summer.read(checksums);
                } else {
                    this.summer = null;
                }
            } else {
                this.checkers = Collections.emptyList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDocument(File file, Document document) {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                try {
                    XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
                    xmlWriter.write(document);
                    xmlWriter.close();
                }
                finally {
                    IOUtils.closeQuietly((Writer)writer);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Document readDocument(File file) {
            Document document;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try {
                SAXReader saxReader = new SAXReader();
                document = saxReader.read((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((Reader)reader);
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
                catch (DocumentException e) {
                    return null;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
            return document;
        }
    }

    public static class CheckResult {
        private final MultiMap<File, CheckMessage, List<CheckMessage>> errors = CheckResult.createMultiMap();
        private final MultiMap<File, CheckMessage, List<CheckMessage>> warnings = CheckResult.createMultiMap();

        private CheckResult() {
        }

        private void addWarning(File file, String message) {
            this.addWarning(file, new CheckMessage(message));
        }

        private void addWarning(File file, CheckMessage message) {
            this.warnings.put(file, message);
        }

        private void addWarnings(File file, Collection<CheckMessage> messages) {
            for (CheckMessage message : messages) {
                this.addWarning(file, message);
            }
        }

        private void addErrors(File file, Collection<CheckMessage> errors) {
            for (CheckMessage error : errors) {
                this.addError(file, error);
            }
        }

        private void addError(File file, String message) {
            this.addError(file, new CheckMessage(message));
        }

        private void addError(File file, CheckMessage message) {
            this.errors.put(file, message);
        }

        public Map<File, List<CheckMessage>> getErrors() {
            return Collections.unmodifiableMap(this.errors);
        }

        public Map<File, List<CheckMessage>> getWarnings() {
            return Collections.unmodifiableMap(this.warnings);
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        public String getFormattedMessage() {
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry entry : this.errors.entrySet()) {
                buffer.append("\nFile '").append(((File)entry.getKey()).getPath()).append("' has errors:");
                for (CheckMessage message : (List)entry.getValue()) {
                    buffer.append("\n\t[ERROR] ").append(message.getFormattedMessage());
                }
                List warns = (List)this.warnings.get(entry.getKey());
                if (warns == null) continue;
                for (CheckMessage warn : warns) {
                    buffer.append("\n\t[WARNING] ").append(warn.getFormattedMessage());
                }
            }
            for (Map.Entry entry : this.warnings.entrySet()) {
                if (this.errors.get(entry.getKey()) != null) continue;
                buffer.append("\nFile '").append(((File)entry.getKey()).getPath()).append("' has warnings:");
                for (CheckMessage message : (List)entry.getValue()) {
                    buffer.append("\n\t[WARNING] ").append(message.getFormattedMessage());
                }
            }
            return buffer.toString();
        }

        private static MultiMap<File, CheckMessage, List<CheckMessage>> createMultiMap() {
            return MultiMaps.create(new LinkedHashMap(), new Supplier<List<CheckMessage>>(){

                @Override
                public List<CheckMessage> get() {
                    return new ArrayList<CheckMessage>();
                }
            });
        }
    }

    private class Visitor
    implements ConfigFileWalker.ConfigVisitor {
        private final CheckResult result = new CheckResult();
        private final Checksummer<File> summer;

        private Visitor(Checksummer<File> summer) {
            this.summer = summer;
        }

        @Override
        public void visitConfig(ConfigFile file) {
            Document document;
            if (this.summer != null && !this.summer.hasChanged(file.getFile())) {
                return;
            }
            try {
                document = file.readConfig();
            }
            catch (ConfigFile.ConfigFileException e) {
                this.result.addError(file.getFile(), "Unable to read configuration: " + e.getMessage());
                return;
            }
            if (document == null) {
                this.result.addWarning(file.getFile(), "Does not appear to contain any data.");
            }
            if (!JiraConfig.isJiraXml(document)) {
                this.result.addWarning(file.getFile(), "File does not appear to contain JIRA XML.");
                return;
            }
            CheckOptions options = CheckOptionsUtils.parseOptions(document);
            JiraConfig config = new JiraConfig(document, file.getFile());
            boolean errors = false;
            for (ConfigurationCheck check : ConfigurationChecker.this.configurationChecks) {
                ConfigurationCheck.Result checkResut = check.checkConfiguration(config, options);
                this.result.addErrors(file.getFile(), checkResut.getErrors());
                this.result.addWarnings(file.getFile(), checkResut.getWarnings());
                errors = errors || !checkResut.isGood();
            }
            if (this.summer != null) {
                if (errors) {
                    this.summer.remove(file.getFile());
                } else {
                    this.summer.update(file.getFile());
                }
            }
        }

        @Override
        public void visitConfigError(File file, ConfigFile.ConfigFileException e) {
            this.result.addWarning(file, "Error occured while loading: " + e.getMessage());
            this.summer.remove(file);
            log.error((Object)("Unable to read configuration '" + file.getPath() + "'."), (Throwable)e);
        }

        private CheckResult getResult() {
            return this.result;
        }
    }
}

