/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckOptionsUtils;
import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.functest.config.ConfigFileWalker;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.ConfigurationDefaults;
import com.atlassian.jira.functest.config.JiraConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public class ConfigFixerUpperer {
    private static final Logger log = Logger.getLogger(ConfigFixerUpperer.class);
    private File root;
    private List<ConfigurationCheck> configurationChecks = new ArrayList<ConfigurationCheck>();
    private List<IOFileFilter> excludes = new ArrayList<IOFileFilter>();
    private boolean createBackups;

    public File getRoot() {
        return this.root;
    }

    public ConfigFixerUpperer setRoot(File root) {
        this.root = root;
        return this;
    }

    public List<ConfigurationCheck> getConfigurationChecks() {
        return this.configurationChecks;
    }

    public ConfigFixerUpperer setConfigurationChecks(Collection<? extends ConfigurationCheck> configurationChecks) {
        this.configurationChecks = configurationChecks == null ? new ArrayList<ConfigurationCheck>() : new ArrayList<ConfigurationCheck>(configurationChecks);
        return this;
    }

    public List<IOFileFilter> getExcludes() {
        return this.excludes;
    }

    public ConfigFixerUpperer setExcludes(Collection<IOFileFilter> excludes) {
        this.excludes = excludes == null ? new ArrayList<IOFileFilter>() : new ArrayList<IOFileFilter>(excludes);
        return this;
    }

    public boolean createBackups() {
        return this.createBackups;
    }

    public ConfigFixerUpperer setCreateBackups(boolean createBackups) {
        this.createBackups = createBackups;
        return this;
    }

    public void fix() {
        ConfigFileWalker walker = new ConfigFileWalker(this.getRoot(), new Visitor());
        walker.setExcludes(this.getExcludes());
        walker.walk();
    }

    public static void main(String[] args) {
        ConfigFixerUpperer fixer = new ConfigFixerUpperer();
        fixer.setRoot(ConfigurationDefaults.getDefaultXmlDataLocation());
        fixer.setConfigurationChecks(ConfigurationDefaults.createDefaultConfigurationChecks());
        fixer.setExcludes(ConfigurationDefaults.getDefaultExcludedFilters());
        fixer.setCreateBackups(false);
        fixer.fix();
    }

    private class Visitor
    implements ConfigFileWalker.ConfigVisitor {
        private Visitor() {
        }

        @Override
        public void visitConfig(ConfigFile file) {
            Document document;
            log.info((Object)String.format("Processing %s.", file.getFile().getAbsoluteFile()));
            try {
                document = file.readConfig();
            }
            catch (ConfigFile.ConfigFileException e) {
                log.error((Object)("Unable to read configuration '" + file.getFile().getPath() + "'."), (Throwable)e);
                return;
            }
            if (document == null) {
                log.warn((Object)String.format("File '%s' does not appear to contain any data.", file.getFile().getPath()));
                return;
            }
            if (!JiraConfig.isJiraXml(document)) {
                log.warn((Object)String.format("File '%s' does not appear to contain JIRA XML.", file.getFile().getPath()));
                return;
            }
            CheckOptions options = CheckOptionsUtils.parseOptions(document);
            JiraConfig config = new JiraConfig(document, file.getFile());
            for (ConfigurationCheck check : ConfigFixerUpperer.this.configurationChecks) {
                check.fixConfiguration(config, options);
            }
            if (config.save()) {
                log.info((Object)String.format("File %s has been updated.", file.getFile().getAbsoluteFile()));
                if (!ConfigFixerUpperer.this.createBackups || this.saveBackup(file.getFile())) {
                    file.writeFile(config.getDocument());
                }
            } else {
                log.debug((Object)String.format("File %s is good.", config.getFile().getAbsolutePath()));
            }
        }

        @Override
        public void visitConfigError(File file, ConfigFile.ConfigFileException e) {
            log.error((Object)("Unable to read configuration '" + file.getPath() + "'."), (Throwable)e);
        }

        private boolean saveBackup(File file) {
            File backup = new File(file.getParent(), file.getName() + ".bak");
            try {
                FileUtils.copyFile((File)file, (File)backup);
                return true;
            }
            catch (IOException e) {
                log.error((Object)String.format("Unable to create backup of file '%s' at '%s': %s.", file.getPath(), backup.getPath(), e.getMessage()), (Throwable)e);
                return false;
            }
        }
    }
}

