/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;

public class ConfigAdminLocator {
    private static final int PERMISSION_SYSTEM_ADMIN = 44;
    private static final int PERMISSION_ADMIN = 0;
    private final Document document;

    public ConfigAdminLocator(Document document) {
        this.document = document;
    }

    public Set<String> locateSystemAdmins() {
        HashSet<String> users = new HashSet<String>();
        Set<String> systemAdminGroups = this.getPermissionGroups(44);
        for (String group : systemAdminGroups) {
            users.addAll(this.getUserForGroupCrowd(group));
        }
        if (users.isEmpty()) {
            for (String group : systemAdminGroups) {
                users.addAll(this.getUsersForGroup(group));
            }
            if (users.isEmpty()) {
                for (String group : this.getPermissionGroups(0)) {
                    users.addAll(this.getUsersForGroup(group));
                }
            }
        }
        return users;
    }

    private Set<String> getUsersForGroup(String groupName) {
        return this.getAttributes(String.format("/*/OSMembership[@groupName='%s']/@userName", groupName));
    }

    private Set<String> getUserForGroupCrowd(String groupName) {
        return this.getAttributes(String.format("/*/Membership[@membershipType='GROUP_USER' and @parentName='%s']/@childName", groupName));
    }

    private Set<String> getPermissionGroups(int permission) {
        return this.getAttributes(String.format("/*/SchemePermissions[@type = 'group' and not(@scheme) and @permission='%d']/@parameter", permission));
    }

    private Set<String> getAttributes(String xpath) {
        List list = this.document.selectNodes(xpath);
        return ConfigAdminLocator.toSet(list);
    }

    private static Set<String> toSet(Collection<? extends Node> nodes) {
        HashSet<String> values = new HashSet<String>();
        for (Node node : nodes) {
            String parameter = StringUtils.stripToNull((String)node.getText());
            if (parameter == null) continue;
            values.add(parameter);
        }
        return values;
    }
}

