/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestWorkflowEditing
extends JIRAWebTest {
    public TestWorkflowEditing(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("editableworkflow.xml");
    }

    public void testSubtaskBlockingConditions() {
        this.gotoAdmin();
        this.clickLink("workflows");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("steps_live_Copy of jira");
        this.clickLinkWithText("Close Issue");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:subtaskblocking-condition");
        this.submit("Add");
        this.checkCheckbox("issue_statuses", "1");
        this.checkCheckbox("issue_statuses", "3");
        this.checkCheckbox("issue_statuses", "4");
        this.submit("Add");
        this.assertTextSequence(new String[]{"All sub-tasks must have one of the following statuses to allow parent issue transitions:", "Open", "In Progress", "or", "Reopened"});
        this.clickLinkWithText("Edit", 3);
        this.checkCheckbox("issue_statuses", "1");
        this.checkCheckbox("issue_statuses", "3");
        this.checkCheckbox("issue_statuses", "4");
        this.checkCheckbox("issue_statuses", "5");
        this.submit("Update");
        this.assertTextSequence(new String[]{"All sub-tasks must have one of the following statuses to allow parent issue transitions:", "Open", "In Progress", "Reopened", "or", "Resolved"});
        this.clickLinkWithText("Delete", 3);
        this.assertTextNotPresent("All sub-tasks must have one of the following statuses to allow parent issue transitions:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkflowAddFromXmlNotAvailableToAdmins() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("workflows");
            this.assertLinkWithTextNotPresent("import a workflow from XML");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkflowAddFromXmlAvailableToSysAdmins() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("workflows");
            this.assertLinkPresentWithText("import a workflow from XML");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }
}

