/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestDraftWorkflow
extends JIRAWebTest {
    public TestDraftWorkflow(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestDraftWorkflow.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @Override
    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDown();
    }

    public void testPublishDraftWorkflowWithFunnyNames() throws Exception {
        this.restoreData("TestDraftWorkflowFunnyNames.xml");
        this.gotoWorkFlow();
        this.clickLink("createDraft_Funny&Name");
        this.assertTextPresent("View Workflow Steps &mdash; Funny&amp;Name (Draft)");
        this.setFormElement("stepName", "In Progress");
        this.submit("Add");
        this.clickLinkWithText("workflows.");
        this.assertTextNotInTable("workflows_table", "Published draft workflowDude");
        this.clickLink("steps_live_Funny&Name");
        this.assertTextNotPresent("In Progress");
        this.clickLinkWithText("workflows.");
        this.clickLink("steps_draft_Funny&Name");
        this.assertTextPresent("In Progress");
        this.clickLink("workflows");
        this.clickLink("publishDraft_Funny&Name");
        this.assertTextPresent("Publish Draft Workflow");
        this.assertTextPresent("You are about to publish the workflow <strong>Funny&amp;Name (Draft)</strong>.  This will overwrite the active workflow <strong>Funny&amp;Name</strong> and remove the draft! Click Publish if you want to continue.");
        this.setWorkingForm("jiraform");
        this.clickButton("cancelButton");
        this.assertTextInTable("workflows_table", "Draft");
        this.clickLink("publishDraft_Funny&Name");
        this.checkCheckbox("enableBackup", "true");
        this.setFormElement("newWorkflowName", "overwritten workflowDude");
        this.submit("Publish");
        this.assertTextNotInColumn("workflows_table", 2, "Draft");
        this.assertTextInTable("workflows_table", "overwritten workflowDude");
        this.clickLink("steps_live_Funny&Name");
        this.assertTextPresent("In Progress");
        this.clickLink("workflows");
        this.clickLink("steps_live_overwritten workflowDude");
        this.assertTextNotInTable("steps_table", "In Progress");
    }

    public void testPublishDraftWorkflow() throws SAXException {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.setFormElement("stepName", "In Progress");
        this.submit("Add");
        this.clickLinkWithText("workflows.");
        this.assertTextNotInTable("workflows_table", "Published draft workflowDude");
        this.clickLink("steps_live_Workflow1");
        this.assertTextNotPresent("In Progress");
        this.clickLinkWithText("workflows.");
        this.clickLink("steps_draft_Workflow1");
        this.assertTextPresent("In Progress");
        this.clickLink("workflows");
        this.clickLink("publishDraft_Workflow1");
        this.assertTextPresent("Publish Draft Workflow");
        this.assertTextPresent("You are about to publish the workflow <strong>Workflow1 (Draft)</strong>.  This will overwrite the active workflow <strong>Workflow1</strong> and remove the draft! Click Publish if you want to continue.");
        this.setWorkingForm("jiraform");
        this.clickButton("cancelButton");
        this.assertTextInTable("workflows_table", "Draft");
        this.clickLink("publishDraft_Workflow1");
        this.checkCheckbox("enableBackup", "true");
        this.setFormElement("newWorkflowName", "overwritten workflowDude");
        this.submit("Publish");
        this.assertTextNotInColumn("workflows_table", 2, "Draft");
        this.assertTextInTable("workflows_table", "overwritten workflowDude");
        this.clickLink("steps_live_Workflow1");
        this.assertTextPresent("In Progress");
        this.clickLink("workflows");
        this.clickLink("steps_live_overwritten workflowDude");
        this.assertTextNotInTable("steps_table", "In Progress");
    }

    public void testPublishDraftWithoutBackup() throws SAXException {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.clickLink("workflows");
        WebTable table = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestDraftWorkflow.assertEquals((int)6, (int)table.getRowCount());
        this.clickLink("publishDraft_Workflow1");
        this.checkCheckbox("enableBackup", "false");
        this.submit("Publish");
        table = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestDraftWorkflow.assertEquals((int)5, (int)table.getRowCount());
    }

    public void testHideDeleteLink() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.assertLinkNotPresent("delete_step_1");
        this.clickLinkWithText("Open");
        this.assertLinkNotPresent("del_step");
        this.clickLink("workflows");
        this.clickLink("steps_draft_Workflow1");
        this.setFormElement("stepName", "ClosedStep");
        this.selectOption("stepStatus", "Closed");
        this.submit("Add");
        this.assertTextInTable("steps_table", "ClosedStep");
        this.assertLinkPresent("delete_step_2");
        this.clickLinkWithText("ClosedStep");
        this.assertLinkPresent("del_step");
        this.clickLink("workflows");
        this.clickLink("steps_draft_Workflow1");
        this.clickLink("delete_step_2");
        this.assertTextPresent("Delete Workflow Step: ClosedStep");
        this.submit("Delete");
        this.assertTextNotInTable("steps_table", "ClosedStep");
    }

    public void testEditStatusDisabled() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.assertTextInTable("steps_table", "Open");
        this.assertTextNotInTable("steps_table", "EditedStep");
        this.clickLink("edit_step_1");
        TestDraftWorkflow.assertTrue((boolean)this.isFormElementDisabled("jiraform", "stepStatus_select"));
        this.setFormElement("stepName", "EditedStep");
        this.submit("Update");
        this.assertTextInTable("steps_table", "EditedStep");
        this.setFormElement("stepName", "ClosedStep");
        this.selectOption("stepStatus", "Closed");
        this.submit("Add");
        this.assertTextNotInTable("steps_table", "Reopened");
        this.assertTextNotInTable("steps_table", "ClosedStepEdit");
        this.clickLink("edit_step_2");
        TestDraftWorkflow.assertFalse((boolean)this.isFormElementDisabled("jiraform", "stepStatus_select"));
        this.setFormElement("stepName", "ClosedStepEdit");
        this.selectOption("stepStatus", "Reopened");
        this.submit("Update");
        this.assertTextInTable("steps_table", "Reopened");
        this.assertTextInTable("steps_table", "ClosedStepEdit");
    }

    public void testEditValidation() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.gotoPage(this.page.addXsrfToken("secure/admin/workflows/EditWorkflowStep.jspa?workflowMode=draft&workflowName=Workflow1&workflowStep=1&stepStatus=Closed&stepName=sweet"));
        this.assertTextPresent("Cannot change the status of an existing step on a draft workflow");
    }

    public void testDeleteDraftValidation() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.gotoPage("secure/admin/workflows/DeleteWorkflowStep!default.jspa?workflowMode=draft&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.submit("Delete");
        this.assertTextPresent("Cannot delete an existing step on a draft workflow.");
    }

    public void testDeleteValidation() {
        this.gotoWorkFlow();
        this.gotoPage("secure/admin/workflows/DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.submit("Delete");
        this.assertTextPresent("Cannot delete step. This workflow is not editable.");
    }

    public void testWorkflowInfoBox() {
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow1");
        this.assertTextPresent("You are viewing an active workflow.");
        this.assertTextSequence(new String[]{"Create", "a draft workflow"});
        this.assertTextNotPresent("Steps that exist on the active workflow, can't be deleted from the draft workflow.");
        this.assertTextPresent("This workflow was last edited by <strong>you</strong> at");
        this.grantGlobalPermission(0, "jira-users");
        this.logout();
        this.login("fred", "fred");
        this.gotoAdmin();
        this.clickLink("workflows");
        this.clickLink("steps_live_Workflow1");
        this.assertTextPresent("You are viewing an active workflow.");
        this.assertTextSequence(new String[]{"Create", "a draft workflow."});
        this.assertTextSequence(new String[]{"This workflow was last edited by", "admin"});
        this.assertTextNotPresent("Steps that exist on the active workflow, can't be deleted from the draft workflow.");
        this.clickLink("workflow_edited_admin");
        this.assertTextSequence(new String[]{"User Profile", "Administrator"});
        this.gotoAdmin();
        this.clickLink("workflows");
        this.clickLink("steps_live_Workflow1");
        this.clickLink("create_draft_workflow");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow1"});
        this.assertTextPresent("You are editing a draft workflow");
        this.assertTextSequence(new String[]{"View", "the original workflow or", "publish", "this draft."});
        this.assertTextPresent("This draft was last edited by <strong>you</strong> at");
        this.assertTextPresent("Steps that exist on the active workflow, can't be deleted from the draft workflow.");
        this.clickLink("view_live_workflow");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow1"});
        this.assertTextPresent("You are viewing an active workflow.");
        this.assertTextSequence(new String[]{"Edit", "the draft workflow."});
        this.assertTextSequence(new String[]{"This workflow was last edited by", "admin"});
        this.assertTextNotPresent("Steps that exist on the active workflow, can't be deleted from the draft workflow.");
        this.clickLinkWithText("Open");
        this.assertTextNotPresent("This step exists on the active workflow, which means it can't be deleted from this draft workflow.");
        this.clickLink("view_draft_workflow");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow1"});
        this.assertTextPresent("You are editing a draft workflow");
        this.assertTextSequence(new String[]{"View", "the original workflow or", "publish", "this draft."});
        this.assertTextSequence(new String[]{"This draft was last edited by <strong>you</strong> at"});
        this.assertTextPresent("Steps that exist on the active workflow, can't be deleted from the draft workflow.");
        this.clickLinkWithText("Open");
        this.assertTextPresent("View Workflow Step &mdash; Open");
        this.assertTextSequence(new String[]{"You are editing a draft workflow.", "View", "the original workflow or", "publish", "this draft."});
        this.assertTextNotPresent("last edited by");
        this.assertTextPresent("This step exists on the active workflow, which means it can't be deleted from this draft workflow.");
        this.clickLink("view_transition_1");
        this.assertTextSequence(new String[]{"You are editing a draft workflow.", "View", "the original workflow or", "publish", "this draft."});
        this.assertTextNotPresent("last edited by");
        this.assertTextNotPresent("This step exists on the active workflow, which means it can't be deleted from this draft workflow.");
        this.clickLinkWithText("publish");
        this.assertTextPresent("Publish Draft Workflow");
        this.assertTextSequence(new String[]{"You are about to publish the workflow", "Workflow1 (Draft)", "This will overwrite the active workflow", "Workflow1", "and remove the draft", "Click Publish if you want to continue"});
    }

    public void testWorkflowDraftName() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.assertTextSequence(new String[]{"This shows all of the steps for", "Workflow1 (Draft)", "Steps that exist on the active workflow, can't be deleted from the draft workflow."});
        this.setFormElement("stepName", "Dude");
        this.submit("Add");
        this.clickLinkWithText("Add Transition");
        this.setFormElement("transitionName", "testTransition");
        this.submit("Add");
        this.clickLinkWithText("Open");
        this.assertTextSequence(new String[]{"View", "workflow steps", "of", "Workflow1 (Draft)"});
        this.clickLinkWithText("testTransition");
        this.assertTextPresent("Transition: testTransition");
        this.assertTextSequence(new String[]{"View", "workflow steps", "of", "Workflow1 (Draft)"});
        this.clickLinkWithText("Open");
        this.clickLink("view_properties_1");
        this.assertTextSequence(new String[]{"View", "workflow steps", "of", "Workflow1 (Draft)"});
        this.clickLink("workflows");
        this.clickLink("steps_live_Workflow1");
        this.assertTextNotPresent("(Draft)");
        this.clickLinkWithText("Open");
        this.assertTextNotPresent("(Draft)");
        this.clickLink("view_properties_1");
        this.assertTextNotPresent("(Draft)");
        this.clickLinkWithText("workflow steps");
        this.clickLinkWithText("Open");
        this.clickLink("view_transition_1");
        this.assertTextNotPresent("(Draft)");
    }

    protected void _testCreateAndDeleteDraftWorkflow(int operationColumn) throws SAXException {
        this.gotoWorkFlow();
        WebTable table = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestDraftWorkflow.assertEquals((int)5, (int)table.getRowCount());
        this.assertTableCellHasText("workflows_table", 2, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 2, 2, "Active");
        this.assertTableCellHasText("workflows_table", 2, operationColumn, "Create Draft");
        this.assertTextNotInColumn("workflows_table", 2, "Draft");
        this.clickLink("createDraft_Workflow1");
        this.clickLinkWithText("workflows.");
        this.assertTableCellHasText("workflows_table", 2, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 2, 2, "Active");
        this.assertTableCellHasNotText("workflows_table", 2, operationColumn, "Create Draft");
        table = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestDraftWorkflow.assertEquals((int)6, (int)table.getRowCount());
        this.assertTableCellHasText("workflows_table", 3, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 3, 2, "Draft");
        this.assertTableCellHasText("workflows_table", 3, operationColumn, "Delete");
        this.assertTableCellHasText("workflows_table", 3, operationColumn, "Publish");
        this.clickLink("del_Workflow1");
        this.assertTextPresent("Delete Draft Workflow");
        this.assertTextPresent("Confirm that you want to delete the draft workflow <strong>Workflow1</strong>.");
        this.submit("Delete");
        this.assertTableCellHasText("workflows_table", 2, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 2, 2, "Active");
        this.assertTableCellHasText("workflows_table", 2, operationColumn, "Create Draft");
        this.assertTextNotInColumn("workflows_table", 2, "Draft");
        table = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestDraftWorkflow.assertEquals((int)5, (int)table.getRowCount());
    }

    public void testDraftWorkflowWithInactiveParent() {
        this.restoreData("TestDraftWorkflowInvalidState.xml");
        this.gotoWorkFlow();
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The parent workflow of draft 'Workflow1' is no longer active. Please delete the draft. You may wish to copy the draft before deleting it.");
        this.assertLinkNotPresentWithText("Publish");
        this.gotoPage("secure/admin/workflows/PublishDraftWorkflow!default.jspa?workflowMode=live&workflowName=Workflow1");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextPresent("Publish Draft Workflow");
        this.submit("Publish");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The parent workflow of draft 'Workflow1' is no longer active. Please delete the draft. You may wish to copy the draft before deleting it.");
    }

    public void testEditParentNameWithInactiveDraft() throws SAXException {
        this.restoreData("TestDraftWorkflowInvalidState.xml");
        this.gotoWorkFlow();
        this.assertTableCellHasText("workflows_table", 2, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 3, 0, "Workflow1");
        this.clickLink("edit_live_Workflow1");
        this.setFormElement("newWorkflowName", "InvalidWorkflowNow");
        this.setFormElement("description", "My weird description.");
        this.submit("Edit");
        this.assertTableCellHasText("workflows_table", 2, 0, "InvalidWorkflowNow");
        this.assertTableCellHasText("workflows_table", 2, 1, "My weird description.");
        this.assertTableCellHasText("workflows_table", 3, 0, "InvalidWorkflowNow");
        this.assertTableCellHasNotText("workflows_table", 3, 1, "My weird description.");
        this.clickLink("edit_draft_InvalidWorkflowNow");
        this.setFormElement("description", "dude this is a draft");
        this.submit("Edit");
        this.assertTableCellHasText("workflows_table", 2, 0, "InvalidWorkflowNow");
        this.assertTableCellHasText("workflows_table", 2, 1, "My weird description.");
        this.assertTableCellHasText("workflows_table", 3, 0, "InvalidWorkflowNow");
        this.assertTableCellHasText("workflows_table", 3, 1, "dude this is a draft");
    }

    public void testDeleteLinkNotShownForInitialTransition() {
        this.gotoWorkFlow();
        this.clickLink("copy_jira");
        this.submit("Copy");
        this.clickLink("steps_live_Copy of jira");
        this.clickLinkWithText("Open");
        this.clickLinkWithText("Start Progress");
        this.assertTextPresent("Transition: Start Progress");
        this.assertLinkPresent("delete_transition");
        this.clickLinkWithText("Open");
        this.clickLink("view_transition_1");
        this.assertTextPresent("Transition: Create Issue");
        this.assertLinkNotPresent("delete_transition");
    }

    public void testAddTransitionForStepWithNoTransitions() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.assertLinkWithTextNotPresent("Add Transition");
        this.clickLinkWithText("Open");
        this.assertTextPresent("The step <strong>Open</strong> has no outgoing transitions in the Active workflow, so you cannot add any outgoing transitions in the Draft workflow.");
        this.assertLinkWithTextNotPresent("Add Transition");
        this.gotoPage("/secure/admin/workflows/AddWorkflowTransition!default.jspa?workflowMode=draft&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextPresent("Add Workflow Transition");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("You are editing a draft workflow. The step 'Open' has no outgoing transitions in the Active workflow, so you cannot add any outgoing transitions in the Draft workflow.");
        this.submit("Add");
        this.assertTextPresent("Add Workflow Transition");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("You are editing a draft workflow. The step 'Open' has no outgoing transitions in the Active workflow, so you cannot add any outgoing transitions in the Draft workflow.");
        this.gotoWorkFlow();
        this.clickLink("steps_draft_Workflow1");
        this.setFormElement("stepName", "Dude");
        this.submit("Add");
        this.clickLinkWithText("Add Transition");
        this.setFormElement("transitionName", "New Transition");
        this.submit("Add");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow1 (Draft)"});
        this.assertTextPresent("New Transition");
    }

    public void testOverWriteWorkflowWithInvalidTransition() {
        this.restoreData("TestOverwriteInvalidWorkflow.xml");
        this.gotoWorkFlow();
        this.clickLink("publishDraft_Workflow1");
        this.checkCheckbox("enableBackup", "false");
        this.submit("Publish");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("You are editing a draft workflow. The step 'Open' has no outgoing transitions in the Active workflow, so you cannot add any outgoing transitions in the Draft workflow");
    }
}

