/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.meterware.httpunit.WebLink;
import org.xml.sax.SAXException;

public class TestUserNameIsEncoded
extends FuncTestCase {
    public void testUserNamesAreHtmlEncoded() throws SAXException {
        String brokenUsername = "&quot;my &lt;input&gt; name";
        this.administration.restoreData("TestUsernameIsEncoded.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.text.assertTextPresent(this.locator.page(), "Is my broken-name really bad?");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee:", "&quot;my &lt;input&gt; name");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), "Reporter:", "&quot;my &lt;input&gt; name");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), "field1:", "&quot;my &lt;input&gt; name");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), "field2:", "&quot;my &lt;input&gt; name");
        WebLink[] webLinks = this.tester.getDialog().getResponse().getLinks();
        int count = 0;
        for (WebLink webLink : webLinks) {
            if (webLink.asText().indexOf("\"my <input> name") < 0) continue;
            ++count;
        }
        TestUserNameIsEncoded.assertEquals((int)4, (int)count);
        this.tester.clickLink("editIssue");
        this.text.assertTextPresent(this.locator.page(), "Edit Issue");
        this.tester.selectOption("assignee", "\"my <input> name");
        this.tester.assertFormElementEquals("reporter", "broken");
        this.tester.assertFormElementEquals("customfield_10000", "broken");
        this.tester.assertFormElementEquals("customfield_10001", "admin, broken");
    }
}

