/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestUserDefaults
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testIssuesPerPageValidation() throws Exception {
        this._testIssuesPerPageValidation("0", false);
        this._testIssuesPerPageValidation("-100", false);
        this._testIssuesPerPageValidation("1001", false);
        this._testIssuesPerPageValidation("1", true);
        this._testIssuesPerPageValidation("1000", true);
        this._testIssuesPerPageValidation("500", true);
    }

    private void _testIssuesPerPageValidation(String setting, boolean valid) {
        this.navigation.gotoAdminSection("user_defaults");
        this.navigation.clickLinkWithExactText("Edit default values");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("numIssues", setting);
        this.tester.submit("Update");
        if (valid) {
            this.text.assertTextSequence(new XPathLocator(this.tester, "//table[@id='view_user_defaults']"), new String[]{"Number of Issues displayed per Issue Navigator page", setting});
        } else {
            this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='edit_user_defaults']"), "Issues per page must be a number between 1 and 1000");
        }
    }
}

