/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;

public class TestNonExistentUsers
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestNonExistentUsers.xml");
    }

    public void testNonExistentSearcher() {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        TestNonExistentUsers.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Could not find username:", "fred"});
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are errors with your search query on the left, please correct them before continuing.");
        this.tester.assertLinkNotPresentWithText("fred");
    }

    public void testNonExistentReporterAndAssignee() {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "fred");
        this.text.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "fred");
        this.tester.assertLinkNotPresentWithText("fred");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        TestNonExistentUsers.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Could not find username:", "fred"});
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are errors with your search query on the left, please correct them before continuing.");
    }

    public void testNullReporterAndAssignee() {
        this.administration.restoreData("TestNullAssigneeAndReporter.xml");
        this.assertViewIssueAssigneeAndReporter("AA-1", "Unassigned", "Anonymous");
        this.assertViewIssueAssigneeAndReporter("AA-2", "Unassigned", "admin");
        this.assertViewIssueAssigneeAndReporter("AA-3", "admin", "Anonymous");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertNavigatorAssigneeAndReporter(1, "AA-3", "admin", "Anonymous");
        this.assertNavigatorAssigneeAndReporter(2, "AA-2", "Unassigned", "admin");
        this.assertNavigatorAssigneeAndReporter(3, "AA-1", "Unassigned", "Anonymous");
    }

    private void assertNavigatorAssigneeAndReporter(int row, String issueKey, String assigneeName, String reporterName) {
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 1), issueKey);
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 3), assigneeName);
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 4), reporterName);
    }

    private void assertViewIssueAssigneeAndReporter(String issueKey, String assigneeName, String reporterName) {
        this.navigation.issue().viewIssue(issueKey);
        this.text.assertTextSequence(new IdLocator(this.tester, "assignee-val"), assigneeName, new String[0]);
        this.text.assertTextSequence(new IdLocator(this.tester, "reporter-val"), reporterName, new String[0]);
    }

    public void testUserWithNoFullName() {
        this.administration.restoreData("TestNonExistentUsersNoFullname.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.assertProfileLinkPresent("assignee_admin", "admin");
        this.assertions.assertProfileLinkPresent("reporter_admin", "admin");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "admin");
    }
}

