/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestEditUserProjectRoles
extends JIRAWebTest {
    private static final String ICON_DIRECT_MEMBER = "/images/icons/emoticons/user_16.gif";
    private static final String ICON_NOT_MEMBER = "/images/icons/emoticons/user_bw_16.gif";
    private static final String ICON_GROUP_MEMBER = "/images/icons/emoticons/group_16.gif";

    public TestEditUserProjectRoles(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestEditUserProjectRoles.xml");
    }

    public void testNoProjectAssociationsForViewPage() {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("tester");
        this.clickLink("viewprojectroles_link");
        this.assertTextPresent("There are currently no project role associations for this user.");
    }

    public void testAddAssociationToProjects() throws SAXException {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("john");
        this.clickLink("viewprojectroles_link");
        this.assertTextNotPresent("There are currently no project role associations for this user.");
        this.clickLinkWithText("Edit Project Roles");
        this.assertTextNotPresent("There are currently no project role associations for this user.");
        this.gotoPage("secure/admin/user/EditUserProjectRoles!refresh.jspa?projects_to_add=10010&name=john");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertCheckboxNotSelected("10010_10011");
        this.assertCheckboxNotSelected("10010_10010");
        this.assertCheckboxNotSelected("10010_10012");
        this.checkCheckbox("10010_10011", "on");
        this.checkCheckbox("10010_10010", "on");
        this.assertCheckboxSelected("10010_10011");
        this.assertCheckboxSelected("10010_10010");
        this.submit("Save");
        WebTable userProjectRolesTable = this.getDialog().getResponse().getTableWithID("projecttable");
        TestEditUserProjectRoles.assertTrue((boolean)this.tableCellHasText(userProjectRolesTable, 3, 0, "Chimps"));
        this.assertTableCellHasImage(userProjectRolesTable, 3, 1, ICON_DIRECT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 3, 2, ICON_DIRECT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 3, 3, ICON_NOT_MEMBER);
        TestEditUserProjectRoles.assertTrue((boolean)this.tableCellHasText(userProjectRolesTable, 4, 0, "Donkeys"));
        this.assertTableCellHasImage(userProjectRolesTable, 4, 1, ICON_DIRECT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 4, 1, ICON_GROUP_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 4, 2, ICON_DIRECT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 4, 3, ICON_DIRECT_MEMBER);
        TestEditUserProjectRoles.assertTrue((boolean)this.tableCellHasText(userProjectRolesTable, 5, 0, "homosapien"));
        this.assertTableCellHasImage(userProjectRolesTable, 5, 1, ICON_GROUP_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 5, 2, ICON_NOT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 5, 3, ICON_NOT_MEMBER);
        this.clickLink("view_projects");
        this.clickLinkWithText("homosapien");
        this.clickLinkWithText("View members");
        this.assertTextPresentAfterText("short_Administrators_atlassian-user-role-actor", "Administrator");
    }

    public void testAddAssociationToProjectThatHasAMemberWithTheSameFullname() throws SAXException {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("user2");
        this.clickLink("viewprojectroles_link");
        this.clickLinkWithText("Edit Project Roles");
        this.assertTextPresent("There are currently no project role associations for this user.");
        this.gotoPage("secure/admin/user/EditUserProjectRoles!refresh.jspa?projects_to_add=10020&name=user2");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertCheckboxNotSelected("10020_10011");
        this.assertCheckboxNotSelected("10020_10010");
        this.assertCheckboxNotSelected("10020_10012");
        this.checkCheckbox("10020_10011", "on");
        this.checkCheckbox("10020_10010", "on");
        this.assertCheckboxNotSelected("10020_10012");
        this.submit("Save");
        this.assertTextPresent("Donkeys");
        WebTable userProjectRolesTable = this.getDialog().getResponse().getTableWithID("projecttable");
        TestEditUserProjectRoles.assertTrue((boolean)this.tableCellHasText(userProjectRolesTable, 3, 0, "Donkeys"));
        this.assertTableCellHasImage(userProjectRolesTable, 3, 1, ICON_DIRECT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 3, 2, ICON_DIRECT_MEMBER);
        this.assertTableCellHasImage(userProjectRolesTable, 3, 3, ICON_NOT_MEMBER);
        this.assertTextNotPresent("There are currently no project role associations for this user.");
        this.goToProject("Donkeys");
        this.clickLinkWithText("View members");
        this.assertTextPresentBeforeText("SameName,", "SameName");
        this.clickLink("edit_Administrators_atlassian-user-role-actor");
        this.assertTextPresent("Assign Users to Project Role: Administrators");
        this.assertTextPresent("user1");
        this.assertTextPresent("user2");
        this.goToProject("Donkeys");
        this.clickLinkWithText("View members");
        this.clickLink("edit_Developers_atlassian-user-role-actor");
        this.assertTextPresent("Assign Users to Project Role: Developers");
        this.assertTextPresent("user1");
        this.assertTextPresent("user2");
        this.goToProject("Donkeys");
        this.clickLinkWithText("View members");
        this.clickLink("edit_Users_atlassian-user-role-actor");
        this.assertTextPresent("Assign Users to Project Role: Users");
        this.assertTextPresent("user1");
        this.assertTextNotPresent("user2");
    }

    public void testRemoveAssociationFromProject() {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("admin");
        this.clickLink("viewprojectroles_link");
        this.clickLinkWithText("Edit Project Roles");
        this.assertTextPresent("monkey");
        this.assertTextPresent("homosapien");
        this.uncheckCheckbox("10001_10011");
        this.submit("Save");
        this.assertTextPresent("homosapien");
        this.assertTextNotPresent("monkey");
        this.clickLinkWithText("Edit Project Roles");
        this.assertTextInTable("projecttable", "homosapien");
        this.assertTextNotInTable("projecttable", "monkey");
    }

    public void testGlobalAdminCanRemoveAnyoneFromRole() {
        this.gotoAdmin();
        this.clickLink("admin_link");
        this.clickLinkWithText("Donkeys");
        this.clickLinkWithText("View members");
        this.clickLink("edit_Administrators_atlassian-group-role-actor");
        this.checkCheckbox("removegroups_jira-administrators", ".");
        this.submit("remove");
        this.clickLink("view_projects");
        this.clickLinkWithText("homosapien");
        this.clickLinkWithText("View members");
        this.clickLink("edit_Administrators_atlassian-group-role-actor");
        this.checkCheckbox("removegroups_jira-developers", ".");
        this.submit("remove");
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("add_perm_23");
        this.checkCheckbox("type", "projectrole");
        this.selectOption("projectrole", "Administrators");
        this.submit();
        this.clickLink("user_browser");
        this.gotoPage("/secure/admin/user/ViewUserProjectRoles!default.jspa?returnUrl=UserBrowser.jspa&name=admin");
        this.navigation.checkWebSudoWithLastPassword();
        this.clickLinkWithText("Edit Project Roles");
        this.uncheckCheckbox("10000_10011");
        this.uncheckCheckbox("10001_10011");
        this.submit("Save");
        this.assertTextNotPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
        this.assertTextPresent("View Project Roles for User");
    }

    public void testGroupAssociationPresentInEditProjectRolesForUser() {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("admin");
        this.clickLink("viewprojectroles_link");
        this.assertTextPresent("(jira-developers)");
    }

    public void testGroupAssociationPresentInViewProjectRolesForUser() {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("barney");
        this.clickLink("viewprojectroles_link");
        this.assertTextPresent("(jira-developers)");
    }
}

