/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestTimeTrackingIsEditable
extends FuncTestCase {
    private static final String ORIGINAL_ESTIMATE_FORM_ELEMENT_NAME = "timetracking_originalestimate";
    private static final String REMAINING_ESTIMATE_FORM_ELEMENT_NAME = "timetracking_remainingestimate";
    private static final String RESOLVE_ISSUE_LINK_ID = "action_id_5";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    public void testAllEstimatesAreEditableOnCreateIssue() throws Exception {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.assertEstimateInputFieldsArePresent();
        this.tester.setFormElement("summary", "Test Original and Remaining Estimate Are Editable On Create");
        this.tester.setFormElement(ORIGINAL_ESTIMATE_FORM_ELEMENT_NAME, "1d");
        this.tester.setFormElement(REMAINING_ESTIMATE_FORM_ELEMENT_NAME, "1d");
        this.tester.submit("Create");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("1d", "1d", "Not Specified");
    }

    public void testsAllEstimatesAreEditableOnEditBeforeLoggingWork() {
        this.navigation.issue().gotoIssue("HSP-4");
        this.tester.clickLink("editIssue");
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().setEstimates("HSP-4", "4d", "4d");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "4d", "Not Specified");
    }

    public void testAllEstimatesAreEditableOnEditAfterLoggingWork() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("editIssue");
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().setEstimates("HSP-1", "4d", "0");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "0m", "3d");
    }

    public void testAllEstimatesAreEditableOnTransitionBeforeLoggingWork() {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().gotoIssue("HSP-4");
        this.tester.clickLink(RESOLVE_ISSUE_LINK_ID);
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().resolveIssue("HSP-4", "Fixed", "Test All Estimates Are Editable On Transition After Logging Work", "4d", "0");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "0m", "Not Specified");
    }

    public void testAllEstimatesAreEditableOnTransitionAfterLoggingWork() {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink(RESOLVE_ISSUE_LINK_ID);
        this.assertEstimateInputFieldsArePresent();
        this.navigation.issue().resolveIssue("HSP-1", "Fixed", "Test All Estimates Are Editable On Transition After Logging Work", "4d", "0");
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.assertTimeTrackingValuesAreEqualTo("4d", "0m", "3d");
    }

    private void assertEstimateInputFieldsArePresent() {
        this.tester.assertFormElementPresent(ORIGINAL_ESTIMATE_FORM_ELEMENT_NAME);
        this.tester.assertFormElementPresent(REMAINING_ESTIMATE_FORM_ELEMENT_NAME);
    }

    private void assertIssueHasBeenCreatedOrEditedSuccessfully() {
        String issueKeyTagId = "key-val";
        this.tester.assertElementPresent("key-val");
        TestTimeTrackingIsEditable.assertNotNull((Object)new IdLocator(this.tester, "key-val"));
    }

    private void assertTimeTrackingValuesAreEqualTo(String originalEstimateValue, String remainingEstimateValue, String timeSpentValue) {
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_single_values_orig"), originalEstimateValue);
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_single_values_remain"), remainingEstimateValue);
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_single_values_spent"), timeSpentValue);
    }

    private void addTimeTrackingFieldToResolveIssueScreen() {
        this.navigation.gotoAdminSection("field_screens");
        this.tester.assertLinkPresent("configure_fieldscreen_Resolve Issue Screen");
        this.tester.clickLink("configure_fieldscreen_Resolve Issue Screen");
        this.tester.selectOption("fieldId", "Time Tracking");
        this.tester.clickButton("add_field_submit");
    }
}

