/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestTimeTrackingDefaultUnit
extends FuncTestCase {
    public void testDefaultUnitIsMinutes() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.getTester().assertTextPresent("The current default unit for time tracking is <b>minute</b>.");
    }

    public void testDefaultUnitCanBeSet() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable("24", "7", "pretty", "hour", TimeTracking.Mode.LEGACY);
        this.text.assertTextPresent("The current default unit for time tracking is <b>hour</b>.");
        String issueKey = this.createNewIssueWithTimeTrackingEstimate("5");
        this.text.assertTextPresent("Time Tracking");
        this.assertTimeTrackingFields("5h", "5h", "Not Specified");
        this.navigation.issue().logWork(issueKey, "3");
        this.assertTimeTrackingFields("5h", "2h", "3h");
    }

    public void testSwitchDefaultUnitWhileChangingTheLengthOfWeeksAndWorkingDays() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable("8", "5", "pretty", "day", TimeTracking.Mode.LEGACY);
        this.text.assertTextPresent("The current default unit for time tracking is <b>day</b>.");
        String issueKey = this.createNewIssueWithTimeTrackingEstimate("11");
        this.text.assertTextPresent("Time Tracking");
        this.assertTimeTrackingFields("2w 1d", "2w 1d", "Not Specified");
        this.navigation.issue().logWork(issueKey, "1w");
        this.assertTimeTrackingFields("2w 1d", "1w 1d", "1w");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("24", "2", "pretty", "week", TimeTracking.Mode.LEGACY);
        this.text.assertTextPresent("The current default unit for time tracking is <b>week</b>.");
        this.navigation.issue().viewIssue(issueKey);
        this.assertTimeTrackingFields("1w 1d 16h", "1w", "1d 16h");
        this.navigation.issue().logWork(issueKey, "1");
        this.assertTimeTrackingFields("1w 1d 16h", "0m", "1w 1d 16h");
    }

    public void testSwitchDefaultUnitOnly() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable("6", "5", "pretty", "minute", TimeTracking.Mode.LEGACY);
        this.text.assertTextPresent("The current default unit for time tracking is <b>minute</b>.");
        String issueKey = this.createNewIssueWithTimeTrackingEstimate("3w");
        this.text.assertTextPresent("Time Tracking");
        this.assertTimeTrackingFields("3w", "3w", "Not Specified");
        this.navigation.issue().logWork(issueKey, "120");
        this.assertTimeTrackingFields("3w", "2w 4d 4h", "2h");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("6", "5", "pretty", "hour", TimeTracking.Mode.LEGACY);
        this.getTester().assertTextPresent("The current default unit for time tracking is <b>hour</b>.");
        this.navigation.issue().viewIssue(issueKey);
        this.navigation.issue().logWork(issueKey, "5");
        this.assertTimeTrackingFields("3w", "2w 3d 5h", "1d 1h");
    }

    private void assertTimeTrackingFields(String originalEstimate, String remainingEstimate, String timeSpent) {
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", originalEstimate, "Remaining:", remainingEstimate, "Logged:", timeSpent);
    }

    private String createNewIssueWithTimeTrackingEstimate(String originalEstimate) {
        String issueSummary = "Morbi pretium mattis nulla";
        this.getTester().clickLink("create_link");
        this.getTester().submit("Next");
        this.getTester().setFormElement("summary", "Morbi pretium mattis nulla");
        this.getTester().setFormElement("timetracking", originalEstimate);
        this.getTester().submit("Create");
        this.text.assertTextPresent("Morbi pretium mattis nulla");
        return new IdLocator(this.getTester(), "key-val").getText();
    }
}

