/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestReindexingSubtasks
extends JIRAWebTest {
    public TestReindexingSubtasks(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestReindexingSubtasks.xml");
    }

    public void testEditSingleIssue() throws SAXException {
        this.assertPrecondition();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Mouse");
        this.clickLinkWithText("RAT-5");
        this.clickLink("editIssue");
        this.assertTextSequence(new String[]{"Security Level", "Level Mouse", "Priority"});
        this.selectOption("security", "Level KingRat");
        this.submit("Update");
        this.clickLink("return-to-search");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level KingRat");
        this.assertTextNotPresent("Level Mouse");
    }

    public void testMoveSingleIssue() {
        this.assertPrecondition();
        this.gotoIssue("COW-35");
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue: COW-35");
        this.selectOption("pid", "Porcine");
        this.selectOption("issuetype", "Bug");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: Update Fields");
        this.assertTextPresent("Step 2 is not required");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: Confirm");
        this.assertTextSequence(new String[]{"Project", "Bovine", "Porcine"});
        this.assertTextSequence(new String[]{"Type", "Improvement", "Bug"});
        this.assertTextSequence(new String[]{"Status", "Open", "(Copy of jira)", "Open", "(jira)"});
        this.assertTextSequence(new String[]{"Security Level", "MyFriendsOnly", "None"});
        this.submit("Move");
        this.displayAllIssues();
        this.assertTextNotPresent("MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 4, 1, "PIG-12");
        this.assertTableCellHasText("issuetable", 4, 2, "PIG-9");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 5, 1, "PIG-11");
        this.assertTableCellHasText("issuetable", 5, 2, "PIG-9");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 6, 1, "PIG-10");
        this.assertTableCellHasText("issuetable", 6, 2, "PIG-9");
        this.assertTableCellHasText("issuetable", 6, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 1, "PIG-9");
        this.assertTableCellHasText("issuetable", 7, 2, "No more milk");
        this.gotoIssue("PIG-9");
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue: PIG-9");
        this.selectOption("pid", "Rattus");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: Update Fields");
        this.assertTextPresent("Step 2 is not required");
        this.selectOption("security", "Level KingRat");
        this.submit("Next >>");
        this.assertTextSequence(new String[]{"Project", "Porcine", "Rattus"});
        this.assertTextSequence(new String[]{"Type", "Bug", "Bug"});
        this.assertTextSequence(new String[]{"Security Level", "None", "Level KingRat"});
        this.submit("Move");
        this.assertTextPresent("Level KingRat");
        this.displayAllIssues();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-11");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        this.assertTableCellHasText("issuetable", 1, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-10");
        this.assertTableCellHasText("issuetable", 2, 2, "RAT-8");
        this.assertTableCellHasText("issuetable", 2, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 3, 2, "RAT-8");
        this.assertTableCellHasText("issuetable", 3, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 3, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 4, 1, "RAT-8");
        this.assertTableCellHasText("issuetable", 4, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 4, 11, "Level KingRat");
    }

    public void testWorkflowTransitionSingleIssue() throws SAXException {
        this.assertPrecondition();
        this.clickLinkWithText("RAT-5");
        this.assertTextPresent("Details");
        this.assertTextPresent("RAT-5");
        this.clickLink("action_id_2");
        this.setWorkingForm("issue-workflow-transition");
        this.assertTextPresent("Close Issue");
        this.assertTextPresent("Closing an issue indicates that there is no more work to be done on it, and that it has been verified as complete.");
        this.selectOption("security", "Level KingRat");
        this.submit("Transition");
        this.displayAllIssues();
        this.assertTextNotPresent("Level Mouse");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level KingRat");
        this.clickLinkWithText("RAT-5");
        this.clickLink("action_id_3");
        this.setWorkingForm("issue-workflow-transition");
        this.selectOption("security", "None");
        this.submit("Transition");
        this.displayAllIssues();
        this.assertTextNotPresent("Level KingRat");
        this.assertTextNotPresent("Level Mouse");
        WebTable issueTable = this.getIssuesTable();
        TestReindexingSubtasks.assertEquals((String)"RAT-7", (String)issueTable.getCellAsText(1, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-6", (String)issueTable.getCellAsText(2, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-5", (String)issueTable.getCellAsText(3, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
    }

    public void testBulkEditIssue() {
        this.assertPrecondition();
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10033", "on");
        this.assertTextPresent("Bulk Operation: Choose Issues");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation: Choose Operation");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.checkCheckbox("actions", "security");
        this.selectOption("security", "A");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation: Confirmation");
        this.assertTextSequence(new String[]{"Security Level", "A"});
        this.submit("Confirm");
        this.assertTextPresent("Issue Navigator");
        this.assertTextNotPresent("MyFriendsOnly");
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10033", "on");
        this.checkCheckbox("bulkedit_10041", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.checkCheckbox("actions", "security");
        this.selectOption("security", "MyFriendsOnly");
        this.submit("Next");
        this.assertTextPresent("No more milk");
        this.assertTextPresent("Lets get a third milk bucket");
        this.assertTextSequence(new String[]{"Security Level", "MyFriendsOnly"});
        this.submit("Confirm");
        this.assertPrecondition();
    }

    public void testBulkMoveIssue() throws SAXException {
        this.assertPrecondition();
        this.clickLink("bulkedit_all");
        this.assertTextPresent("Bulk Operation: Choose Issues");
        this.assertTextPresent("Step 1 of 4");
        this.checkCheckbox("bulkedit_10030", "on");
        this.checkCheckbox("bulkedit_10031", "on");
        this.checkCheckbox("bulkedit_10033", "on");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Bulk Operation: Choose Operation", "Step 2 of 4", "Choose the operation you wish to perform on the selected 3 issue(s)."});
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues:", "Select Projects and Issue Types", "Step 3 of 4", "Please note that 1 sub-task issues were removed from the selection and do not appear in the table below. You are not allowed to bulk move sub-task issues together with their parent issue. In this case, you will only be asked to move the sub-task if you move the parent issue to a new project.", "The change will affect 1 issues with issue type(s) Improvement in project(s) Bovine.", "The change will affect 1 issues with issue type(s) Bug in project(s) Rattus."});
        this.selectOption("10000_4_pid", "Canine");
        this.selectOption("10000_4_issuetype", "New Feature");
        this.selectOption("10022_1_pid", "Porcine");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues:", "Select Projects and Issue Types for Sub-Tasks", "Step 3 of 4", "The table below lists all the sub-tasks that need to be moved to a new project. Please select the appropriate issue type for each of them", "The change will affect 3 issues with issue type(s) Sub-task in project(s) Bovine.", "The change will affect 2 issues with issue type(s) Sub-task in project(s) Rattus."});
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues:", "Update Fields for Target Project 'Canine' - Issue Type 'New Feature'", "*Security Level:"});
        this.selectOption("security", "Level Red");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues:", "Update Fields for Target Project 'Canine' - Issue Type 'Sub-task'", "*Security Level:", "The security level of subtasks is inherited from parents."});
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues:", "Update Fields for Target Project 'Porcine' - Issue Type 'Bug'", "*Security Level:", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues:", "Update Fields for Target Project 'Porcine' - Issue Type 'Sub-task'", "*Security Level:", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues: Confirmation", "Step 4 of 4", "Below is a summary of all issues that will be moved. Please confirm that the correct changes have been entered. The bullet points below lists the different target projects and issue types the issues will be moved to. Click on a link below to go to that particular group of issues.", "Target Project", "Canine", "Target Issue Type", "New Feature", "Security Level", "Level Red", "Target Project", "Canine", "Target Issue Type", "Sub-task", "Security Level", "Level Red", "Target Project", "Porcine", "Target Issue Type", "Bug", "Security Level", "None", "Target Project", "Porcine", "Target Issue Type", "Sub-task", "Security Level", "None"});
        this.submit("Next");
        WebTable issueTable = this.getIssuesTable();
        TestReindexingSubtasks.assertEquals((String)"PIG-11", (String)issueTable.getCellAsText(1, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"PIG-10", (String)issueTable.getCellAsText(2, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"PIG-9", (String)issueTable.getCellAsText(3, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"DOG-12", (String)issueTable.getCellAsText(4, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Red", (String)issueTable.getCellAsText(4, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"DOG-11", (String)issueTable.getCellAsText(5, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Red", (String)issueTable.getCellAsText(5, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"DOG-10", (String)issueTable.getCellAsText(6, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Red", (String)issueTable.getCellAsText(6, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"DOG-9", (String)issueTable.getCellAsText(7, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Red", (String)issueTable.getCellAsText(7, 11).trim());
    }

    public void testBulkMoveWithOrphanedSubtasks() throws SAXException {
        this.assertPrecondition();
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", "Another parent");
        this.submit("Create");
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.setFormElement("summary", "Orphan");
        this.submit("Create");
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10051", "on");
        this.checkCheckbox("bulkedit_10033", "on");
        this.checkCheckbox("bulkedit_10040", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues", "Select Projects and Issue Types", "Step 3 of 4", "Please note that 1 sub-task issues were removed from the selection and do not appear in the table below. You are not allowed to bulk move sub-task issues together with their parent issue. In this case, you will only be asked to move the sub-task if you move the parent issue to a new project.", "The change will affect 1 issues with issue type(s) Improvement in project(s) Bovine.", "The change will affect 1 issues with issue type(s) Sub-task in project(s) Bovine.", "Target Project", "Bovine"});
        this.checkCheckbox("sameAsBulkEditBean", "10000_4_");
        this.selectOption("10000_4_pid", "Rattus");
        this.selectOption("10000_4_issuetype", "New Feature");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues", "Select Projects and Issue Types for Sub-Tasks", "Step 3 of 4", "The table below lists all the sub-tasks that need to be moved to a new project. Please select the appropriate issue type for each of them", "The change will affect 3 issues with issue type(s) Sub-task in project(s) Bovine.", "Target Project", "Rattus"});
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues", "Update Fields for Target Project 'Rattus' - Issue Type 'New Feature'", "Step 3 of 4"});
        this.selectOption("security", "Level KingRat");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues", "Update Fields for Target Project 'Rattus' - Issue Type 'Sub-task'", "Step 3 of 4"});
        this.assertTextPresent("The security level of subtasks is inherited from parents.");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Move Issues", "Update Fields for Target Project 'Bovine' - Issue Type 'Sub-task'", "Step 3 of 4"});
        this.assertTextPresent("All field values will be retained.");
        this.submit("Next");
        this.submit("Next");
        WebTable issueTable = this.getIssuesTable();
        TestReindexingSubtasks.assertEquals((String)"RAT-11", (String)issueTable.getCellAsText(1, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(1, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-10", (String)issueTable.getCellAsText(2, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(2, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-9", (String)issueTable.getCellAsText(3, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(3, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-8", (String)issueTable.getCellAsText(4, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(4, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-7", (String)issueTable.getCellAsText(5, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Mouse", (String)issueTable.getCellAsText(5, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-6", (String)issueTable.getCellAsText(6, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Mouse", (String)issueTable.getCellAsText(6, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"RAT-5", (String)issueTable.getCellAsText(7, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"Level Mouse", (String)issueTable.getCellAsText(7, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"COW-39", (String)issueTable.getCellAsText(8, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(8, 11).trim());
        TestReindexingSubtasks.assertEquals((String)"COW-38", (String)issueTable.getCellAsText(9, 1).trim());
        TestReindexingSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(9, 11).trim());
    }

    public void testBulkWorkflowTransitionIssue() {
        this.assertPrecondition();
        this.clickLink("bulkedit_all");
        this.assertTextPresent("Bulk Operation: Choose Issues");
        this.checkCheckbox("bulkedit_10033", "on");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation: Choose Operation");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation: Operation Details");
        this.checkCheckbox("wftransition", "Copy of jira_2_6");
        this.submit("Next");
        this.assertTextSequence(new String[]{"Workflow", "Copy of jira"});
        this.assertTextSequence(new String[]{"Selected Transition", "Close Issue"});
        this.assertTextSequence(new String[]{"Status Transition", "Open", "Closed"});
        this.checkCheckbox("actions", "resolution");
        this.selectOption("resolution", "Fixed");
        this.checkCheckbox("actions", "security");
        this.selectOption("security", "None");
        this.submit("Next");
        this.assertTextSequence(new String[]{"Workflow", "Copy of jira"});
        this.assertTextSequence(new String[]{"Selected Transition", "Close Issue"});
        this.assertTextSequence(new String[]{"Status Transition", "Open", "Closed"});
        this.assertTextSequence(new String[]{"This change will affect", "1", "issues"});
        this.assertTextSequence(new String[]{"Security Level", "None"});
        this.assertTextSequence(new String[]{"Resolution", "Fixed"});
        this.assertTextPresent("COW-35");
        this.submit("Next");
        this.assertTextPresent("Issue Navigator");
        this.assertTextNotPresent("MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 4, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 4, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 4, 6, "Open");
        this.assertTableCellHasText("issuetable", 5, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 5, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 5, 6, "Open");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 6, 6, "Closed");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 7, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 7, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 6, "Open");
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10033", "on");
        this.checkCheckbox("bulkedit_10034", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation: Operation Details");
        this.assertTextSequence(new String[]{"Closed", "Reopened"});
        this.submit("Next");
        this.checkCheckbox("wftransition", "Copy of jira_3_4");
        this.submit("Next");
        this.assertTextSequence(new String[]{"Workflow", "Copy of jira"});
        this.assertTextSequence(new String[]{"Selected Transition", "Reopen Issue"});
        this.assertTextSequence(new String[]{"Status Transition", "Closed", "Reopened"});
        this.assertTextSequence(new String[]{"This change will affect", "1", "issues"});
        this.assertTextSequence(new String[]{"Security Level", "MyFriendsOnly"});
        this.checkCheckbox("actions", "security");
        this.selectOption("security", "MyFriendsOnly");
        this.submit("Next");
        this.assertTextSequence(new String[]{"Workflow", "Copy of jira"});
        this.assertTextSequence(new String[]{"Selected Transition", "Reopen Issue"});
        this.assertTextSequence(new String[]{"Status Transition", "Closed", "Reopened"});
        this.assertTextSequence(new String[]{"This change will affect", "1", "issues"});
        this.assertTextSequence(new String[]{"COW-35", "No more milk"});
        this.submit("Next");
        this.assertTableCellHasText("issuetable", 4, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 4, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 4, 6, "Open");
        this.assertTableCellHasText("issuetable", 4, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 5, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 5, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 5, 6, "Open");
        this.assertTableCellHasText("issuetable", 5, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 6, 6, "Reopened");
        this.assertTableCellHasText("issuetable", 6, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 7, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 7, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 6, "Open");
        this.assertTableCellHasText("issuetable", 7, 11, "MyFriendsOnly");
    }

    public void testConvertSingleIssueToSubtask() {
        this.assertPrecondition();
        this.gotoIssue("COW-34");
        this.clickLink("subtask-to-issue");
        this.assertTextPresent("Convert Sub-task to Issue: COW-34");
        this.selectOption("issuetype", "New Feature");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextSequence(new String[]{"Type", "Sub-task", "New Feature"});
        this.submit("Finish");
        this.assertTextPresent("Get new milk bucket");
        this.assertTextPresentAfterText("COW-35", "Get new milk bucket");
        this.assertTextPresent("MyFriendsOnly");
        this.clickLink("editIssue");
        this.selectOption("security", "None");
        this.submit("Update");
        this.clickLink("return-to-search");
        this.assertTableCellHasText("issuetable", 4, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 4, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 4, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 5, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 5, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 5, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 6, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 7, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 11, "");
        this.gotoIssue("COW-34");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "COW-35");
        this.submit("Next >>");
        this.assertTextPresent("Convert Issue to Sub-task: COW-34");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextSequence(new String[]{"Type", "New Feature", "Sub-task"});
        this.assertTextSequence(new String[]{"Security Level", "None", "MyFriendsOnly"});
        this.submit("Finish");
        this.assertTextPresent("COW-35");
        this.assertTextPresent("MyFriendsOnly");
        this.clickLink("return-to-search");
        this.assertPrecondition();
    }

    private void assertPrecondition() {
        this.displayAllIssues();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 2, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 4, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 4, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 4, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 5, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 5, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 5, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 6, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 7, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 7, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 11, "MyFriendsOnly");
    }

    private WebTable getIssuesTable() throws SAXException {
        return this.getDialog().getResponse().getTableWithID("issuetable");
    }
}

