/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.WebTestCaseWrapper;
import com.meterware.httpunit.WebTable;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestIssueToSubTaskConversionWithFields
extends JIRAWebTest {
    private static final String ISSUE_TO_CONVERT = "CIST-1";
    private static final String ISSUE_PARENT_TASK = "CIST-2";
    private FieldTestData fieldTestData = new FieldTestData();
    private final FieldData field13;
    private final FieldData field23;

    public TestIssueToSubTaskConversionWithFields(String name) {
        super(name);
        this.fieldTestData.add(new FieldData("Field_01", false, false, "10000"));
        this.fieldTestData.add(new FieldData("Field_02", true, true, "10001", "").setEnterValue("this is a normal field with entered value as it exists now"));
        this.fieldTestData.add(new FieldData("Field_03", true, true, "10002", "").setEnterValue("this is a required field with entered value as it exists now"));
        this.fieldTestData.add(new FieldData("Field_04", false, false, "10003"));
        this.fieldTestData.add(new FieldData("Field_05", false, false, "10004"));
        this.fieldTestData.add(new FieldData("Field_06", false, false, "10005"));
        this.fieldTestData.add(new FieldData("Field_07", true, true, "10006", "").setEnterValue("this is a required field with entered value as is not longer hidden"));
        this.fieldTestData.add(new FieldData("Field_08", false, true, "10007", "this is a normal field with value that does not exist in sub-task", ""));
        this.fieldTestData.add(new FieldData("Field_09", false, true, "10008", "this is a normal field with value that is hidden in sub-task", ""));
        this.fieldTestData.add(new FieldData("Field_10", false, false, "10009", "this is a normal field with value that stays a normal field in sub-task"));
        this.fieldTestData.add(new FieldData("Field_11", true, true, "10010", "this is a normal field with value that stays a normal field with *changed* renderer in sub-task", "this is a normal field with value that stays a normal field with <b>changed</b> renderer in sub-task").setRendererChange(true));
        this.fieldTestData.add(new FieldData("Field_12", false, false, "10011", "this is a normal field with value that is a required field in sub-task"));
        this.field13 = new FieldData("Field_13", true, true, "10012", "this is a normal field with value that is a *required* field with changed renderer in sub-task", "this is a normal field with value that is a <b>required</b> field with changed renderer in sub-task").setRendererChange(true);
        this.fieldTestData.add(this.field13);
        this.fieldTestData.add(new FieldData("Field_14", false, false, "10013"));
        this.fieldTestData.add(new FieldData("Field_15", false, false, "10014"));
        this.fieldTestData.add(new FieldData("Field_16", false, false, "10015"));
        this.fieldTestData.add(new FieldData("Field_17", true, true, "10016", "").setEnterValue("this is a required field with entered value as it is required now"));
        this.fieldTestData.add(new FieldData("Field_18", false, true, "10017", "this is a required field with value that does not exist in sub-task", ""));
        this.fieldTestData.add(new FieldData("Field_19", false, true, "10018", "this is a required field with value that is hidden in subtask", ""));
        this.fieldTestData.add(new FieldData("Field_20", false, false, "10019", "this is a required field with value that is a normal field in sub-task"));
        this.fieldTestData.add(new FieldData("Field_21", true, true, "10020", "this is a required field with *value* that is a normal field with changed renderer in sub-task", "this is a required field with <b>value</b> that is a normal field with changed renderer in sub-task").setRendererChange(true));
        this.fieldTestData.add(new FieldData("Field_22", false, false, "10021", "this is a required field with value that stays a required field in sub-task"));
        this.field23 = new FieldData("Field_23", true, true, "10022", "this is a required field with value that stays a required field with changed renderer in *sub-task*", "this is a required field with value that stays a required field with changed renderer in <b>sub-task</b>").setRendererChange(true);
        this.fieldTestData.add(this.field23);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubTaskConversionWithFields.xml");
    }

    public void testIssueToSubTaskConversion() throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this.gotoIssue(ISSUE_TO_CONVERT);
        this.clickLink("issue-to-subtask");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 1);
        this.assertTextPresent("Convert Issue to Sub-task: CIST-1");
        this.setFormElement("parentIssueKey", ISSUE_PARENT_TASK);
        this.selectOption("issuetype", "Mini-task");
        this.submit("Next >>");
        this.assertTextNotPresent("Step 2 of 4");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 3);
        this.fieldTestData.assertFieldsOnFieldUpdateScreen();
        this.fieldTestData.setNewValues();
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 4);
        this.fieldTestData.assertFieldsOnConfirmationScreen();
        this.submit("Finish");
        this.assertSuccessfulConversion();
    }

    public void testIssueToSubTaskConversionWithErrorsCausedByNotEnteringRequiredData() throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this.gotoIssue(ISSUE_TO_CONVERT);
        this.clickLink("issue-to-subtask");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 1);
        this.assertTextPresent("Convert Issue to Sub-task: CIST-1");
        this.assertTextNotPresent("Parent issue key not specified.");
        this.submit("Next >>");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 1);
        this.assertTextPresent("Convert Issue to Sub-task: CIST-1");
        this.assertTextPresent("Parent issue key not specified.");
        this.setFormElement("parentIssueKey", ISSUE_PARENT_TASK);
        this.selectOption("issuetype", "Mini-task");
        this.submit("Next >>");
        this.assertTextNotPresent("Step 2 of 4");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 3);
        this.fieldTestData.assertFieldsOnFieldUpdateScreen();
        this.submit("Next >>");
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Field_03 is required.");
        this.assertTextPresent("Field_07 is required.");
        this.assertTextPresent("Field_17 is required.");
        this.fieldTestData.setNewValues();
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 4);
        this.fieldTestData.assertFieldsOnConfirmationScreen();
        this.submit("Finish");
        this.assertSuccessfulConversion();
    }

    public void testIssueToSubTaskConversionWithErrorsCausedByClearingRequiredData() throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this.gotoIssue(ISSUE_TO_CONVERT);
        this.clickLink("issue-to-subtask");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 1);
        this.assertTextPresent("Convert Issue to Sub-task: CIST-1");
        this.setFormElement("parentIssueKey", ISSUE_PARENT_TASK);
        this.selectOption("issuetype", "Mini-task");
        this.submit("Next >>");
        this.assertTextNotPresent("Step 2 of 4");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 3);
        this.fieldTestData.assertFieldsOnFieldUpdateScreen();
        this.setFormElement("customfield_" + this.field13.id, "");
        this.setFormElement("customfield_" + this.field23.id, "");
        this.submit("Next >>");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 3);
        this.assertTextPresent("Field_13 is required.");
        this.assertTextPresent("Field_23 is required.");
        this.fieldTestData.setNewValues();
        this.setFormElement("customfield_" + this.field13.id, this.field13.value);
        this.setFormElement("customfield_" + this.field23.id, this.field23.value);
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT, 4);
        this.fieldTestData.assertFieldsOnConfirmationScreen();
        this.submit("Finish");
        this.assertSuccessfulConversion();
    }

    private void assertSuccessfulConversion() throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), ISSUE_TO_CONVERT);
        this.text.assertTextPresent(new IdLocator(this.tester, "issue_header_summary"), "Green Sky");
        this.text.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "CIST-2 Super Mother");
        this.text.assertTextPresent(new IdLocator(this.tester, "type-val"), "Mini-task");
        this.fieldTestData.assertFieldsOnSubtask();
        this.assertChangeLog(ISSUE_TO_CONVERT, ISSUE_PARENT_TASK, "Bug", "Mini-task", "changehistory_10010");
        this.fieldTestData.assertChangeLogContainsAllChangedFields("changehistory_10010");
        this.fieldTestData.assertPresentInXMLIssueView();
    }

    private void assertChangeLog(String issue, String parent, String issueType, String subTaskType, String changeLogId) {
        this.gotoIssue(issue);
        if (this.getDialog().isLinkPresentWithText("History")) {
            this.clickLinkWithText("History");
        }
        boolean isParentFound = false;
        boolean isSubTaskTypeFound = false;
        WebTable table = this.getDialog().getWebTableBySummaryOrId(changeLogId);
        for (int row = 0; row < table.getRowCount(); ++row) {
            String first = table.getCellAsText(row, 0).trim();
            if (!isSubTaskTypeFound && "Issue Type".equals(first)) {
                isSubTaskTypeFound = true;
                TestIssueToSubTaskConversionWithFields.assertTrue((boolean)table.getCellAsText(row, 1).trim().startsWith(issueType));
                TestIssueToSubTaskConversionWithFields.assertTrue((boolean)table.getCellAsText(row, 2).trim().startsWith(subTaskType));
            }
            if (isParentFound || !"Parent".equals(first)) continue;
            isParentFound = true;
            TestIssueToSubTaskConversionWithFields.assertEquals((String)"", (String)table.getCellAsText(row, 1).trim());
            TestIssueToSubTaskConversionWithFields.assertTrue((boolean)table.getCellAsText(row, 2).trim().startsWith(parent));
        }
        TestIssueToSubTaskConversionWithFields.assertTrue((String)"Type present in the change log", (boolean)isSubTaskTypeFound);
        TestIssueToSubTaskConversionWithFields.assertTrue((String)"Parent present in the change log", (boolean)isParentFound);
    }

    private static class FieldData {
        protected final String name;
        protected final String id;
        protected final String value;
        protected final String newValue;
        private final boolean isFieldUpdate;
        private final boolean isOnConfirmation;
        protected String enterValue;
        private boolean isRendererChange;

        public FieldData(String name, boolean isFieldUpdate, boolean isOnConfirmation, String id, String value, String newValue) {
            this.name = name;
            this.isFieldUpdate = isFieldUpdate;
            this.isOnConfirmation = isOnConfirmation;
            this.id = id;
            this.value = value == null ? "" : value;
            this.newValue = newValue == null ? "" : newValue;
        }

        public FieldData(String name, boolean isFieldUpdate, boolean isOnConfirmation, String id, String value) {
            this(name, isFieldUpdate, isOnConfirmation, id, value, value);
        }

        public FieldData(String name, boolean isFieldUpdate, boolean isOnConfirmation, String id) {
            this(name, isFieldUpdate, isOnConfirmation, id, null);
        }

        public boolean isInChangeLog() {
            return !this.isRendererChange && (!this.value.equals(this.newValue) || this.enterValue != null);
        }

        public boolean isOnConfirmationScreen() {
            return this.isOnConfirmation;
        }

        public boolean isOnFieldUpdateScreen() {
            return this.isFieldUpdate;
        }

        public boolean hasNewValue() {
            return this.enterValue != null;
        }

        public FieldData setRendererChange(boolean value) {
            this.isRendererChange = value;
            return this;
        }

        public FieldData setEnterValue(String value) {
            this.enterValue = value;
            return this;
        }

        public String toString() {
            return this.id + " - " + this.name;
        }
    }

    private class FieldTestData {
        protected List fieldData = new ArrayList(23);

        private FieldTestData() {
        }

        protected void add(FieldData data) {
            this.fieldData.add(data);
        }

        public void assertFieldsOnFieldUpdateScreen() {
            for (FieldData data : this.fieldData) {
                if (data.isOnFieldUpdateScreen()) {
                    TestIssueToSubTaskConversionWithFields.this.assertTextPresent(data.name);
                    TestIssueToSubTaskConversionWithFields.this.assertFormElementEquals(this.getFieldName(data), data.value);
                    continue;
                }
                TestIssueToSubTaskConversionWithFields.this.assertTextNotPresent(data.name);
                TestIssueToSubTaskConversionWithFields.this.assertFormElementNotPresent(this.getFieldName(data));
            }
        }

        public void assertFieldsOnConfirmationScreen() {
            HashMap<String, String> oldValues = new HashMap<String, String>();
            HashMap<String, String> newValues = new HashMap<String, String>();
            WebTable table = TestIssueToSubTaskConversionWithFields.this.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
            int rowCount = table.getRowCount();
            for (int row = 2; row < rowCount; ++row) {
                String fieldName = table.getCellAsText(row, 0).trim();
                oldValues.put(fieldName, table.getCellAsText(row, 1).trim());
                newValues.put(fieldName, table.getCellAsText(row, 2).trim());
            }
            for (FieldData data : this.fieldData) {
                if (data.isOnConfirmationScreen()) {
                    Assert.assertTrue((String)("Field: " + data.name), (boolean)oldValues.containsKey(data.name));
                    Assert.assertEquals((String)("Old value for: " + data.name), (Object)data.value, oldValues.get(data.name));
                    String newValue = data.enterValue == null ? (data.newValue == null ? "" : data.newValue) : data.enterValue;
                    Assert.assertEquals((String)("New value for: " + data.name), (Object)this.stripHtmlTags(newValue), newValues.get(data.name));
                    continue;
                }
                TestIssueToSubTaskConversionWithFields.this.assertTextNotPresent("Field: " + data.name);
            }
        }

        public void assertChangeLogContainsAllChangedFields(String changeHistoryId) {
            HashMap<String, String> oldValues = new HashMap<String, String>();
            HashMap<String, String> newValues = new HashMap<String, String>();
            WebTable table = TestIssueToSubTaskConversionWithFields.this.getDialog().getWebTableBySummaryOrId(changeHistoryId);
            for (int row = 0; row < table.getRowCount(); ++row) {
                String fieldName = table.getCellAsText(row, 0).trim();
                if (!fieldName.startsWith("Field_")) continue;
                oldValues.put(fieldName, table.getCellAsText(row, 1).trim());
                newValues.put(fieldName, table.getCellAsText(row, 2).trim());
            }
            for (FieldData data : this.fieldData) {
                if (!data.isInChangeLog()) continue;
                String expectedValue = data.enterValue == null ? data.newValue : data.enterValue;
                Assert.assertEquals((String)("Old value of " + data.name + " not present in change log"), (Object)data.value, oldValues.get(data.name));
                Assert.assertEquals((String)("New value of " + data.name + " not present in change log"), (Object)expectedValue, newValues.get(data.name));
            }
        }

        public void assertPresentInXMLIssueView() throws IOException, ParserConfigurationException, SAXException, TransformerException {
            TestIssueToSubTaskConversionWithFields.this.gotoPage("/si/jira.issueviews:issue-xml/CIST-1/CIST-1.xml?jira.issue.searchlocation=index");
            String responseText = TestIssueToSubTaskConversionWithFields.this.getDialog().getResponse().getText();
            WebTestCaseWrapper.log(responseText);
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpathExpression = "//item[parent= &quot;CIST-2&quot; ] ";
            WebTestCaseWrapper.log("Searching for existence of xpath " + xpathExpression);
            XMLAssert.assertXpathExists((String)xpathExpression, (Document)doc);
            xpathExpression = "//item[type= &quot;Mini-task&quot; ] ";
            WebTestCaseWrapper.log("Searching for existence of xpath " + xpathExpression);
            XMLAssert.assertXpathExists((String)xpathExpression, (Document)doc);
            for (FieldData data : this.fieldData) {
                if (!data.isInChangeLog()) continue;
                String expectedValue = data.enterValue == null ? data.newValue : data.enterValue;
                xpathExpression = "//item/customfields/customfield[@id= &quot;customfield_" + data.id + "&quot; ]/customfieldvalues[customfieldvalue= &quot;" + data.value + "&quot; ] ";
                WebTestCaseWrapper.log("Searching for non existence of xpath " + xpathExpression);
                XMLAssert.assertXpathNotExists((String)xpathExpression, (Document)doc);
                if (!TextUtils.stringSet((String)expectedValue)) continue;
                xpathExpression = "//item/customfields/customfield[@id= &quot;customfield_" + data.id + "&quot; ]/customfieldvalues[customfieldvalue= &quot;" + expectedValue + "&quot; ] ";
                WebTestCaseWrapper.log("Searching for existence of xpath " + xpathExpression);
                XMLAssert.assertXpathExists((String)xpathExpression, (Document)doc);
            }
        }

        public void assertFieldsOnSubtask() {
            for (FieldData data : this.fieldData) {
                if (data.enterValue == null && (data.newValue == null || "".equals(data.newValue))) continue;
                TestIssueToSubTaskConversionWithFields.this.assertTextPresent(data.name);
            }
        }

        private String stripHtmlTags(String html) {
            return html.replaceAll("<[^>]*>", "");
        }

        public void setNewValues() {
            for (FieldData data : this.fieldData) {
                if (!data.hasNewValue()) continue;
                TestIssueToSubTaskConversionWithFields.this.setFormElement(this.getFieldName(data), data.enterValue);
            }
        }

        private String getFieldName(FieldData fieldData) {
            return "customfield_" + fieldData.id;
        }
    }
}

