/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestIssueToSubTaskConversionParentPicker
extends FuncTestCase {
    private static final String PROJECT_ID = "10000";
    private static final String ISSUE = "HSP-1";
    private static final String SUBTASK = "HSP-3";
    private static final String PARENT_ISSUE = "HSP-5";
    private static final String ISSUE_FROM_OTHER_PROJECT = "MKY-1";
    private static final String SHOW_ALL_FILTER_ID = "10000";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueToSubTaskConversion.xml");
    }

    public void testIssueToSubTaskConversionParentPickerSameIssue() {
        this.navigation.issueNavigator().loadFilter(Long.parseLong("10000"));
        this.tester.assertLinkPresentWithText(ISSUE);
        this.tester.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.tester.assertLinkNotPresentWithText(ISSUE);
    }

    public void testIssueToSubTaskConversionParentPickerSubTask() {
        this.navigation.issueNavigator().loadFilter(Long.parseLong("10000"));
        this.tester.assertLinkPresentWithText(SUBTASK);
        this.tester.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.tester.assertLinkNotPresentWithText(SUBTASK);
    }

    public void testIssueToSubTaskConversionParentPickerOtherProject() {
        this.navigation.issueNavigator().loadFilter(Long.parseLong("10000"));
        this.tester.assertLinkPresentWithText(ISSUE_FROM_OTHER_PROJECT);
        this.tester.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.tester.assertLinkNotPresentWithText(ISSUE_FROM_OTHER_PROJECT);
    }

    public void testIssueToSubTaskConversionParentPickerNoPermission() {
        this.tester.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.tester.submit();
        this.tester.assertLinkPresentWithText(PARENT_ISSUE);
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.tester.assertLinkNotPresentWithText(PARENT_ISSUE);
    }
}

