/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import java.net.URL;
import java.util.regex.Pattern;

public class TestXsrfLogOut
extends FuncTestCase {
    private static final String LOG_OUT_LINK_ID = "log_out";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testXsrfLogoutFromSeraph() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Seraph", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfLogOut.this.navigation.gotoDashboard();
            }
        }, new XsrfCheck.LinkWithIdSubmission(LOG_OUT_LINK_ID){

            @Override
            public String getLink() throws Exception {
                String baseLink = super.getLink();
                String finalLink = baseLink.replaceFirst(TestXsrfLogOut.this.getEnvironmentData().getContext(), "");
                return finalLink;
            }
        })).run(this.funcTestHelperFactory, "Confirm logout");
    }

    public void testXsrfLogoutFromSeraphWithAnExpiredSession() throws Exception {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.clickLink(LOG_OUT_LINK_ID);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("You have already been logged out of JIRA");
    }

    public void testXsrfLogOutFromSeraphConfirmsLogOutWhenRememberMeIsOn() throws Exception {
        this.navigation.logout();
        this.navigation.login("admin", "admin", true);
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Seraph", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfLogOut.this.navigation.gotoDashboard();
            }
        }, new XsrfCheck.LinkWithIdSubmission(LOG_OUT_LINK_ID){

            @Override
            public String getLink() throws Exception {
                String baseLink = super.getLink();
                String finalLink = baseLink.replaceFirst(TestXsrfLogOut.this.getEnvironmentData().getContext(), "");
                return finalLink;
            }
        })).run(this.funcTestHelperFactory, "Confirm logout");
    }

    public void testXsrfLogoutFromActionViaDefaultCommand() throws Exception {
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Default Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout!default.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.funcTestHelperFactory, "Confirm logout");
    }

    public void testXsrfLogoutFromActionViaDefaultCommandWithAnExpiredSession() throws Exception {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        String tokenValue = this.page.getXsrfToken();
        this.tester.gotoPage("/Logout!default.jspa?atl_token=" + tokenValue);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("You have already been logged out of JIRA");
    }

    public void testXsrfLogoutFromActionViaDefaultCommandWhenRememberMeIsOn() throws Exception {
        this.navigation.logout();
        this.navigation.login("admin", "admin", true);
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Default Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout!default.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.funcTestHelperFactory, "Confirm logout");
    }

    public void testXsrfLogoutFromActionViaExecuteCommand() throws Exception {
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.funcTestHelperFactory, "Confirm logout");
    }

    public void testXsrfLogoutFromActionViaExecuteCommandWithAnExpiredSession() throws Exception {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        String tokenValue = this.page.getXsrfToken();
        this.tester.gotoPage("/Logout.jspa?atl_token=" + tokenValue);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("You have already been logged out of JIRA");
    }

    public void testXsrfLogoutFromActionViaExecuteCommandWhenRememberMeIsOn() throws Exception {
        this.navigation.logout();
        this.navigation.login("admin", "admin", true);
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.funcTestHelperFactory, "Confirm logout");
    }

    private void clearCookies() {
        this.tester.getDialog().getWebClient().clearContents();
    }

    private final class UrlSubmission
    implements XsrfCheck.Submission {
        private FuncTestHelperFactory funcTestHelperFactory;
        private final URL originalUrl;
        private URL urlToSubmit;

        private UrlSubmission(URL originalUrl) {
            String queryString = originalUrl.getQuery();
            String xsrfTokenParameterRegex = ".*?atl_token=.*?";
            if (!Pattern.matches(".*?atl_token=.*?", queryString)) {
                throw new IllegalArgumentException("The URL must contain a XSRF Token parameter");
            }
            this.originalUrl = originalUrl;
            this.urlToSubmit = originalUrl;
        }

        FuncTestHelperFactory getFuncTestHelperFactory() {
            return this.funcTestHelperFactory;
        }

        @Override
        public void init(FuncTestHelperFactory funcTestHelperFactory) {
            this.funcTestHelperFactory = funcTestHelperFactory;
        }

        @Override
        public void removeToken() throws Exception {
            String invalidTokenInUrlString = XsrfCheck.invalidTokenInUrl(this.originalUrl.toString());
            this.urlToSubmit = new URL(invalidTokenInUrlString);
        }

        @Override
        public void submitRequest() throws Exception {
            this.getFuncTestHelperFactory().getTester().gotoPage(this.urlToSubmit.toString());
            this.resetUrlToSubmit();
        }

        private void resetUrlToSubmit() {
            this.urlToSubmit = this.originalUrl;
        }
    }
}

