/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestSignupWithExternalUserManagement
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestSignupWithExternalUserManagement.xml");
    }

    public void testCanSignupWithExternalUserManagementOff() throws Exception {
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("externalUM", "false");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("Log Out");
        this.tester.assertTextPresent("You are now logged out");
        this.tester.gotoPage("login.jsp");
        this.tester.assertTextPresent("Not a member?");
        this.tester.assertTextPresent("Signup");
        this.tester.assertTextNotPresent("to request an account.");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "dude");
        this.tester.setFormElement("password", "dude");
        this.tester.setFormElement("confirm", "dude");
        this.tester.setFormElement("fullname", "Me");
        this.tester.setFormElement("email", "dude@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("You have successfully signed up");
        this.tester.clickLinkWithText("Click here to log in");
        this.tester.assertTextNotPresent("Create Issue");
        this.tester.gotoPage("login.jsp");
        this.tester.setFormElement("os_username", "dude");
        this.tester.setFormElement("os_password", "dude");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.tester.assertTextPresent("Create Issue");
    }

    public void testCantSignupWithExternalUserManagementOn() throws Exception {
        this.tester.clickLinkWithText("Log Out");
        this.tester.assertTextPresent("You are now logged out");
        this.tester.clickLinkWithText("Log in again.");
        this.tester.assertTextNotPresent("Welcome to Rasta JIRA");
        String url = this.tester.getDialog().getResponse().getURL().getPath();
        TestSignupWithExternalUserManagement.assertTrue((boolean)url.endsWith("Dashboard.jspa"));
        this.tester.gotoPage("login.jsp");
        this.tester.assertTextPresent("Not a member?");
        this.tester.assertTextPresent("to request an account.");
        this.tester.assertTextNotPresent("Signup");
        this.tester.setFormElement("os_username", "dude");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.tester.assertTextPresent("Welcome to Rasta JIRA");
        url = this.tester.getDialog().getResponse().getURL().getPath();
        TestSignupWithExternalUserManagement.assertTrue((boolean)url.endsWith("login.jsp"));
        this.tester.assertTextPresent("to request an account.");
        this.tester.assertTextNotPresent("Signup");
    }

    public void testSignupPageBarfsWithExternalUserManagement() throws Exception {
        this.navigation.logout();
        this.tester.gotoPage("secure/Signup!default.jspa");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation that is not allowed in the current JIRA mode.");
        this.tester.assertTextNotPresent("To sign up for JIRA simply enter your details below.");
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("externalUM", "false");
        this.tester.submit("Update");
        this.navigation.logout();
        this.navigation.gotoPage("secure/Signup!default.jspa");
        this.tester.assertTextNotPresent("It seems that you have tried to perform an operation that is not allowed in the current JIRA mode.");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
    }

    public void testGeneralConfigurationChecksValidCombination() throws Exception {
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.selectOption("mode", "Private");
        this.tester.checkCheckbox("externalUM", "true");
        this.tester.submit("Update");
        this.tester.assertTextNotPresent("You cannot select Public Mode if External User Management is enabled.");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.selectOption("mode", "Public");
        this.tester.checkCheckbox("externalUM", "true");
        this.tester.submit("Update");
        this.tester.assertTextPresent("You cannot select Public Mode if External User Management is enabled.");
    }
}

