/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.version;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestEditVersionDetails
extends JIRAWebTest {
    private static final String NAME = "New 1";
    private static final String DESCRIPTION = "New name for version 1";
    private static final String RELEASE_DATE = "6/Jul/07";

    public TestEditVersionDetails(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestEditVersionDetails.xml");
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testEditVersionScheduleBlank() {
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10010");
        this.clickLink("edit_1");
        this.assertTextPresent("Edit Version Details");
        this.assertTextNotPresent("Schedule:");
        this.assertFormElementNotPresent("scheduleAfterVersion");
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10010");
        this.assertTextPresent("Manage Versions");
        this.setFormElement("name", "2");
        this.submit("Add");
        this.clickLink("edit_1");
        this.assertTextPresent("Schedule:");
        this.assertScheduleSelected("-- Before First Version --");
    }

    public void testEditVersionSchedulePopulated() {
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.clickLink("edit_1");
        this.assertScheduleSelected("-- Before First Version --");
        this.assertScheduleNotAvailable("1");
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.clickLink("edit_3");
        this.assertScheduleSelected("1");
        this.assertScheduleNotAvailable("3");
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.clickLink("edit_2");
        this.assertScheduleSelected("3");
        this.assertScheduleNotAvailable("2");
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.clickLink("edit_4");
        this.assertScheduleSelected("2");
        this.assertScheduleNotAvailable("4");
    }

    public void testEditVersionSchedule() {
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.assertTextSequence(new String[]{"edit_4", "edit_2", "edit_3", "edit_1"});
        this.clickLink("edit_4");
        this.assertScheduleSelected("2");
        this.selectOption("scheduleAfterVersion", "1");
        this.submit("Update");
        this.assertTextSequence(new String[]{"edit_2", "edit_3", "edit_4", "edit_1"});
        this.clickLink("edit_4");
        this.assertScheduleSelected("1");
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.assertTextSequence(new String[]{"edit_2", "edit_3", "edit_4", "edit_1"});
        this.clickLink("edit_4");
        this.assertScheduleSelected("1");
        this.selectOption("scheduleAfterVersion", "-- Before First Version --");
        this.submit("Update");
        this.assertTextSequence(new String[]{"edit_2", "edit_3", "edit_1", "edit_4"});
        this.clickLink("edit_4");
        this.assertScheduleSelected("-- Before First Version --");
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.assertTextSequence(new String[]{"edit_2", "edit_3", "edit_1", "edit_4"});
        this.clickLink("edit_4");
        this.assertScheduleSelected("-- Before First Version --");
        this.selectOption("scheduleAfterVersion", "2");
        this.submit("Update");
        this.assertTextSequence(new String[]{"edit_4", "edit_2", "edit_3", "edit_1"});
        this.clickLink("edit_4");
        this.assertScheduleSelected("2");
    }

    public void testEditVersionDetails() {
        this.gotoPage("/secure/project/ManageVersions.jspa?pid=10011");
        this.assertTextPresent("Manage Versions");
        this.assertTextNotPresent(NAME);
        this.assertTextNotPresent(DESCRIPTION);
        this.assertTextNotPresent(RELEASE_DATE);
        this.assertLinkNotPresent("edit_New 1");
        this.clickLink("edit_1");
        this.setFormElement("name", NAME);
        this.setFormElement("description", DESCRIPTION);
        this.setFormElement("releaseDate", RELEASE_DATE);
        this.selectOption("scheduleAfterVersion", "3");
        this.submit("Update");
        this.assertTextPresent("Manage Versions");
        this.assertTextPresent(NAME);
        this.assertTextPresent(DESCRIPTION);
        this.assertTextPresent(RELEASE_DATE);
        this.assertLinkNotPresent("edit_1");
        this.clickLink("edit_New 1");
        this.assertScheduleSelected("3");
        TestEditVersionDetails.assertEquals((String)NAME, (String)this.getDialog().getForm().getParameterValue("name"));
        TestEditVersionDetails.assertEquals((String)DESCRIPTION, (String)this.getDialog().getForm().getParameterValue("description"));
        TestEditVersionDetails.assertEquals((String)RELEASE_DATE, (String)this.getDialog().getForm().getParameterValue("releaseDate"));
    }

    private void assertScheduleSelected(String value) {
        this.assertTextPresent("Edit Version Details");
        this.setWorkingForm("jiraform");
        this.assertOptionSelected("scheduleAfterVersion", value);
    }

    private void assertScheduleNotAvailable(String value) {
        this.assertTextPresent("Edit Version Details");
        this.setWorkingForm("jiraform");
        this.assertOptionNotPresent("scheduleAfterVersion", value);
    }
}

