/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestProjectRoles
extends FuncTestCase {
    public static final String VIEW_PROJECT_ROLES = "View members";
    private static final String ROLE_DESC = "this is a test role";
    private static final String ROLE_NAME = "test role";
    private static final String ROLE_NAME_UPPER_CASE = "Test role";
    private static final String ROLE_UPDATED_NAME = "testing role";
    private static final String ROLE_UPDATED_DESC = "this is an updated description";
    private static final String EDIT_ADMIN_USER_ACTORS = "edit_Administrators_atlassian-user-role-actor";
    private static final String EDIT_ADMIN_GROUP_ACTORS = "edit_Administrators_atlassian-group-role-actor";
    private static final String EDIT_USER_ACTORS = "edit_test role_atlassian-user-role-actor";
    private static final String EDIT_GROUP_ACTORS = "edit_test role_atlassian-group-role-actor";
    private static final String DELETE_ROLE = "delete_test role";
    private static final String APOSTROPHE_ENTITY = "&#39;";
    private static final int PERMISSION_USER_PICKER = 27;

    public void testProjectRoleOperations() {
        this.administration.restoreBlankInstance();
        this.administration.roles().create(ROLE_NAME, ROLE_DESC);
        this.editProjectRole(ROLE_UPDATED_NAME);
        this.editProjectRole(ROLE_NAME_UPPER_CASE);
        this.ensureErrorForDuplicateRoleName();
        this.administration.roles().delete(ROLE_NAME);
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_NAME);
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_DESC);
    }

    public void testProjectRoleActorOperations() {
        this.administration.restoreBlankInstance();
        this.administration.roles().create(ROLE_NAME, ROLE_DESC);
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.assertTextPresent(ROLE_NAME);
        this.editUsersForRole();
        this.ensureErrorsForUsersInRole();
        this.editGroupsForRole();
        this.deleteUsersForRole();
        this.deleteGroupsForRole();
    }

    public void testAddUsersToProjectRoleCaseSensitive() {
        this.administration.restoreBlankInstance();
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_ADMIN_USER_ACTORS);
        this.tester.setFormElement("userNames", "ADMIN");
        this.tester.submit("add");
        this.tester.assertLinkPresent("watcher_link_admin");
        this.tester.assertTextNotPresent("There are currently no users assigned to this project role.");
        this.tester.setFormElement("userNames", "adMIN");
        this.tester.submit("add");
        this.text.assertTextPresentHtmlEncoded("'adMIN' is already a member of the project role.");
    }

    public void testAddGroupsToProjectRoleCaseSensitive() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_ADMIN_GROUP_ACTORS);
        this.tester.setFormElement("groupNames", "JIRA-users");
        this.tester.submit("add");
        this.tester.assertLinkPresent("group_link_jira-users");
        this.tester.assertTextNotPresent("There are currently no groups assigned to this project role.");
        this.tester.setFormElement("groupNames", "jira-USERS");
        this.tester.submit("add");
        this.text.assertTextPresentHtmlEncoded("'jira-USERS' is already a member of the project role.");
    }

    public void testCreateIssueWithRolePermissions() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.tester.assertLinkNotPresent("create_link");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "admin");
        this.tester.submit("add");
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.tester.assertOptionsEqual("pid", new String[]{"homosapien"});
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("monkey");
        this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "admin");
        this.tester.submit("add");
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.tester.assertOptionsEqual("pid", new String[]{"homosapien", "monkey"});
    }

    public void testCreateIssueWithRolePermissionsForGroup() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.tester.assertLinkNotPresent("create_link");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.setFormElement("groupNames", "jira-administrators");
        this.tester.submit("add");
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.tester.assertOptionsEqual("pid", new String[]{"homosapien"});
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("monkey");
        this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.setFormElement("groupNames", "jira-administrators");
        this.tester.submit("add");
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.tester.assertOptionsEqual("pid", new String[]{"homosapien", "monkey"});
    }

    public void testAddDefaultUsersAndDefaultGroupsToRole() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.addAdministratorToDefaultRole();
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "detkin");
        this.tester.submit("add");
        this.tester.assertTextPresent("&#39;detkin&#39; does not exist.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "admin");
        this.tester.submit("add");
        this.tester.assertTextPresent("&#39;admin&#39; is already a member of the project role.");
        this.addGroupsToDefaultRole();
        this.deleteDefaultUsersForRole();
        this.deleteDefaultGroupsForRole();
    }

    public void testDeleteProjectRoleRemovesSchemeEntries() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.deleteProjectRole(true);
        this.tester.clickLink("notification_schemes");
        this.tester.clickLinkWithText("Notifications");
        this.tester.assertTextNotPresent(ROLE_NAME);
        this.administration.permissionSchemes().defaultScheme();
        this.tester.assertTextNotPresent(ROLE_NAME);
        this.administration.issueSecuritySchemes().getScheme("Default Issue Security Scheme");
        this.tester.assertTextNotPresent(ROLE_NAME);
    }

    public void testDeleteProjectRoleWorkflowConditions() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdmin();
        this.tester.clickLink("workflows");
        this.tester.clickLink("steps_live_Copy of jira workflow");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Only users in project role <b>test role</b> can execute this transition.");
        this.tester.clickLink("project_role_browser");
        this.tester.setFormElement("name", "");
        this.tester.clickLink(DELETE_ROLE);
        this.tester.assertTextPresent("The following <strong>1</strong> workflow actions contain conditions that rely on the project role <strong>test role</strong>. If you delete this project role, these conditions will always fail.");
        this.tester.submit("Delete");
        this.tester.clickLink("workflows");
        this.tester.clickLink("steps_live_Copy of jira workflow");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Project Role (id=10000) is missing, now this condition will always fail.");
        this.tester.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira+workflow&workflowMode=live");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.selectOption("jira.projectrole.id", "Users");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Only users in project role <b>Users</b> can execute this transition.");
    }

    public void testDeleteUserRemovesFromProjectRole() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdmin();
        this.editUsersForRole();
        this.addAdministratorToDefaultRole();
        this.administration.usersAndGroups().deleteUser("fred");
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextNotPresent("fred");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextNotPresent("fred");
    }

    public void testDeleteGroupRemovesFromProjectRole() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdmin();
        this.editGroupsForRole();
        this.ensureErrorForDuplicateRoleNameOnEdit();
        this.addGroupsToDefaultRole();
        this.administration.usersAndGroups().deleteGroup("jira-users");
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextNotPresent("jira-users");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextNotPresent("jira-users");
    }

    public void testViewUsages() {
        this.administration.restoreData("TestProjectRoleViewUsages.xml");
        this.gotoViewUsagesForUsersProjectRole();
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//table[@id='relatednotificationschemes']", "Default Notification Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//table[@id='relatednotificationschemes']", "Other Notification Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//table[@id='relatedpermissionschemes']", "Default Permission Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//table[@id='relatedpermissionschemes']", "Other Permission Scheme");
        this.text.assertTextSequence(this.locator.table("relatedpermissionschemes"), new String[]{"Default Permission Scheme", "homosapien", "3 (View)", "monkey", "2 (View)", "test", "1 (View)", "Other Permission Scheme", "None", "None"});
        this.tester.assertLinkPresentWithText("test issue security scheme");
        this.tester.assertLinkPresentWithText("jira workflow");
        this.tester.assertLinkPresentWithText("Start Progress");
        this.tester.assertLinkPresentWithText("Stop Progress");
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("Edit Notifications &mdash; Default Notification Scheme");
        this.tester.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Other Notification Scheme");
        this.tester.assertTextPresent("Edit Notifications &mdash; Other Notification Scheme");
        this.tester.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Other Permission Scheme");
        this.tester.assertTextPresent("Edit Permissions &mdash; Other Permission Scheme");
        this.tester.assertLinkPresentWithText("Grant permission");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.tester.assertLinkPresentWithText("Grant permission");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("test issue security scheme");
        this.tester.assertTextPresent("Edit Issue Security Levels");
        this.tester.assertTextPresent("test security level");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Transition: Start Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Stop Progress");
        this.tester.assertTextPresent("Transition: Stop Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("homosapien");
        this.tester.assertTextPresent("Project: homosapien");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLink("view_project_role_actors_10000");
        this.tester.assertTextPresent("Manage Project Role Membership for Project: homosapien");
    }

    private void gotoViewUsagesForUsersProjectRole() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("view_Users");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleBrowserForProjectAdmin() {
        this.administration.restoreData("TestProjectRoleViewUsages.xml");
        try {
            this.navigation.logout();
            this.navigation.login("fred", "fred");
            this.tester.clickLink("admin_link");
            this.tester.clickLinkWithText("monkey");
            this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
            this.tester.clickLink("edit_Users_atlassian-user-role-actor");
            this.tester.checkCheckbox("removeusers_fred", ".");
            this.tester.submit("remove");
            this.tester.assertTextPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
            this.tester.clickLink("return_link");
            this.tester.clickLink("edit_Users_atlassian-group-role-actor");
            this.tester.setFormElement("groupNames", "jira-users");
            this.tester.submit("add");
            this.tester.clickLink("return_link");
            this.tester.clickLink("edit_Users_atlassian-user-role-actor");
            this.tester.checkCheckbox("removeusers_fred", ".");
            this.tester.submit("remove");
            this.tester.assertTextNotPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleBrowserForNotLoggedInUser() {
        this.administration.restoreData("TestProjectRoleViewUsages.xml");
        try {
            this.navigation.logout();
            this.tester.gotoPage("/secure/project/ViewProjectRoleActors.jspa?projectId=10000");
            this.tester.assertTextPresent("You cannot view this page as a guest.");
            this.tester.gotoPage("/secure/project/UserRoleActorAction.jspa?projectRoleId=10000&projectId=10000");
            this.tester.assertTextPresent("You cannot view this page as a guest.");
            this.tester.gotoPage("/secure/project/GroupRoleActorAction.jspa?projectRoleId=10000&projectId=10000");
            this.tester.assertTextPresent("You cannot view this page as a guest.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleUserRemoveRoleNotInAdminProjectPerm() {
        this.administration.restoreData("TestProjectRoleUserRemoveAdminProjectPerm.xml");
        try {
            this.navigation.logout();
            this.navigation.login("fred", "fred");
            this.tester.clickLink("admin_link");
            this.tester.clickLinkWithText("monkey");
            this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
            this.tester.clickLink("edit_Users_atlassian-user-role-actor");
            this.tester.checkCheckbox("removeusers_fred", ".");
            this.tester.submit("remove");
            this.tester.assertTextNotPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    public void testProjectRoleGroupAddRemoveErrorMessage() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdmin();
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Assign Groups to Project Role: test role");
        this.tester.setFormElement("groupNames", "jira-users");
        this.tester.submit("add");
        this.tester.assertTextPresent("jira-users");
        this.tester.submit("remove");
        this.tester.assertTextPresent("You must select some groups to remove.");
        this.tester.submit("add");
        this.tester.assertTextPresent("You must input some group names to add them to the project role.");
        this.tester.assertTextPresent("jira-users");
    }

    public void testProjectRoleGroupBrowserWithNoBrowserUserPermission() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdmin();
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Assign Groups to Project Role: test role");
        this.tester.assertLinkPresentWithImage("/images/icons/filter_public.gif");
        this.tester.assertLinkNotPresentWithImage("/images/icons/userpicker_disabled.gif");
        this.administration.removeGlobalPermission(27, "jira-developers");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Assign Groups to Project Role: test role");
        this.tester.assertTextPresent("/images/icons/userpicker_disabled.gif");
        this.tester.assertTextNotPresent("/images/icons/filter_public.gif");
    }

    private void addGroupsToDefaultRole() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.assertTextPresent("None selected");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Assign Default Groups to Project Role: test role");
        this.tester.setFormElement("groupNames", "jira-users, jira-developers, jira-administrators");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextPresent("jira-developers");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Project Role Browser");
    }

    private void addAdministratorToDefaultRole() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.assertTextPresent("None selected.");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Default Users to Project Role: test role");
        this.tester.setFormElement("userNames", "admin, fred");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Administrator");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Project Role Browser");
    }

    private void deleteDefaultUsersForRole() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Default Users to Project Role: test role");
        this.tester.checkCheckbox("removeusers_admin", ".");
        this.tester.checkCheckbox("removeusers_fred", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no users assigned to this project role.");
    }

    private void deleteDefaultGroupsForRole() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("project_role_browser");
        this.tester.clickLink("manage_test role");
        this.deleteGroupsFromRoleForm("Assign Default Groups to Project Role: test role");
    }

    private void deleteGroupsForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.deleteGroupsFromRoleForm("Assign Groups to Project Role: test role");
    }

    private void deleteGroupsFromRoleForm(String textPresent) {
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent(textPresent);
        this.tester.checkCheckbox("removegroups_jira-users", ".");
        this.tester.checkCheckbox("removegroups_jira-developers", ".");
        this.tester.checkCheckbox("removegroups_jira-administrators", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no groups assigned to this project role");
    }

    private void deleteUsersForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Users to Project Role: test role");
        this.tester.checkCheckbox("removeusers_admin", ".");
        this.tester.checkCheckbox("removeusers_fred", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no users assigned to this project role.");
    }

    private void ensureErrorsForUsersInRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Users to Project Role: test role");
        this.tester.setFormElement("userNames", "fred, admin, detkin");
        this.tester.submit("add");
        this.tester.assertTextPresent("&#39;detkin&#39; does not exist.");
        this.tester.assertTextPresent("&#39;fred&#39; is already a member of the project role.");
        this.tester.assertTextPresent("&#39;admin&#39; is already a member of the project role.");
        this.tester.clickLink("return_link");
    }

    private void editGroupsForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Assign Groups to Project Role: test role");
        this.tester.setFormElement("groupNames", "jira-users, jira-developers, jira-administrators");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextPresent("jira-developers");
        this.tester.assertTextPresent("jira-administrators");
    }

    private void editUsersForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Users to Project Role: test role");
        this.tester.setFormElement("userNames", "fred, admin");
        this.tester.submit("add");
        this.tester.assertTextPresent("Fred Normal");
        this.tester.assertTextPresent("Administrator");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Fred Normal");
        this.tester.assertTextPresent("Administrator");
    }

    private void deleteProjectRole(boolean checkAssociatedSchemes) {
        this.tester.clickLink(DELETE_ROLE);
        this.tester.assertTextPresent("Are you sure you would like to delete project role");
        this.tester.assertTextPresent(ROLE_NAME);
        if (checkAssociatedSchemes) {
            this.tester.assertLinkPresentWithText("Default Notification Scheme");
            this.tester.assertLinkPresentWithText("Default Permission Scheme");
            this.tester.assertLinkPresentWithText("Default Issue Security Scheme");
            this.tester.assertTextPresent("Copy of jira workflow");
            this.tester.assertLinkPresentWithText("Start Progress");
        }
        this.tester.submit("Delete");
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_NAME);
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_DESC);
    }

    private void ensureErrorForDuplicateRoleName() {
        this.tester.setFormElement("name", ROLE_NAME);
        this.tester.setFormElement("description", "");
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent("A project role with name &#39;test role&#39; already exists.");
    }

    private void ensureErrorForDuplicateRoleNameOnEdit() {
        this.tester.clickLink("project_role_browser");
        this.tester.setFormElement("name", "anotherRole");
        this.tester.setFormElement("description", "test");
        this.tester.submit("Add Project Role");
        this.tester.clickLink("edit_anotherRole");
        this.tester.setFormElement("name", ROLE_NAME);
        this.tester.submit("Update");
        this.tester.assertTextPresent("A project role with name &#39;test role&#39; already exists.");
    }

    private void editProjectRole(String newRoleName) {
        this.administration.roles().edit(ROLE_NAME).setName(newRoleName);
        this.administration.roles().edit(newRoleName).setDescription(ROLE_UPDATED_DESC);
        this.tester.assertTextPresent(newRoleName);
        this.tester.assertTextPresent(ROLE_UPDATED_DESC);
        this.administration.roles().edit(newRoleName).setName(ROLE_NAME);
        this.administration.roles().edit(ROLE_NAME).setDescription(ROLE_DESC);
    }

    private void gotoProjectRoleActorsForProject(String project) {
        this.administration.project().viewProject(project);
        this.tester.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.tester.assertTextPresent("Manage Project Role Membership for Project: " + project);
    }
}

