/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestProjectActions
extends FuncTestCase {
    private String PROJECT_CHIMP = "Chimps";

    public void testAddProject() {
        this.administration.project().addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
        this.text.assertTextPresent(this.locator.page(), "Project: homosapien");
        this.text.assertTextPresent(this.locator.page(), "Components");
        this.text.assertTextPresent(this.locator.page(), "Versions");
        this.administration.project().addProject("neanderthal", "NDT", "", "admin", "project for neanderthals");
        this.text.assertTextPresent(this.locator.page(), "Project: neanderthal");
        this.administration.project().addProject("monkey", "MKY", "", "admin", "project for monkeys");
        this.text.assertTextPresent(this.locator.page(), "Project: monkey");
    }

    public void testAddProjectWithDefaultRoles() {
        this.administration.restoreData("TestProjectActions.xml");
        this.administration.project().addProject(this.PROJECT_CHIMP, "CHM", "", "admin", "project for chimps");
        this.administration.project().viewProject(this.PROJECT_CHIMP);
        this.navigation.clickLinkWithExactText("View members");
        this.text.assertTextPresent(this.locator.page(), " Manage Project Role Membership for Project: Chimps");
        this.text.assertTextPresent(this.locator.page(), "default role");
        this.text.assertTextPresent(this.locator.page(), "Fred Normal");
        this.text.assertTextPresent(this.locator.page(), "Administrator");
        this.text.assertTextPresent(this.locator.page(), "jira-users");
        this.text.assertTextPresent(this.locator.page(), "jira-developers");
    }

    public void testProjectActionInvalidProjectLead() {
        this.log("Project Action: Test for the existence of a warning if a Project Lead is made Unassignable");
        this.administration.permissionSchemes().defaultScheme().removePermission(17, "jira-developers");
        this.administration.project().viewProject(this.PROJECT_CHIMP);
        this.text.assertTextPresent(this.locator.page(), "WARNING: User not Assignable.");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(17, "jira-developers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBrowseProjectWithPermission() {
        try {
            this.administration.permissionSchemes().defaultScheme().removePermission(10, "jira-users");
            this.administration.usersAndGroups().addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
            this.navigation.logout();
            this.navigation.login("bob", "bob_password");
            this._testBrowseProjectWithoutPermission();
        }
        finally {
            try {
                this.navigation.logout();
                this.navigation.login("admin", "admin");
                this.administration.usersAndGroups().deleteUser("bob");
                this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, "jira-users");
            }
            catch (Exception exception) {}
        }
    }

    public void _testBrowseProjectWithoutPermission() {
        this.tester.beginAt("/secure/BrowseProject.jspa");
        this.text.assertTextPresent(this.locator.page(), "You do not have the permissions required to browse any projects.");
    }
}

