/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.WebResponse;
import org.apache.commons.lang.StringUtils;

public class TestEditProject
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestEditProject.xml");
    }

    public void testProjectDoesNotExistAdmin() throws Exception {
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    public void testProjectDoesNotExistNonAdmin() throws Exception {
        this.navigation.logout();
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("You cannot view this page as a guest.");
        this.navigation.login("gandhi");
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertTextNotPresent("You cannot view this URL as a guest.");
    }

    public void testEditProjectSuccess() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Canine");
        String[] projectDetailsEnterprise = new String[]{"Project:", "Canine", "Key:", "DOG", "URL", "No URL", "Project Lead:", "Murray", "Default Assignee", "Project Lead", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "DogSecurityScheme", "Field Configuration Scheme", "System Default Field Configuration", "Issue Type Screen Scheme", "Default Issue Type Screen Scheme", "Workflow Scheme", "None", "CVS Modules", "None", "Project Category", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "Dogs");
        this.tester.setFormElement("url", "http://www.dogs.com");
        this.tester.setFormElement("lead", "admin");
        this.tester.selectOption("assigneeType", "Unassigned");
        this.tester.setFormElement("description", "This is the dog project.");
        this.tester.submit("Update");
        projectDetailsEnterprise = new String[]{"Project:", "Dogs", "This is the dog project.", "Key:", "DOG", "URL", "http://www.dogs.com", "Project Lead:", "Mark", "Default Assignee", "Unassigned", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "DogSecurityScheme", "Field Configuration Scheme", "System Default Field Configuration", "Issue Type Screen Scheme", "Default Issue Type Screen Scheme", "Workflow Scheme", "None", "CVS Modules", "None", "Project Category", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
    }

    public void testEditProjectNameExists() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Canine");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "Bovine");
        this.tester.submit("Update");
        this.tester.assertTextPresent("A project with that name already exists.");
    }

    public void testEditProjectValidation() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Canine");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("lead", "");
        this.tester.setFormElement("url", "badURL");
        this.tester.submit("Update");
        this.tester.assertTextPresent("You must specify a valid project name.");
        this.tester.assertTextPresent("The URL specified is not valid - it must start with http://");
        this.tester.assertTextPresent("You must specify a project lead.");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("lead", "somebaduser");
        this.tester.setFormElement("url", "badURL");
        this.tester.submit("Update");
        this.tester.assertTextPresent("The user you have specified as project lead does not exist.");
    }

    public void testEditProjectNoAccess() {
        this.navigation.logout();
        this.navigation.login("cow", "cow");
        this.tester.gotoPage("secure/admin/EditProject.jspa?pid=10020&name=newproject&lead=admin&atl_token=" + this.page.getXsrfToken());
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.assertTextPresent("Welcome to Dev JIRA");
        this.tester.assertTextNotPresent("Edit Project: Canine");
        this.tester.assertTextNotPresent("Use this page to update your project details.");
    }

    public void testEditProjectDoesntExist() {
        this.tester.gotoPage("secure/admin/EditProject.jspa?pid=10025&name=newproject&lead=admin&atl_token=" + this.page.getXsrfToken());
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    public void testEditProjectChangeNothing() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Canine");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "Canine");
        this.tester.setFormElement("url", "");
        this.tester.setFormElement("lead", "murray");
        this.tester.selectOption("assigneeType", "Project Lead");
        this.tester.setFormElement("description", "");
        this.tester.submit("Update");
        String[] projectDetailsEnterprise = new String[]{"Project:", "Canine", "Key:", "DOG", "URL", "No URL", "Project Lead:", "Murray", "Default Assignee", "Project Lead", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "DogSecurityScheme", "Field Configuration Scheme", "System Default Field Configuration", "Issue Type Screen Scheme", "Default Issue Type Screen Scheme", "Workflow Scheme", "None", "CVS Modules", "None", "Project Category", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
    }

    public void testEditProjectWithAvatar() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Bovine");
        this.tester.clickLink("edit_project");
        this.tester.setFormElement("avatarId", "10008");
        this.tester.submit("Update");
        String avatarImageXpath = "//img[@id='project-avatar']/@src";
        this.assertions.assertNodeExists("//img[@id='project-avatar']/@src");
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//img[@id='project-avatar']/@src");
        String src = xPathLocator.getText();
        String avatarUrlRegex = ".*/secure/projectavatar\\?.*pid=10000&avatarId=10008.*";
        TestEditProject.assertTrue((boolean)src.matches(".*/secure/projectavatar\\?.*pid=10000&avatarId=10008.*"));
        this.navigation.browseProject("COW");
        this.assertions.assertNodeExists("//img[@id='project-avatar']/@src");
        xPathLocator = new XPathLocator(this.tester, "//img[@id='project-avatar']/@src");
        src = xPathLocator.getText();
        TestEditProject.assertTrue((boolean)src.matches(".*/secure/projectavatar\\?.*pid=10000.*"));
        this.tester.gotoPage("secure/projectavatar?pid=10000");
        WebResponse webResponse = this.tester.getDialog().getResponse();
        TestEditProject.assertTrue((String)("Unexpected content-type of [" + webResponse.getHeaderField("content-type") + "]"), (boolean)webResponse.getHeaderField("content-type").matches("image/png(;( )?charset=.*)?"));
        TestEditProject.assertEquals((int)200, (int)webResponse.getResponseCode());
    }

    public void testEditWithFieldsExceeding255() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Canine");
        String[] projectDetailsEnterprise = new String[]{"Project:", "Canine", "Key:", "DOG", "URL", "No URL", "Project Lead:", "Murray", "Default Assignee", "Project Lead", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "DogSecurityScheme", "Field Configuration Scheme", "System Default Field Configuration", "Issue Type Screen Scheme", "Default Issue Type Screen Scheme", "Workflow Scheme", "None", "CVS Modules", "None", "Project Category", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", StringUtils.repeat((String)"N", (int)256));
        this.tester.setFormElement("url", StringUtils.repeat((String)"U", (int)256));
        this.tester.submit("Update");
        this.tester.assertTextPresent("The project name must not exceed 255 characters in length");
        this.tester.assertTextPresent("The URL must not exceed 255 characters in length");
    }
}

