/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.assertions.AssertionsImpl;
import com.atlassian.jira.webtests.WebTesterFactory;
import net.sourceforge.jwebunit.WebTester;

public class TestComponentValidation
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestBrowseProjectRoadmapAndChangeLogTab.xml");
    }

    public void testComponentValidationSwitchingProjectsUnderneath() {
        this.navigation.issue().viewIssue("LOTS-1");
        this.tester.clickLink("editIssue");
        WebTester tester2 = this.getNewTester();
        NavigationImpl navigation2 = new NavigationImpl(tester2, this.environmentData);
        AssertionsImpl assertions2 = new AssertionsImpl(tester2, this.environmentData, navigation2, this.locator);
        navigation2.login("admin");
        navigation2.issue().viewIssue("LOTS-1");
        tester2.clickLink("move-issue");
        tester2.setFormElement("pid", "10051");
        tester2.submit("Next >>");
        tester2.submit("Next >>");
        tester2.submit("Move");
        assertions2.assertNodeExists("//a[@title='Component 1 ']");
        assertions2.getLinkAssertions().assertLinkAtNodeContains("//a[@title='Component 1 ']", "browse/RELEASED/component/10040");
        this.tester.submit("Update");
        this.assertions.assertNodeHasText("//*[@class='error']", "Components Component 1(10030), Component 3(10031) are not valid for project 'All Released'.");
        this.assertions.assertNodeHasText("//*[@id='key-val']", "RELEASED-1");
    }

    public void testComponentValidationNonExistantComponent() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/EditIssue.jspa?id=10000&summary=LOTS-1&components=99&fixVersions=999&assignee=admin&reporter=admin&issuetype=1"));
        this.assertions.assertNodeHasText("//*[@class='error']", "Component with id '99' does not exist.");
    }

    private WebTester getNewTester() {
        WebTester tester2 = WebTesterFactory.createNewWebTester(this.environmentData);
        tester2.beginAt("/");
        return tester2;
    }
}

