/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import org.xml.sax.SAXException;

public class TestBrowseProjectVersionAndComponentTab
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestBrowseProjectVersionTab.xml");
    }

    public void testNoVersionsAndComponents() {
        this.navigation.browseProject("NOVERSIONS");
        this.assertions.assertNodeDoesNotExist("//a[@id='versions-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='roadmap-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='changelog-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='components-panel-panel']");
        this.navigation.browseComponentTabPanel("NOVERSIONS", "Component 1");
        this.assertions.assertNodeDoesNotExist("//a[@id='component-roadmap-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='component-changelog-panel-panel']");
        this.navigation.browseProject("NOCOMPS");
        this.assertions.assertNodeExists("//a[@id='versions-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='roadmap-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='changelog-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='components-panel-panel']");
        this.navigation.browseComponentTabPanel("HSP", "New Component 1");
        this.assertions.assertNodeExists("//a[@id='component-roadmap-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='component-changelog-panel-panel']");
    }

    public void testFieldsAreHidden() {
        this.navigation.browseProject("FFHIDDEN");
        this.assertions.assertNodeDoesNotExist("//a[@id='versions-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='roadmap-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='changelog-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='components-panel-panel']");
        this.navigation.browseComponentTabPanel("FFHIDDEN", "Component 1");
        this.assertions.assertNodeDoesNotExist("//a[@id='component-roadmap-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='component-changelog-panel-panel']");
        this.navigation.browseProject("COMPHIDDEN");
        this.assertions.assertNodeExists("//a[@id='versions-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='roadmap-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='changelog-panel-panel']");
        this.assertions.assertNodeDoesNotExist("//a[@id='components-panel-panel']");
        this.navigation.browseComponentTabPanel("HSP", "New Component 1");
        this.assertions.assertNodeExists("//a[@id='component-roadmap-panel-panel']");
        this.assertions.assertNodeExists("//a[@id='component-changelog-panel-panel']");
    }

    public void testVersionOrder() throws SAXException {
        this.navigation.browseProjectTabPanel("NOCOMPS", "versions");
        TableLocator tableLocator = new TableLocator(this.tester, "versions_panel");
        TestBrowseProjectVersionAndComponentTab.assertEquals((int)4, (int)tableLocator.getTable().getRowCount());
        this.assertVersionRow(1, 10013, "<b>Version 4</b>", "23/Feb/09", "<b>Version 4 description</b>");
        this.assertVersionRow(2, 10012, "V3", "25/Feb/09", "");
        this.assertVersionRow(3, 10011, "Version 2", "", "V2 description");
        this.assertVersionRow(4, 10010, "Version 1", "", "");
        TestBrowseProjectVersionAndComponentTab.assertEquals((String)"No Components - jWebTest JIRA installation", (String)this.tester.getDialog().getResponse().getTitle().trim());
        this.tester.clickLinkWithText("V3");
        this.assertions.assertNodeHasText("//div[@id='content-top']//h1", "No Components");
        this.assertions.assertNodeHasText("//div[@id='content-top']//h2", "V3");
        TestBrowseProjectVersionAndComponentTab.assertEquals((String)"No Components: V3 - jWebTest JIRA installation", (String)this.tester.getDialog().getResponse().getTitle().trim());
    }

    private void assertVersionRow(int row, int versionId, String name, String date, String description) {
        this.assertions.assertNodeHasText("//table[@id='versions_panel']//tr[" + row + "]/td[2]", name);
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith(name, "/browse/NOCOMPS/fixforversion/" + versionId);
        this.assertions.assertNodeHasText("//table[@id='versions_panel']//tr[" + row + "]/td[3]", date);
        this.assertions.assertNodeHasText("//table[@id='versions_panel']//tr[" + row + "]/td[4]/span", description);
    }

    private void assertComponentRow(int row, int versionId, String name, String lead, String description) {
        this.assertions.assertNodeHasText("//table[@id='components_panel']//tr[" + row + "]/td[2]/a", name);
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith(name, "/browse/NOVERSIONS/component/" + versionId);
        this.assertions.assertNodeHasText("//table[@id='components_panel']//tr[" + row + "]/td[3]", lead);
        this.assertions.assertNodeHasText("//table[@id='components_panel']//tr[" + row + "]/td[4]", description);
    }

    public void testComponentsTab() throws SAXException {
        this.navigation.browseProjectTabPanel("NOVERSIONS", "components");
        TableLocator tableLocator = new TableLocator(this.tester, "components_panel");
        TestBrowseProjectVersionAndComponentTab.assertEquals((int)4, (int)tableLocator.getTable().getRowCount());
        this.assertComponentRow(1, 10011, "<b>Component 2</b>", "", "");
        this.assertComponentRow(2, 10010, "Component 1", "Administrator", "Component Description");
        this.assertComponentRow(3, 10012, "Component 3", "Administrator", "");
        this.assertComponentRow(4, 10013, "Component 4", "", "");
        TestBrowseProjectVersionAndComponentTab.assertEquals((String)"No Versions - jWebTest JIRA installation", (String)this.tester.getDialog().getResponse().getTitle().trim());
        this.tester.clickLinkWithText("Component 1");
        this.assertions.assertNodeHasText("//div[@id='content-top']//h1", "No Versions");
        this.assertions.assertNodeHasText("//div[@id='content-top']//h2", "Component 1");
        TestBrowseProjectVersionAndComponentTab.assertEquals((String)"No Versions: Component 1 - jWebTest JIRA installation", (String)this.tester.getDialog().getResponse().getTitle().trim());
    }

    public void testEmptyAndExpandedColumnsInSummary() {
        this.navigation.browseVersionTabPanel("NOCOMPS", "Version 1", "summary");
        this.assertions.assertNodeHasText("//div[@id='primary']", "There is no information to display for the summary of this version. This could be a version with no issues or activity.");
        this.navigation.browseVersionTabPanel("NOCOMPS", "Version 2", "summary");
        this.assertions.assertNodeDoesNotExist("//div[@id='secondary']");
        this.assertions.assertNodeExists("//div[@id='primary']");
        this.navigation.browseComponentTabPanel("NOVERSIONS", "<b>Component 2</b>", "summary");
        this.assertions.assertNodeHasText("//div[@id='primary']", "There is no information to display for the summary of this component. This could be a component with no issues, versions or activity.");
        this.navigation.browseComponentTabPanel("NOVERSIONS", "Component 1", "summary");
        this.assertions.assertNodeDoesNotExist("//div[@id='secondary']");
        this.assertions.assertNodeExists("//div[@id='primary']");
        this.assertions.assertNodeExists("//div[@id='fragcomponentdescription']");
        this.navigation.browseComponentTabPanel("HSP", "New Component 1", "summary");
        this.assertions.assertNodeDoesNotExist("//div[@id='secondary']");
        this.assertions.assertNodeExists("//div[@id='primary']");
        this.assertions.assertNodeExists("//div[@id='fragdueversions']");
    }
}

