/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;

public class TestBrowseProjectPopularTab
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestBrowseProjectPopularTab.xml");
    }

    public void testVotingTurnedOff() {
        this.navigation.browseProject("HSP");
        this.assertions.assertNodeExists("//a[@id='popularissues-panel-panel']");
        this.administration.generalConfiguration().disableVoting();
        this.navigation.browseProject("HSP");
        this.assertions.assertNodeDoesNotExist("//a[@id='popularissues-panel-panel']");
        this.navigation.browseVersionTabPanel("HSP", "New Version 4");
        this.assertions.assertNodeDoesNotExist("//a[@id='version-popularissues-panel-panel']");
        this.navigation.browseComponentTabPanel("HSP", "New Component 2");
        this.assertions.assertNodeDoesNotExist("//a[@id='component-popularissues-panel-panel']");
        this.administration.generalConfiguration().enableVoting();
        this.navigation.browseProject("HSP");
        this.assertions.assertNodeExists("//a[@id='popularissues-panel-panel']");
    }

    public void testNoPopularIssues() {
        this.navigation.browseProjectTabPanel("EMPTY", "popularissues");
        TableLocator tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.navigation.browseVersionTabPanel("EMPTY", "Empty Version", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]", "unresolved issues");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]/a", "resolved issues");
        this.tester.clickLinkWithText("resolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]/a", "unresolved issues");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]", "resolved issues");
        this.navigation.browseComponentTabPanel("EMPTY", "Empty Component", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]", "unresolved issues");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]/a", "resolved issues");
        this.tester.clickLinkWithText("resolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]/a", "unresolved issues");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]", "resolved issues");
        this.navigation.browseProjectTabPanel("UNRESOLVED", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)3, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-1");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-2");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-3");
        this.navigation.browseVersionTabPanel("UNRESOLVED", "Unresolved Version", "popularissues");
        this.tester.clickLinkWithText("unresolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)3, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-1");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-2");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-3");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]", "unresolved issues");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]/a", "resolved issues");
        this.tester.clickLinkWithText("resolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]/a", "unresolved issues");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]", "resolved issues");
        this.navigation.browseComponentTabPanel("UNRESOLVED", "Unresolved Component", "popularissues");
        this.tester.clickLinkWithText("unresolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)3, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-1");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-2");
        this.text.assertTextPresent(tableLocator, "UNRESOLVED-3");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]", "unresolved issues");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]/a", "resolved issues");
        this.tester.clickLinkWithText("resolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]/a", "unresolved issues");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]", "resolved issues");
        this.navigation.browseProjectTabPanel("RESOLVED", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.navigation.browseVersionTabPanel("RESOLVED", "Resolved Version", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)3, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        this.text.assertTextPresent(tableLocator, "RESOLVED-1");
        this.text.assertTextPresent(tableLocator, "RESOLVED-2");
        this.text.assertTextPresent(tableLocator, "RESOLVED-3");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]/a", "unresolved issues");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]", "resolved issues");
        this.tester.clickLinkWithText("unresolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]", "unresolved issues");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]/a", "resolved issues");
        this.navigation.browseComponentTabPanel("RESOLVED", "Resolved Component", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)3, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        this.text.assertTextPresent(tableLocator, "RESOLVED-1");
        this.text.assertTextPresent(tableLocator, "RESOLVED-2");
        this.text.assertTextPresent(tableLocator, "RESOLVED-3");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]/a", "unresolved issues");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]", "resolved issues");
        this.tester.clickLinkWithText("unresolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.assertions.assertNodeDoesNotExist("//ul[@id='resolution-picker']/li[1]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[1]", "unresolved issues");
        this.assertions.assertNodeExists("//ul[@id='resolution-picker']/li[2]/a");
        this.assertions.assertNodeHasText("//ul[@id='resolution-picker']/li[2]/a", "resolved issues");
    }

    public void testNoVotes() {
        this.navigation.browseProjectTabPanel("NOVOTE", "popularissues");
        TableLocator tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.navigation.browseVersionTabPanel("NOVOTE", "No Vote Version", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.tester.clickLinkWithText("resolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.navigation.browseComponentTabPanel("NOVOTE", "No Vote Component", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
        this.tester.clickLinkWithText("resolved issues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
    }

    public void testOrdering() {
        this.navigation.browseProjectTabPanel("HSP", "popularissues");
        TableLocator tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)14, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        int i = 1;
        this.assertRow(i++, 2, "HSP-9");
        this.assertRow(i++, 2, "HSP-10");
        this.assertRow(i++, 2, "HSP-14");
        this.assertRow(i++, 2, "HSP-11");
        this.assertRow(i++, 1, "HSP-2");
        this.assertRow(i++, 1, "HSP-13");
        this.assertRow(i++, 1, "HSP-6");
        this.assertRow(i++, 1, "HSP-8");
        this.assertRow(i++, 1, "HSP-1");
        this.assertRow(i++, 1, "HSP-3");
        this.assertRow(i++, 1, "HSP-7");
        this.assertRow(i++, 1, "HSP-12");
        this.assertRow(i++, 1, "HSP-4");
        this.assertRow(i++, 1, "HSP-5");
        this.navigation.browseVersionTabPanel("HSP", "New Version 1", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)6, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        i = 1;
        this.assertRow(i++, 2, "HSP-10");
        this.assertRow(i++, 2, "HSP-14");
        this.assertRow(i++, 1, "HSP-13");
        this.assertRow(i++, 1, "HSP-1");
        this.assertRow(i++, 1, "HSP-3");
        this.assertRow(i++, 1, "HSP-12");
        this.navigation.browseVersionTabPanel("HSP", "New Version 4", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)6, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        i = 1;
        this.assertRow(i++, 2, "HSP-10");
        this.assertRow(i++, 1, "HSP-13");
        this.assertRow(i++, 1, "HSP-8");
        this.assertRow(i++, 1, "HSP-1");
        this.assertRow(i++, 1, "HSP-7");
        this.assertRow(i++, 1, "HSP-4");
        this.navigation.browseVersionTabPanel("HSP", "New Version 5", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)5, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        i = 1;
        this.assertRow(i++, 2, "HSP-9");
        this.assertRow(i++, 2, "HSP-10");
        this.assertRow(i++, 2, "HSP-11");
        this.assertRow(i++, 1, "HSP-13");
        this.assertRow(i++, 1, "HSP-3");
        this.navigation.browseComponentTabPanel("HSP", "New Component 1", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)5, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        i = 1;
        this.assertRow(i++, 2, "HSP-9");
        this.assertRow(i++, 2, "HSP-10");
        this.assertRow(i++, 2, "HSP-11");
        this.assertRow(i++, 1, "HSP-13");
        this.assertRow(i++, 1, "HSP-1");
        this.navigation.browseComponentTabPanel("HSP", "New Component 2", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)8, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextNotPresent(tableLocator, "No issues.");
        i = 1;
        this.assertRow(i++, 2, "HSP-10");
        this.assertRow(i++, 2, "HSP-14");
        this.assertRow(i++, 1, "HSP-13");
        this.assertRow(i++, 1, "HSP-8");
        this.assertRow(i++, 1, "HSP-3");
        this.assertRow(i++, 1, "HSP-7");
        this.assertRow(i++, 1, "HSP-4");
        this.assertRow(i++, 1, "HSP-5");
        this.navigation.browseComponentTabPanel("HSP", "New Component 3", "popularissues");
        tableLocator = new TableLocator(this.tester, "popular_issues_table");
        TestBrowseProjectPopularTab.assertEquals((int)1, (int)tableLocator.getTable().getRowCount());
        this.text.assertTextPresent(tableLocator, "No issues.");
    }

    private void assertRow(int row, int votes, String key) {
        this.assertCell(row, 1, "" + votes);
        this.assertCell(row, 3, key);
    }

    private void assertCell(int row, int col, String val) {
        this.assertions.assertNodeHasText("//table[@id='popular_issues_table']/tbody/tr[" + row + "]/td[" + col + "]", val);
    }
}

