/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.WebResponse;
import java.net.MalformedURLException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class TestAddProject
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testInvalidData() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("lead", "");
        this.tester.setFormElement("key", "");
        this.tester.setFormElement("url", "abc");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.assertTextPresent("You must specify a valid project name.");
        this.tester.assertTextPresent("You must specify a unique project key, at least 2 characters long, containing only uppercase letters.");
        this.tester.assertTextPresent("You must specify a project lead.");
        this.tester.assertTextPresent("The URL specified is not valid - it must start with http://");
    }

    public void testCreateDuplicateProject() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "homosapien");
        this.tester.setFormElement("lead", "dontexist");
        this.tester.setFormElement("key", "HSP");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.assertTextPresent("A project with that name already exists.");
        this.tester.assertTextPresent("A project with that project key already exists.");
        this.tester.assertTextPresent("The user you have specified as project lead does not exist.");
    }

    public void testSuccess() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.submit("Add");
        String[] projectDetailsEnterprise = new String[]{"Project:", "DUDE", "Key:", "DUD", "URL", "No URL", "Project Lead:", "Administrator", "Default Assignee", "Project Lead", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "None", "Field Configuration Scheme", "System Default Field Configuration", "Issue Type Screen Scheme", "Default Issue Type Screen Scheme", "Workflow Scheme", "None", "CVS Modules", "None", "Project Category", "None"};
        String[] projectDetailsStandard = new String[]{"Project:", "DUDE", "Key:", "DUD", "URL", "No URL", "Project Lead:", "Administrator", "Default Assignee", "Project Lead", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "CVS Module", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
    }

    public void testSuccessWithAllParameters() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.setFormElement("url", "https://studio.atlassian.com/wiki");
        this.tester.setFormElement("description", "This is a really boring description!");
        this.tester.submit("Add");
        String[] projectDetailsEnterprise = new String[]{"Project:", "DUDE", "This is a really boring description!", "Key:", "DUD", "URL", "https://studio.atlassian.com/wiki", "Project Lead:", "Administrator", "Default Assignee", "Project Lead", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "None", "Field Configuration Scheme", "System Default Field Configuration", "Issue Type Screen Scheme", "Default Issue Type Screen Scheme", "Workflow Scheme", "None", "CVS Modules", "None", "Project Category", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
    }

    public void testCreateProjectWithNoDefaultAssignee() {
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("allowUnassigned", "true");
        this.tester.submit("Update");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.selectOption("assigneeType", "Unassigned");
        this.tester.submit("Add");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Project:", "DUDE", "Default Assignee:", "Unassigned"});
    }

    public void testCreateProjectWithPermissionScheme() {
        this.navigation.gotoAdminSection("permission_schemes");
        this.tester.clickLinkWithText("Add Permission Scheme");
        this.tester.setFormElement("name", "High Security");
        this.tester.submit("Add");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.selectOption("permissionScheme", "High Security");
        this.tester.submit("Add");
        String[] projectDetailsEnterprise = new String[]{"Project:", "DUDE", "Key:", "DUD", "Notification Scheme", "None", "Permission Scheme", "High Security", "Issue Security Scheme", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
    }

    public void testCreateProjectWithNotificationScheme() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.selectOption("notificationScheme", "Default Notification Scheme");
        this.tester.submit("Add");
        String[] projectDetailsEnterprise = new String[]{"Project:", "DUDE", "Key:", "DUD", "Notification Scheme", "Default Notification Scheme", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "None"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), projectDetailsEnterprise);
    }

    public void testCreateProjectWithIssueSecurityScheme() {
        this.navigation.gotoAdminSection("security_schemes");
        this.tester.clickLink("add_securityscheme");
        this.tester.setFormElement("name", "My Issue Security");
        this.tester.submit("Add");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.selectOption("issueSecurityScheme", "My Issue Security");
        this.tester.submit("Add");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Project:", "DUDE", "Key:", "DUD", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "My Issue Security"});
    }

    public void testNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/admin/AddProject.jspa?name=newproject&key=NEW&lead=admin");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.tester.assertTextNotPresent("Project: newproject");
        this.tester.assertTextNotPresent("Add A New Project");
    }

    public void testCreateProjectWithAvatar() throws SAXException, MalformedURLException {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.setFormElement("name", "Aeroplane");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "AERO");
        this.tester.setFormElement("avatarId", "10002");
        this.tester.submit("Add");
        String avatarImageXpath = "//img[@id='project-avatar']/@src";
        this.assertions.assertNodeExists("//img[@id='project-avatar']/@src");
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//img[@id='project-avatar']/@src");
        String src = xPathLocator.getText();
        TestAddProject.assertTrue((boolean)src.matches(".*/secure/projectavatar\\?.*pid=10010.*"));
        this.navigation.browseProject("AERO");
        this.assertions.assertNodeExists("//img[@id='project-avatar']/@src");
        xPathLocator = new XPathLocator(this.tester, "//img[@id='project-avatar']/@src");
        src = xPathLocator.getText();
        TestAddProject.assertTrue((boolean)src.matches(".*/secure/projectavatar\\?.*pid=10010.*"));
        this.tester.gotoPage("secure/projectavatar?pid=10010");
        WebResponse webResponse = this.tester.getDialog().getResponse();
        TestAddProject.assertTrue((String)("Unexpected content-type of [" + webResponse.getHeaderField("content-type") + "]"), (boolean)webResponse.getHeaderField("content-type").matches("image/png(;( )?charset=.*)?"));
        TestAddProject.assertEquals((int)200, (int)webResponse.getResponseCode());
    }

    public void testDefaultPermissionSchemeSelectedByDefault() throws Exception {
        this.administration.restoreData("testBrowseProjectCreateIssue.xml");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.setFormElement("name", "DUDE");
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", "DUD");
        this.tester.submit("Add");
        this.tester.assertTextNotPresent("Copy 2 of Default Permission Scheme");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Project:", "DUDE", "Key:", "DUD", "Notification Scheme", "None", "Permission Scheme", "Default Permission Scheme", "Issue Security Scheme", "None"});
    }

    public void testCreateWithFieldsExceeding255() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("add_project");
        this.tester.assertTextPresent("Add A New Project");
        this.tester.setFormElement("name", StringUtils.repeat((String)"N", (int)256));
        this.tester.setFormElement("lead", "admin");
        this.tester.setFormElement("key", StringUtils.repeat((String)"K", (int)256));
        this.tester.setFormElement("url", StringUtils.repeat((String)"U", (int)256));
        this.tester.submit("Add");
        this.tester.assertTextPresent("The project name must not exceed 255 characters in length");
        this.tester.assertTextPresent("The project key must not exceed 255 characters in length");
        this.tester.assertTextPresent("The URL must not exceed 255 characters in length");
    }
}

