/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.WorkflowTestConstants;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="Disabling till we resolve memory leak")
public class TestWorkflowConditionModuleEnabling
extends AbstractReloadablePluginsTest {
    private static final String TEST_ISSUE_NAME = "Test issue";

    private void setUpWorkflowCondition(boolean result) {
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        steps.editTransition(1, 4).addWorkflowCondition(ReferencePluginConstants.WORKFLOW_CONDITION_KEY, (Map<String, String>)ImmutableMap.of((Object)WorkflowTestConstants.REFERENCE_MODULE_RESULT_PARAM, (Object)Boolean.toString(result)));
    }

    private void setUpTestScheme() {
        this.administration.workflowSchemes().goTo().addWorkflowScheme(WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME, WorkflowTestConstants.TEST_WORKFLOW_SCHEME_DESC);
        this.administration.workflowSchemes().goTo().assignWorkflowToAllIssueTypes(WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME);
    }

    public void testShouldNotBeVisibleInTheAdminWorkflowsSectionGivenPluginNotEnabled() throws Exception {
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        TestWorkflowConditionModuleEnabling.assertFalse((boolean)steps.editTransition(1, 4).canAddWorkflowCondition(ReferencePluginConstants.WORKFLOW_CONDITION_KEY));
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenPluginEnabled() throws Exception {
        this.enableReferencePlugin();
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        TestWorkflowConditionModuleEnabling.assertTrue((boolean)steps.editTransition(1, 4).canAddWorkflowCondition(ReferencePluginConstants.WORKFLOW_CONDITION_KEY));
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenTrueCondition() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowCondition(true);
        this.text.assertTextSequence(this.transitionTableTabLocator(), ReferencePluginConstants.WORKFLOW_CONDITION_NAME, "will always return true");
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenFalseCondition() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowCondition(false);
        this.text.assertTextSequence(this.transitionTableTabLocator(), ReferencePluginConstants.WORKFLOW_CONDITION_NAME, "will always return false");
    }

    public void testShouldBeExecutedOnViewIssueAndReturnTrue() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowCondition(true);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionPresent();
    }

    public void testShouldBeExecutedOnViewIssueAndReturnFalse() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowCondition(false);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionNotPresent();
    }

    private void assertStartProgressTransitionPresent() {
        this.tester.assertLinkPresent(WorkflowTestConstants.START_PROGRESS_LINK_ID);
    }

    private void assertStartProgressTransitionNotPresent() {
        this.tester.assertLinkNotPresent(WorkflowTestConstants.START_PROGRESS_LINK_ID);
    }

    private Locator transitionTableTabLocator() {
        return this.locator.id(WorkflowTestConstants.TRANSITION_TAB_TABLE_ID);
    }
}

